/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.operations.AddContentChildOperation;
import org.eclipse.gef4.mvc.operations.AttachToContentAnchorageOperation;
import org.eclipse.gef4.mvc.operations.DetachFromContentAnchorageOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.operations.RemoveContentChildOperation;
import org.eclipse.gef4.mvc.operations.SynchronizeContentAnchoragesOperation;
import org.eclipse.gef4.mvc.operations.SynchronizeContentChildrenOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;

public class ContentPolicy<VR>
extends AbstractPolicy<VR>
implements ITransactional {
    private ForwardUndoCompositeOperation commitOperation;

    public void addContentChild(Object contentChild, int index) {
        ForwardUndoCompositeOperation addOperation = new ForwardUndoCompositeOperation("Add Content Child");
        addOperation.add((IUndoableOperation)new AddContentChildOperation(this.getHost(), contentChild, index));
        addOperation.add((IUndoableOperation)new SynchronizeContentChildrenOperation("Synchronize Children", this.getHost()));
        this.commitOperation.add((IUndoableOperation)addOperation);
    }

    public void attachToContentAnchorage(Object contentAnchorage, String role) {
        ForwardUndoCompositeOperation attachOperation = new ForwardUndoCompositeOperation("Attach To Content Anchorage");
        attachOperation.add((IUndoableOperation)new AttachToContentAnchorageOperation(this.getHost(), contentAnchorage, role));
        attachOperation.add((IUndoableOperation)new SynchronizeContentAnchoragesOperation("Synchronize Anchorages", this.getHost()));
        this.commitOperation.add((IUndoableOperation)attachOperation);
    }

    @Override
    public IUndoableOperation commit() {
        IUndoableOperation commit = this.commitOperation.unwrap();
        this.commitOperation = null;
        return commit;
    }

    public void deleteContent() {
        this.detachAllContentAnchoreds();
        this.detachFromAllContentAnchorages();
        this.removeFromParent();
    }

    public void detachAllContentAnchoreds() {
        ForwardUndoCompositeOperation detachOps = new ForwardUndoCompositeOperation("Detach All Anchoreds");
        for (IVisualPart anchored : this.getHost().getAnchoreds()) {
            ContentPolicy policy;
            if (!(anchored instanceof IContentPart) || (policy = (ContentPolicy)anchored.getAdapter(ContentPolicy.class)) == null) continue;
            policy.init();
            for (String role : anchored.getAnchorages().get((Object)this.getHost())) {
                policy.detachFromContentAnchorage(this.getHost().getContent(), role);
            }
            IUndoableOperation detachOperation = policy.commit();
            if (detachOperation == null) continue;
            detachOps.add(detachOperation);
        }
        IUndoableOperation detachOperation = detachOps.unwrap();
        if (detachOperation != null) {
            this.commitOperation.add(detachOperation);
        }
    }

    public void detachFromAllContentAnchorages() {
        for (IVisualPart anchorage : this.getHost().getAnchorages().keySet()) {
            if (!(anchorage instanceof IContentPart)) continue;
            for (String role : this.getHost().getAnchorages().get((Object)anchorage)) {
                this.detachFromContentAnchorage(((IContentPart)anchorage).getContent(), role);
            }
        }
    }

    public void detachFromContentAnchorage(Object contentAnchorage, String role) {
        ForwardUndoCompositeOperation detachOperation = new ForwardUndoCompositeOperation("Detach From Content Anchorage");
        detachOperation.add((IUndoableOperation)new DetachFromContentAnchorageOperation(this.getHost(), contentAnchorage, role));
        detachOperation.add((IUndoableOperation)new SynchronizeContentAnchoragesOperation("Synchronize Anchorages", this.getHost()));
        this.commitOperation.add((IUndoableOperation)detachOperation);
    }

    @Override
    public IContentPart<VR, ? extends VR> getHost() {
        return (IContentPart)super.getHost();
    }

    @Override
    public void init() {
        this.commitOperation = new ForwardUndoCompositeOperation("Content Change");
    }

    public void removeContentChild(Object contentChild) {
        ForwardUndoCompositeOperation removeOperation = new ForwardUndoCompositeOperation("Remove Content Child");
        removeOperation.add((IUndoableOperation)new RemoveContentChildOperation(this.getHost(), contentChild));
        removeOperation.add((IUndoableOperation)new SynchronizeContentChildrenOperation("Synchronize Children", this.getHost()));
        this.commitOperation.add((IUndoableOperation)removeOperation);
    }

    public void removeFromParent() {
        IUndoableOperation deleteOperation;
        ContentPolicy policy;
        ForwardUndoCompositeOperation deleteOps = new ForwardUndoCompositeOperation("Delete Content");
        if (this.getHost().getParent() instanceof IContentPart && (policy = (ContentPolicy)this.getHost().getParent().getAdapter(ContentPolicy.class)) != null) {
            policy.init();
            policy.removeContentChild(this.getHost().getContent());
            IUndoableOperation removeOperation = policy.commit();
            if (removeOperation != null) {
                deleteOps.add(removeOperation);
            }
        }
        if ((deleteOperation = deleteOps.unwrap()) != null) {
            this.commitOperation.add(deleteOperation);
        }
    }

    @Override
    public void setAdaptable(IVisualPart<VR, ? extends VR> adaptable) {
        if (!(adaptable instanceof IContentPart)) {
            throw new IllegalStateException("A ContentPolicy may only be attached to an IContentPart.");
        }
        super.setAdaptable(adaptable);
    }
}

