/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.parts;

import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class PartUtils {
    public static <T extends IVisualPart<VR, ? extends VR>, VR> List<T> filterParts(Collection<? extends IVisualPart<VR, ? extends VR>> parts, Class<T> type) {
        ArrayList<IVisualPart<VR, VR>> filtered = new ArrayList<IVisualPart<VR, VR>>();
        for (IVisualPart<VR, VR> iVisualPart : parts) {
            if (!type.isInstance(iVisualPart)) continue;
            filtered.add(iVisualPart);
        }
        return filtered;
    }

    public static <VR> List<IVisualPart<VR, ? extends VR>> getAnchoreds(Collection<? extends IVisualPart<VR, ? extends VR>> anchorages) {
        ArrayList<IVisualPart<VR, VR>> anchoreds = new ArrayList<IVisualPart<VR, VR>>();
        for (IVisualPart<VR, VR> a : anchorages) {
            anchoreds.addAll((Collection<IVisualPart<VR, VR>>)a.getAnchoreds());
        }
        return anchoreds;
    }

    public static <VR> Set<IVisualPart<VR, ? extends VR>> getAnchoreds(IVisualPart<VR, ? extends VR> anchorage, String role) {
        HashSet<IVisualPart<VR, VR>> result = new HashSet<IVisualPart<VR, VR>>();
        Multiset<IVisualPart<VR, VR>> anchoreds = anchorage.getAnchoreds();
        for (IVisualPart anchored : anchoreds) {
            if (!anchored.getAnchorages().containsEntry(anchorage, (Object)role)) continue;
            result.add(anchored);
        }
        return result;
    }
}

