/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.mvc.parts.AbstractVisualPart;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractContentPart<VR, V extends VR>
extends AbstractVisualPart<VR, V>
implements IContentPart<VR, V> {
    private Object content;

    @Override
    public void addContentChild(Object contentChild, int index) {
        throw new UnsupportedOperationException("Need to implement addContentChild(Object, int) for " + this.getClass());
    }

    @Override
    public void attachToContentAnchorage(Object contentAnchorage, String role) {
        throw new UnsupportedOperationException("Need to implement attachToContentAnchorage(Object, String) for " + this.getClass());
    }

    @Override
    public void detachFromContentAnchorage(Object contentAnchorage, String role) {
        throw new UnsupportedOperationException("Need to implement detachFromContentAnchorage(Object, String) for " + this.getClass());
    }

    @Override
    public Object getContent() {
        return this.content;
    }

    @Override
    public SetMultimap<? extends Object, String> getContentAnchorages() {
        return HashMultimap.create();
    }

    @Override
    public List<? extends Object> getContentChildren() {
        return Collections.emptyList();
    }

    @Override
    protected void register(IViewer<VR> viewer) {
        super.register(viewer);
        if (this.content != null) {
            this.registerAtContentPartMap(viewer, this.content);
        }
    }

    protected void registerAtContentPartMap(IViewer<VR> viewer, Object content) {
        viewer.getContentPartMap().put(content, this);
    }

    @Override
    public void removeContentChild(Object contentChild, int index) {
        throw new UnsupportedOperationException("Need to implement removeContentChild(Object, int) for " + this.getClass());
    }

    @Override
    public void setContent(Object content) {
        if (this.content == content) {
            return;
        }
        Object oldContent = this.content;
        if (oldContent != null && oldContent != content && this.getViewer() != null) {
            this.unregisterFromContentPartMap(this.getViewer(), oldContent);
        }
        this.content = content;
        if (content != null && content != oldContent && this.getViewer() != null) {
            this.registerAtContentPartMap(this.getViewer(), content);
        }
        this.pcs.firePropertyChange("content", oldContent, content);
    }

    @Override
    protected void unregister(IViewer<VR> viewer) {
        super.unregister(viewer);
        if (this.content != null) {
            this.unregisterFromContentPartMap(viewer, this.content);
        }
    }

    protected void unregisterFromContentPartMap(IViewer<VR> viewer, Object content) {
        Map<Object, IContentPart<VR, VR>> registry = viewer.getContentPartMap();
        if (registry.get(content) != this) {
            throw new IllegalArgumentException("Not registered under content");
        }
        registry.remove(content);
    }
}

