/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class ChangeFocusOperation<VR>
extends AbstractOperation {
    public static final String DEFAULT_LABEL = "Change Focus";
    private IViewer<VR> viewer;
    private IContentPart<VR, ? extends VR> oldFocused;
    private IContentPart<VR, ? extends VR> newFocused;

    public ChangeFocusOperation(IViewer<VR> viewer, IContentPart<VR, ? extends VR> newFocused) {
        this(DEFAULT_LABEL, viewer, ((FocusModel)viewer.getAdapter(FocusModel.class)).getFocused(), newFocused);
    }

    public ChangeFocusOperation(IViewer<VR> viewer, IContentPart<VR, ? extends VR> oldFocused, IContentPart<VR, ? extends VR> newFocused) {
        this(DEFAULT_LABEL, viewer, oldFocused, newFocused);
    }

    public ChangeFocusOperation(String label, IViewer<VR> viewer, IContentPart<VR, ? extends VR> oldFocused, IContentPart<VR, ? extends VR> newFocused) {
        super(label);
        this.viewer = viewer;
        this.oldFocused = oldFocused;
        this.newFocused = newFocused;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ((FocusModel)this.viewer.getAdapter(FocusModel.class)).setFocused(this.newFocused);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ((FocusModel)this.viewer.getAdapter(FocusModel.class)).setFocused(this.oldFocused);
        return Status.OK_STATUS;
    }
}

