/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.gef4.mvc.parts.IContentPart;

public class SelectionModel<VR>
implements IPropertyChangeNotifier {
    public static final String SELECTION_PROPERTY = "selection";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private List<IContentPart<VR, ? extends VR>> selectionList = new ArrayList<IContentPart<VR, ? extends VR>>();
    private Set<IContentPart<VR, ? extends VR>> selectionSet = new HashSet<IContentPart<VR, ? extends VR>>();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void appendSelection(List<? extends IContentPart<VR, ? extends VR>> contentParts) {
        List<IContentPart<VR, VR>> oldSelection = this.getSelectionCopy();
        for (IContentPart<VR, VR> iContentPart : contentParts) {
            if (this.selectionSet.contains(iContentPart)) continue;
            this.selectionList.add(iContentPart);
            this.selectionSet.add(iContentPart);
        }
        this.propertyChangeSupport.firePropertyChange(SELECTION_PROPERTY, oldSelection, this.getSelected());
    }

    public void deselect(Collection<? extends IContentPart<VR, ? extends VR>> contentParts) {
        List<IContentPart<VR, VR>> oldSelection = this.getSelectionCopy();
        this.selectionList.removeAll(contentParts);
        this.selectionSet.removeAll(contentParts);
        this.propertyChangeSupport.firePropertyChange(SELECTION_PROPERTY, oldSelection, this.getSelected());
    }

    public void deselectAll() {
        List<IContentPart<VR, VR>> oldSelection = this.getSelectionCopy();
        this.selectionList.clear();
        this.selectionSet.clear();
        this.propertyChangeSupport.firePropertyChange(SELECTION_PROPERTY, oldSelection, this.getSelected());
    }

    public List<IContentPart<VR, ? extends VR>> getSelected() {
        return Collections.unmodifiableList(this.selectionList);
    }

    private List<IContentPart<VR, ? extends VR>> getSelectionCopy() {
        return new ArrayList<IContentPart<VR, ? extends VR>>(this.selectionList);
    }

    public boolean isSelected(IContentPart<VR, ? extends VR> contentPart) {
        return this.selectionSet.contains(contentPart);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void select(List<? extends IContentPart<VR, ? extends VR>> additionalSelected) {
        List<IContentPart<VR, VR>> oldSelection = this.getSelectionCopy();
        this.selectionList.removeAll(additionalSelected);
        this.selectionSet.removeAll(additionalSelected);
        int i = 0;
        for (IContentPart<VR, VR> iContentPart : additionalSelected) {
            if (this.selectionSet.contains(iContentPart)) continue;
            this.selectionList.add(i++, iContentPart);
            this.selectionSet.add(iContentPart);
        }
        this.propertyChangeSupport.firePropertyChange(SELECTION_PROPERTY, oldSelection, this.getSelected());
    }

    public void updateSelection(List<? extends IContentPart<VR, ? extends VR>> newSelection) {
        this.selectionList.clear();
        this.selectionSet.clear();
        this.select(newSelection);
    }
}

