/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.convert.swt;

import org.eclipse.gef4.geometry.convert.awt.Geometry2AWT;
import org.eclipse.gef4.geometry.convert.swt.AWT2SWT;
import org.eclipse.gef4.geometry.internal.utils.PointListUtils;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polygon;
import org.eclipse.gef4.geometry.planar.Polyline;
import org.eclipse.gef4.geometry.planar.Ring;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;

public class Geometry2SWT {
    public static final PathData toSWTPathData(Path p) {
        return AWT2SWT.toSWTPathData(Geometry2AWT.toAWTPath((Path)p).getPathIterator(null));
    }

    public static final org.eclipse.swt.graphics.Point toSWTPoint(Point p) {
        return new org.eclipse.swt.graphics.Point((int)p.x, (int)p.y);
    }

    public static final int[] toSWTPointArray(Line l) {
        return PointListUtils.toIntegerArray((double[])PointListUtils.toCoordinatesArray((Point[])l.getPoints()));
    }

    private static final int[] toSWTPointArray(Point[] points, Point centroid) {
        int[] SWTPointArray = new int[points.length * 2];
        int i = 0;
        while (i < points.length) {
            SWTPointArray[2 * i] = (int)(points[i].x < centroid.x ? Math.floor(points[i].x) : Math.ceil(points[i].x));
            SWTPointArray[2 * i + 1] = (int)(points[i].y < centroid.y ? Math.floor(points[i].y) : Math.ceil(points[i].y));
            ++i;
        }
        return SWTPointArray;
    }

    public static final int[] toSWTPointArray(Polygon p) {
        return Geometry2SWT.toSWTPointArray(p.getPoints(), p.getCentroid());
    }

    public static final int[] toSWTPointArray(Polyline p) {
        return Geometry2SWT.toSWTPointArray(p.getPoints(), p.getCentroid());
    }

    public static final Rectangle toSWTRectangle(org.eclipse.gef4.geometry.planar.Rectangle r) {
        return new Rectangle((int)Math.floor(r.getX()), (int)Math.floor(r.getY()), (int)Math.ceil(r.getWidth() + r.getX() - Math.floor(r.getX())), (int)Math.ceil(r.getHeight() + r.getY() - Math.floor(r.getY())));
    }

    public static final Region toSWTRegion(org.eclipse.gef4.geometry.planar.Region r) {
        Region swtRegion = new Region();
        org.eclipse.gef4.geometry.planar.Rectangle[] rectangleArray = r.getShapes();
        int n = rectangleArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.eclipse.gef4.geometry.planar.Rectangle rect = rectangleArray[n2];
            swtRegion.add(Geometry2SWT.toSWTRectangle(rect));
            ++n2;
        }
        return swtRegion;
    }

    public static Region toSWTRegion(Ring r) {
        Region region = new Region();
        Polyline[] polylineArray = r.getOutlines();
        int n = polylineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Polyline p = polylineArray[n2];
            region.add(Geometry2SWT.toSWTPointArray(p));
            ++n2;
        }
        return region;
    }

    private Geometry2SWT() {
    }
}

