/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.OrthogonalRouter;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Polyline;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.behaviors.SelectionBehavior;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.parts.FXCircleSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.parts.FXRectangleSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.parts.FXSquareSegmentHandlePart;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IHandlePartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXDefaultSelectionHandlePartFactory
implements IHandlePartFactory<Node> {
    public static final String INSERT_HANDLE_COLOR_PROVIDER = "INSERT_HANDLE_COLOR_PROVIDER";
    public static final Color DEFAULT_INSERT_HANDLE_COLOR = Color.WHITE;
    public static final String MOVE_HANDLE_COLOR_PROVIDER = "MOVE_HANDLE_COLOR_PROVIDER";
    public static final Color DEFAULT_MOVE_HANDLE_COLOR = Color.web((String)"#7986cb");
    public static final String CONNECTED_HANDLE_COLOR_PROVIDER = "CONNECTED_HANDLE_COLOR_PROVIDER";
    public static final Color DEFAULT_CONNECTED_HANDLE_COLOR = Color.RED;
    public static final String SELECTION_HANDLES_GEOMETRY_PROVIDER = "SELECTION_HANDLES_GEOMETRY_PROVIDER";
    protected static final double BENDPOINT_CREATE_HANDLE_MINIMUM_SEGMENT_LENGTH = 30.0;
    protected static final double SEGMENT_MOVE_HANDLE_MINIMUM_SEGMENT_LENGTH = 5.0;
    protected static final double SEGMENT_CREATE_HANDLE_MINIMUM_SEGMENT_LENGTH = 45.0;
    @Inject
    private Injector injector;

    private static Provider<BezierCurve[]> createSegmentsProvider(final Provider<? extends IGeometry> geometryProvider) {
        return new Provider<BezierCurve[]>(){

            public BezierCurve[] get() {
                IGeometry geometry = (IGeometry)geometryProvider.get();
                if (geometry instanceof IShape) {
                    ArrayList<BezierCurve> segments = new ArrayList<BezierCurve>();
                    ICurve[] iCurveArray = ((IShape)geometry).getOutlineSegments();
                    int n = iCurveArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICurve os = iCurveArray[n2];
                        segments.addAll(Arrays.asList(os.toBezier()));
                        ++n2;
                    }
                    return segments.toArray(new BezierCurve[0]);
                }
                if (geometry instanceof ICurve) {
                    return ((ICurve)geometry).toBezier();
                }
                throw new IllegalStateException("Unable to deduce segments from geometry: Expected IShape or ICurve but got: " + geometry);
            }
        };
    }

    public List<IHandlePart<Node, ? extends Node>> createHandleParts(List<? extends IVisualPart<Node, ? extends Node>> targets, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        if (!(contextBehavior instanceof SelectionBehavior)) {
            throw new IllegalArgumentException("The FXDefaultSelectionHandlePartFactory can only generate handle parts in the context of a SelectionBehavior, but the context behavior is a <" + contextBehavior + ">.");
        }
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Part factory is called without targets.");
        }
        if (targets.size() == 1) {
            return this.createSingleSelectionHandleParts(targets.get(0), contextBehavior, contextMap);
        }
        return this.createMultiSelectionHandleParts(targets, contextBehavior, contextMap);
    }

    protected List<IHandlePart<Node, ? extends Node>> createMultiSelectionHandleParts(final List<? extends IVisualPart<Node, ? extends Node>> targets, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        Provider<IGeometry> handleGeometryProvider = new Provider<IGeometry>(){

            public IGeometry get() {
                return FXPartUtils.getUnionedVisualBoundsInScene(targets);
            }
        };
        ArrayList<IHandlePart<Node, ? extends Node>> handleParts = new ArrayList<IHandlePart<Node, ? extends Node>>();
        Provider<BezierCurve[]> segmentsProvider = FXDefaultSelectionHandlePartFactory.createSegmentsProvider((Provider<? extends IGeometry>)handleGeometryProvider);
        int i = 0;
        while (i < 4) {
            FXSquareSegmentHandlePart part = (FXSquareSegmentHandlePart)this.injector.getInstance(FXSquareSegmentHandlePart.class);
            part.setSegmentsProvider(segmentsProvider);
            part.setSegmentIndex(i);
            part.setSegmentParameter(0.0);
            handleParts.add((IHandlePart<Node, ? extends Node>)part);
            ++i;
        }
        return handleParts;
    }

    protected List<IHandlePart<Node, ? extends Node>> createSingleSelectionHandleParts(final IVisualPart<Node, ? extends Node> target, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        IGeometry selectionHandlesGeometry;
        final Provider selectionHandlesGeometryInTargetLocalProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_HANDLES_GEOMETRY_PROVIDER));
        IGeometry iGeometry = selectionHandlesGeometry = selectionHandlesGeometryInTargetLocalProvider != null ? (IGeometry)selectionHandlesGeometryInTargetLocalProvider.get() : null;
        if (selectionHandlesGeometry == null) {
            return Collections.emptyList();
        }
        Provider<IGeometry> selectionHandlesGeometryInSceneProvider = new Provider<IGeometry>(){

            public IGeometry get() {
                return NodeUtils.localToScene((Node)((Node)target.getVisual()), (IGeometry)((IGeometry)selectionHandlesGeometryInTargetLocalProvider.get()));
            }
        };
        Provider<BezierCurve[]> selectionHandlesSegmentsInSceneProvider = FXDefaultSelectionHandlePartFactory.createSegmentsProvider((Provider<? extends IGeometry>)selectionHandlesGeometryInSceneProvider);
        if (selectionHandlesGeometry instanceof ICurve) {
            return this.createSingleSelectionHandlePartsForCurve(target, contextBehavior, contextMap, selectionHandlesSegmentsInSceneProvider);
        }
        if (selectionHandlesGeometry instanceof IShape) {
            if (selectionHandlesGeometry instanceof Rectangle) {
                return this.createSingleSelectionHandlePartsForRectangularOutline(target, contextBehavior, contextMap, selectionHandlesSegmentsInSceneProvider);
            }
            return this.createSingleSelectionHandlePartsForPolygonalOutline(target, contextBehavior, contextMap, selectionHandlesSegmentsInSceneProvider);
        }
        throw new IllegalStateException("Unable to generate handles for this handle geometry. Expected ICurve or IShape, but got: " + selectionHandlesGeometry);
    }

    protected List<IHandlePart<Node, ? extends Node>> createSingleSelectionHandlePartsForCurve(IVisualPart<Node, ? extends Node> target, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        ArrayList<IHandlePart<Node, ? extends Node>> hps = new ArrayList<IHandlePart<Node, ? extends Node>>();
        BezierCurve[] segments = (BezierCurve[])segmentsProvider.get();
        if (target.getVisual() instanceof Connection && ((Connection)target.getVisual()).getRouter() instanceof OrthogonalRouter) {
            int i = 0;
            while (i < segments.length) {
                AbstractFXSegmentHandlePart part;
                double segmentLength;
                if (i == 0) {
                    FXCircleSegmentHandlePart part2 = (FXCircleSegmentHandlePart)this.injector.getInstance(FXCircleSegmentHandlePart.class);
                    part2.setSegmentsProvider(segmentsProvider);
                    part2.setSegmentIndex(i);
                    part2.setSegmentParameter(0.0);
                    hps.add((IHandlePart<Node, ? extends Node>)part2);
                }
                if ((segmentLength = new Polyline(segments[i].getPoints()).getLength()) > 45.0) {
                    part = (FXRectangleSegmentHandlePart)this.injector.getInstance(FXRectangleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(0.25);
                    hps.add((IHandlePart<Node, ? extends Node>)part);
                }
                if (segmentLength > 5.0) {
                    FXRectangleSegmentHandlePart midPart = (FXRectangleSegmentHandlePart)this.injector.getInstance(FXRectangleSegmentHandlePart.class);
                    midPart.setSegmentsProvider(segmentsProvider);
                    midPart.setSegmentIndex(i);
                    midPart.setSegmentParameter(0.5);
                    hps.add((IHandlePart<Node, ? extends Node>)midPart);
                }
                if (segmentLength > 45.0) {
                    part = (FXRectangleSegmentHandlePart)this.injector.getInstance(FXRectangleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(0.75);
                    hps.add((IHandlePart<Node, ? extends Node>)part);
                }
                if (i == segments.length - 1) {
                    part = (FXCircleSegmentHandlePart)this.injector.getInstance(FXCircleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(1.0);
                    hps.add((IHandlePart<Node, ? extends Node>)part);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < segments.length) {
                FXCircleSegmentHandlePart part = (FXCircleSegmentHandlePart)this.injector.getInstance(FXCircleSegmentHandlePart.class);
                part.setSegmentsProvider(segmentsProvider);
                part.setSegmentIndex(i);
                part.setSegmentParameter(0.0);
                hps.add((IHandlePart<Node, ? extends Node>)part);
                double segmentLength = new Polyline(segments[i].getPoints()).getLength();
                if (segmentLength >= 30.0) {
                    part = (FXCircleSegmentHandlePart)this.injector.getInstance(FXCircleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(0.5);
                    hps.add((IHandlePart<Node, ? extends Node>)part);
                }
                if (i == segments.length - 1) {
                    part = (FXCircleSegmentHandlePart)this.injector.getInstance(FXCircleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(1.0);
                    hps.add((IHandlePart<Node, ? extends Node>)part);
                }
                ++i;
            }
        }
        return hps;
    }

    protected List<IHandlePart<Node, ? extends Node>> createSingleSelectionHandlePartsForPolygonalOutline(IVisualPart<Node, ? extends Node> target, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        ArrayList<IHandlePart<Node, ? extends Node>> handleParts = new ArrayList<IHandlePart<Node, ? extends Node>>();
        BezierCurve[] segments = (BezierCurve[])segmentsProvider.get();
        int i = 0;
        while (i < segments.length) {
            FXCircleSegmentHandlePart part = (FXCircleSegmentHandlePart)this.injector.getInstance(FXCircleSegmentHandlePart.class);
            part.setSegmentsProvider(segmentsProvider);
            part.setSegmentIndex(i);
            part.setSegmentParameter(0.0);
            handleParts.add((IHandlePart<Node, ? extends Node>)part);
            ++i;
        }
        return handleParts;
    }

    protected List<IHandlePart<Node, ? extends Node>> createSingleSelectionHandlePartsForRectangularOutline(IVisualPart<Node, ? extends Node> target, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        ArrayList<IHandlePart<Node, ? extends Node>> hps = new ArrayList<IHandlePart<Node, ? extends Node>>();
        BezierCurve[] segments = (BezierCurve[])segmentsProvider.get();
        int i = 0;
        while (i < segments.length) {
            FXSquareSegmentHandlePart part = (FXSquareSegmentHandlePart)this.injector.getInstance(FXSquareSegmentHandlePart.class);
            part.setSegmentsProvider(segmentsProvider);
            part.setSegmentIndex(i);
            part.setSegmentParameter(0.0);
            hps.add((IHandlePart<Node, ? extends Node>)part);
            ++i;
        }
        return hps;
    }
}

