/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.behaviors.HoverBehavior;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.fx.parts.FXCircleSegmentHandlePart;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IHandlePartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXDefaultHoverHandlePartFactory
implements IHandlePartFactory<Node> {
    public static final String HOVER_HANDLES_GEOMETRY_PROVIDER = "HOVER_HANDLES_GEOMETRY_PROVIDER";
    @Inject
    private Injector injector;

    public List<IHandlePart<Node, ? extends Node>> createHandleParts(List<? extends IVisualPart<Node, ? extends Node>> targets, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        IGeometry hoverHandlesGeometry;
        if (!(contextBehavior instanceof HoverBehavior)) {
            throw new IllegalArgumentException("The FXDefaultHoverHandlePartFactory can only generate handle parts in the context of a HoverBehavior, but the context behavior is a <" + contextBehavior + ">.");
        }
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Part factory is called without targets.");
        }
        if (targets.size() > 1) {
            throw new IllegalStateException("Cannot create hover handles for more than one target.");
        }
        final IVisualPart<Node, ? extends Node> target = targets.get(0);
        final Provider hoverHandlesGeometryInTargetLocalProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)HOVER_HANDLES_GEOMETRY_PROVIDER));
        IGeometry iGeometry = hoverHandlesGeometry = hoverHandlesGeometryInTargetLocalProvider != null ? (IGeometry)hoverHandlesGeometryInTargetLocalProvider.get() : null;
        if (hoverHandlesGeometry == null) {
            return Collections.emptyList();
        }
        Provider<IGeometry> hoverHandlesGeometryInSceneProvider = new Provider<IGeometry>(){

            public IGeometry get() {
                return NodeUtils.localToScene((Node)((Node)target.getVisual()), (IGeometry)((IGeometry)hoverHandlesGeometryInTargetLocalProvider.get()));
            }
        };
        Provider<BezierCurve[]> hoverHandlesSegmentsInSceneProvider = new Provider<BezierCurve[]>((Provider)hoverHandlesGeometryInSceneProvider){
            private final /* synthetic */ Provider val$hoverHandlesGeometryInSceneProvider;
            {
                this.val$hoverHandlesGeometryInSceneProvider = provider;
            }

            public BezierCurve[] get() {
                IGeometry handleGeometry = (IGeometry)this.val$hoverHandlesGeometryInSceneProvider.get();
                if (handleGeometry instanceof IShape) {
                    ArrayList<BezierCurve> segments = new ArrayList<BezierCurve>();
                    ICurve[] iCurveArray = ((IShape)handleGeometry).getOutlineSegments();
                    int n = iCurveArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICurve os = iCurveArray[n2];
                        segments.addAll(Arrays.asList(os.toBezier()));
                        ++n2;
                    }
                    return segments.toArray(new BezierCurve[0]);
                }
                if (handleGeometry instanceof ICurve) {
                    return ((ICurve)handleGeometry).toBezier();
                }
                throw new IllegalStateException("Unable to determine handle position: Expected IShape or ICurve but got: " + handleGeometry);
            }
        };
        if (hoverHandlesGeometry instanceof ICurve) {
            return this.createHoverHandlePartsForCurve(target, contextBehavior, contextMap, hoverHandlesSegmentsInSceneProvider);
        }
        if (hoverHandlesGeometry instanceof IShape) {
            if (hoverHandlesGeometry instanceof Rectangle) {
                return this.createHoverHandlePartsForRectangularOutline(target, contextBehavior, contextMap, hoverHandlesSegmentsInSceneProvider);
            }
            return this.createHoverHandlePartsForPolygonalOutline(target, contextBehavior, contextMap, hoverHandlesSegmentsInSceneProvider);
        }
        throw new IllegalStateException("Unable to generate handles for this handle geometry. Expected ICurve or IShape, but got: " + hoverHandlesGeometry);
    }

    protected List<IHandlePart<Node, ? extends Node>> createHoverHandlePartsForCurve(IVisualPart<Node, ? extends Node> target, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        return Collections.emptyList();
    }

    protected List<IHandlePart<Node, ? extends Node>> createHoverHandlePartsForPolygonalOutline(IVisualPart<Node, ? extends Node> target, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        ArrayList<IHandlePart<Node, ? extends Node>> handleParts = new ArrayList<IHandlePart<Node, ? extends Node>>();
        BezierCurve[] segments = (BezierCurve[])segmentsProvider.get();
        int i = 0;
        while (i < segments.length) {
            FXCircleSegmentHandlePart part = (FXCircleSegmentHandlePart)this.injector.getInstance(FXCircleSegmentHandlePart.class);
            part.setSegmentsProvider(segmentsProvider);
            part.setSegmentIndex(i);
            part.setSegmentParameter(0.0);
            handleParts.add((IHandlePart<Node, ? extends Node>)part);
            ++i;
        }
        return handleParts;
    }

    protected List<IHandlePart<Node, ? extends Node>> createHoverHandlePartsForRectangularOutline(IVisualPart<Node, ? extends Node> target, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        return Collections.emptyList();
    }
}

