/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.behaviors;

import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXConnectionClickableAreaBehavior
extends AbstractBehavior<Node> {
    private static final double ABSOLUTE_CLICKABLE_WIDTH = 8.0;
    private DoubleBinding clickableAreaBinding;
    private final ChangeListener<? super Number> scaleXListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            FXConnectionClickableAreaBehavior.this.clickableAreaBinding.invalidate();
        }
    };

    protected void doActivate() {
        this.clickableAreaBinding = new DoubleBinding(){

            protected double computeValue() {
                double localClickableWidth = 8.0 / ((FXViewer)FXConnectionClickableAreaBehavior.this.getHost().getRoot().getViewer()).getCanvas().getContentTransform().getMxx();
                return Math.min(localClickableWidth, 8.0);
            }
        };
        ((GeometryNode)((Connection)this.getHost().getVisual()).getCurve()).clickableAreaWidthProperty().bind((ObservableValue)this.clickableAreaBinding);
        ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentTransform().mxxProperty().addListener(this.scaleXListener);
    }

    protected void doDeactivate() {
        this.clickableAreaBinding.dispose();
        ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentTransform().mxxProperty().removeListener(this.scaleXListener);
    }

    public IVisualPart<Node, Connection> getHost() {
        return super.getHost();
    }
}

