/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.CubicCurve;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;

public class QuadraticCurve
extends BezierCurve {
    private static final long serialVersionUID = 1L;

    public QuadraticCurve(double ... coordinates) {
        this(coordinates[0], coordinates[1], coordinates[2], coordinates[3], coordinates[4], coordinates[5]);
        if (coordinates.length != 6) {
            throw new IllegalArgumentException("A QuadraticCurve may only be defined by 6 coordinates (3 points), while " + coordinates.length + " were passed in.");
        }
    }

    public QuadraticCurve(double x1, double y1, double ctrlX, double ctrlY, double x2, double y2) {
        super(x1, y1, ctrlX, ctrlY, x2, y2);
    }

    public QuadraticCurve(Point ... points) {
        this(points[0], points[1], points[2]);
        if (points.length != 3) {
            throw new IllegalArgumentException("A QuadraticCurve may only be defined by three points, while " + points.length + " were passed in.");
        }
    }

    public QuadraticCurve(Point p1, Point pCtrl, Point p2) {
        this(p1.x, p1.y, pCtrl.x, pCtrl.y, p2.x, p2.y);
    }

    @Override
    public QuadraticCurve getCopy() {
        return new QuadraticCurve(this.getP1(), this.getCtrl(), this.getP2());
    }

    public Point getCtrl() {
        return new Point(this.getCtrlX(), this.getCtrlY());
    }

    public double getCtrlX() {
        return this.getPoint((int)1).x;
    }

    public double getCtrlY() {
        return this.getPoint((int)1).y;
    }

    @Override
    public CubicCurve getElevated() {
        Point[] controlPoints = new Point[]{this.getP1(), this.getP1().getScaled(0.3333333333333333).getTranslated(this.getCtrl().getScaled(0.6666666666666666)), this.getCtrl().getScaled(0.6666666666666666).getTranslated(this.getP2().getScaled(0.3333333333333333)), this.getP2()};
        return new CubicCurve(controlPoints);
    }

    @Override
    public QuadraticCurve getTransformed(AffineTransform t) {
        return new QuadraticCurve(t.getTransformed(this.getPoints()));
    }

    public QuadraticCurve setCtrl(Point ctrl) {
        this.setCtrlX(ctrl.x);
        this.setCtrlY(ctrl.y);
        return this;
    }

    public QuadraticCurve setCtrlX(double ctrlX) {
        this.setPoint(1, new Point(ctrlX, this.getCtrlY()));
        return this;
    }

    public QuadraticCurve setCtrlY(double ctrlY) {
        this.setPoint(1, new Point(this.getCtrlX(), ctrlY));
        return this;
    }

    public QuadraticCurve[] split(double t) {
        BezierCurve[] split = super.split(t);
        return new QuadraticCurve[]{split[0].toQuadratic(), split[1].toQuadratic()};
    }

    @Override
    public Path toPath() {
        Path p = new Path();
        p.moveTo(this.getX1(), this.getY1());
        p.quadTo(this.getCtrlX(), this.getCtrlY(), this.getX2(), this.getY2());
        return p;
    }

    @Override
    public String toString() {
        return "QuadraticCurve(x1 = " + this.getX1() + ", y1 = " + this.getY1() + ", ctrlX = " + this.getCtrlX() + ", ctrlY = " + this.getCtrlY() + ", x2 = " + this.getX2() + ", y2 = " + this.getY2() + ")";
    }
}

