/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.parts;

import java.util.Map;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXHandlePart;
import org.eclipse.gef4.mvc.fx.policies.FXHoverOnHoverPolicy;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXHoverHandleRootPart
extends AbstractFXHandlePart<VBox> {
    public FXHoverHandleRootPart() {
        this.setAdapter(new FXHoverOnHoverPolicy(){

            public void hover(MouseEvent e) {
            }
        });
    }

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((VBox)this.getVisual()).getChildren().add(index, (Object)((Node)child.getVisual()));
        for (Map.Entry anchorage : this.getAnchoragesUnmodifiable().entries()) {
            child.attachToAnchorage((IVisualPart)anchorage.getKey(), (String)anchorage.getValue());
        }
    }

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        super.attachToAnchorageVisual(anchorage, role);
        for (IVisualPart child : this.getChildrenUnmodifiable()) {
            child.attachToAnchorage(anchorage, role);
        }
    }

    protected VBox createVisual() {
        VBox vBox = new VBox();
        vBox.setPickOnBounds(true);
        return vBox;
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        super.detachFromAnchorageVisual(anchorage, role);
        for (IVisualPart child : this.getChildrenUnmodifiable()) {
            child.detachFromAnchorage(anchorage, role);
        }
    }

    protected void doRefreshVisual(VBox visual) {
        ObservableSetMultimap anchorages = this.getAnchoragesUnmodifiable();
        if (anchorages.isEmpty()) {
            return;
        }
        IVisualPart anchorage = (IVisualPart)anchorages.keys().iterator().next();
        this.refreshHandleLocation((Node)anchorage.getVisual());
    }

    protected void refreshHandleLocation(Node hostVisual) {
        Bounds hostBounds = hostVisual.getBoundsInParent();
        Parent parent = hostVisual.getParent();
        if (parent != null) {
            hostBounds = parent.localToScene(hostBounds);
        }
        Point2D location = ((VBox)this.getVisual()).getParent().sceneToLocal(hostBounds.getMaxX(), hostBounds.getMinY());
        ((VBox)this.getVisual()).setLayoutX(location.getX());
        ((VBox)this.getVisual()).setLayoutY(location.getY());
    }

    protected void registerAtVisualPartMap(IViewer<Node> viewer, VBox visual) {
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((VBox)this.getVisual()).getChildren().remove(index);
    }

    protected void unregisterFromVisualPartMap(IViewer<Node> viewer, VBox visual) {
    }
}

