/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Affine;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.examples.logo.model.AbstractFXGeometricElement;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricShape;
import org.eclipse.gef4.mvc.examples.logo.parts.AbstractFXGeometricElementPart;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.parts.IResizableContentPart;
import org.eclipse.gef4.mvc.parts.ITransformableContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXGeometricShapePart
extends AbstractFXGeometricElementPart<GeometryNode<IShape>>
implements ITransformableContentPart<Node, GeometryNode<IShape>>,
IResizableContentPart<Node, GeometryNode<IShape>> {
    private final ChangeListener<? super Paint> fillObserver = new ChangeListener<Paint>(){

        public void changed(ObservableValue<? extends Paint> observable, Paint oldValue, Paint newValue) {
            FXGeometricShapePart.this.refreshVisual();
        }
    };

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
    }

    protected GeometryNode<IShape> createVisual() {
        return new GeometryNode();
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        this.getContent().fillProperty().addListener(this.fillObserver);
    }

    protected void doAddContentChild(Object contentChild, int index) {
    }

    protected void doAttachToContentAnchorage(Object contentAnchorage, String role) {
        if (!(contentAnchorage instanceof AbstractFXGeometricElement)) {
            throw new IllegalArgumentException("Cannot attach to content anchorage: wrong type!");
        }
        this.getContent().getAnchorages().add((AbstractFXGeometricElement)contentAnchorage);
    }

    @Override
    protected void doDeactivate() {
        this.getContent().fillProperty().removeListener(this.fillObserver);
        super.doDeactivate();
    }

    protected void doDetachFromContentAnchorage(Object contentAnchorage, String role) {
        this.getContent().getAnchorages().remove(contentAnchorage);
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        HashMultimap anchorages = HashMultimap.create();
        for (AbstractFXGeometricElement<? extends IGeometry> anchorage : this.getContent().getAnchorages()) {
            anchorages.put(anchorage, (Object)"link");
        }
        return anchorages;
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    @Override
    protected void doRefreshVisual(GeometryNode<IShape> visual) {
        AffineTransform transform;
        FXGeometricShape content = this.getContent();
        if (visual.getGeometry() != content.getGeometry()) {
            visual.setGeometry((IGeometry)((IShape)content.getGeometry()));
        }
        if ((transform = content.getTransform()) != null) {
            Affine affine = (Affine)((Provider)this.getAdapter(FXTransformPolicy.TRANSFORM_PROVIDER_KEY)).get();
            affine.setMxx(transform.getM00());
            affine.setMxy(transform.getM01());
            affine.setMyx(transform.getM10());
            affine.setMyy(transform.getM11());
            affine.setTx(transform.getTranslateX());
            affine.setTy(transform.getTranslateY());
        }
        if (visual.getStroke() != content.getStroke()) {
            visual.setStroke(content.getStroke());
        }
        if (visual.getStrokeWidth() != content.getStrokeWidth()) {
            visual.setStrokeWidth(content.getStrokeWidth());
        }
        if (visual.getFill() != content.getFill()) {
            visual.setFill(content.getFill());
        }
        super.doRefreshVisual(visual);
    }

    protected void doRemoveContentChild(Object contentChild) {
    }

    protected void doReorderContentChild(Object contentChild, int newIndex) {
    }

    @Override
    public FXGeometricShape getContent() {
        return (FXGeometricShape)super.getContent();
    }

    public void resizeContent(Dimension size) {
        IShape geometry = (IShape)this.getContent().getGeometry();
        Rectangle geometricBounds = geometry.getBounds();
        double sx = size.width / geometricBounds.getWidth();
        double sy = size.height / geometricBounds.getHeight();
        ((IScalable)geometry).scale(sx, sy, geometricBounds.getX(), geometricBounds.getY());
    }

    public void setContent(Object model) {
        if (model != null && !(model instanceof FXGeometricShape)) {
            throw new IllegalArgumentException("Only IShape models are supported.");
        }
        super.setContent(model);
    }

    public void transformContent(AffineTransform transform) {
        this.getContent().setTransform(this.getContent().getTransform().preConcatenate(transform));
    }
}

