/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.swt.gestures;

import com.sun.javafx.tk.TKSceneListener;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.application.Platform;
import javafx.embed.swt.FXCanvas;
import javafx.event.EventType;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.ZoomEvent;
import org.eclipse.gef4.common.reflect.ReflectionUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SWT2FXEventConverter {
    private FXCanvas canvas;
    private Display display;
    private GestureState currentGestureState;
    private GestureListener gestureListener = new GestureListener(){

        public void gesture(GestureEvent event) {
            SWT2FXEventConverter.this.sendGestureEventToFx(event);
        }
    };
    private Listener emulatedMouseWheelEventFilter = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget == SWT2FXEventConverter.this.canvas) {
                if (SWT2FXEventConverter.this.display.getTouchEnabled() && SWT2FXEventConverter.this.lastPanGestureEvent != null && ((SWT2FXEventConverter)SWT2FXEventConverter.this).lastPanGestureEvent.x == event.x && ((SWT2FXEventConverter)SWT2FXEventConverter.this).lastPanGestureEvent.y == event.y) {
                    event.type = 0;
                } else if (event.type == 38) {
                    SWT2FXEventConverter.this.sendMouseHorizontalWheelEventToFx(event);
                }
            }
        }
    };
    private Listener emulatedPanGestureEventFilter = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget == SWT2FXEventConverter.this.canvas && event.detail == 64) {
                if (event.xDirection == 0 && event.yDirection == 0) {
                    event.type = 0;
                } else {
                    SWT2FXEventConverter.this.lastPanGestureEvent = event;
                }
            }
        }
    };
    private Event lastPanGestureEvent;

    public SWT2FXEventConverter(FXCanvas canvas) {
        this.canvas = canvas;
        this.currentGestureState = new GestureState(GestureStateType.IDLE);
        canvas.addGestureListener(this.gestureListener);
        this.display = canvas.getDisplay();
        this.display.addFilter(48, this.emulatedPanGestureEventFilter);
        this.display.addFilter(37, this.emulatedMouseWheelEventFilter);
        this.display.addFilter(38, this.emulatedMouseWheelEventFilter);
    }

    protected boolean changeState(GestureStateType newStateType, GestureEvent event, TKSceneListener sceneListener) {
        if (newStateType != this.currentGestureState.type) {
            switch (this.currentGestureState.type) {
                case SCROLLING: {
                    this.sendScrollEvent((EventType<ScrollEvent>)ScrollEvent.SCROLL_FINISHED, event, sceneListener);
                    break;
                }
                case ROTATING: {
                    this.sendRotateEvent((EventType<RotateEvent>)RotateEvent.ROTATION_FINISHED, event, sceneListener);
                    break;
                }
                case ZOOMING: {
                    this.sendZoomEvent((EventType<ZoomEvent>)ZoomEvent.ZOOM_FINISHED, event, sceneListener);
                }
            }
            switch (newStateType) {
                case SCROLLING: {
                    this.sendScrollEvent((EventType<ScrollEvent>)ScrollEvent.SCROLL_STARTED, event, sceneListener);
                    break;
                }
                case ROTATING: {
                    this.sendRotateEvent((EventType<RotateEvent>)RotateEvent.ROTATION_STARTED, event, sceneListener);
                    break;
                }
                case ZOOMING: {
                    this.sendZoomEvent((EventType<ZoomEvent>)ZoomEvent.ZOOM_STARTED, event, sceneListener);
                    break;
                }
                case IDLE: {
                    if (event.detail != 16) break;
                    this.sendSwipeEvent(event, sceneListener);
                }
            }
            this.currentGestureState = new GestureState(newStateType);
            return true;
        }
        switch (newStateType) {
            case SCROLLING: {
                this.sendScrollEvent((EventType<ScrollEvent>)ScrollEvent.SCROLL, event, sceneListener);
                break;
            }
            case ROTATING: {
                this.sendRotateEvent((EventType<RotateEvent>)RotateEvent.ROTATE, event, sceneListener);
                break;
            }
            case ZOOMING: {
                this.sendZoomEvent((EventType<ZoomEvent>)ZoomEvent.ZOOM, event, sceneListener);
                break;
            }
            case IDLE: {
                if (event.detail != 16) break;
                this.sendSwipeEvent(event, sceneListener);
            }
        }
        return false;
    }

    public void dispose() {
        Display display = this.canvas.getDisplay();
        if (this.emulatedPanGestureEventFilter != null) {
            display.removeFilter(48, this.emulatedPanGestureEventFilter);
        }
        if (this.emulatedMouseWheelEventFilter != null) {
            display.removeFilter(37, this.emulatedMouseWheelEventFilter);
            display.removeFilter(38, this.emulatedMouseWheelEventFilter);
        }
        this.canvas.removeGestureListener(this.gestureListener);
        this.canvas = null;
    }

    private boolean isAlt(Event event) {
        return (event.stateMask & 0x10000) != 0;
    }

    private boolean isAlt(GestureEvent event) {
        return (event.stateMask & 0x10000) != 0;
    }

    private boolean isControl(Event event) {
        return (event.stateMask & 0x40000) != 0;
    }

    private boolean isControl(GestureEvent event) {
        return (event.stateMask & 0x40000) != 0;
    }

    private boolean isMeta(Event event) {
        return (event.stateMask & 0x400000) != 0;
    }

    private boolean isMeta(GestureEvent event) {
        return (event.stateMask & 0x400000) != 0;
    }

    private boolean isShift(Event event) {
        return (event.stateMask & 0x20000) != 0;
    }

    private boolean isShift(GestureEvent event) {
        return (event.stateMask & 0x20000) != 0;
    }

    protected void scheduleSceneRunnable(final ISceneRunnable sr) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                final Object scenePeer = ReflectionUtils.getPrivateFieldValue((Object)SWT2FXEventConverter.this.canvas, (String)"scenePeer");
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        TKSceneListener sceneListener = (TKSceneListener)ReflectionUtils.getPrivateFieldValue((Object)scenePeer, (String)"sceneListener");
                        if (sceneListener == null) {
                            return null;
                        }
                        sr.run(sceneListener);
                        return null;
                    }
                }, (AccessControlContext)ReflectionUtils.getPrivateFieldValue((Object)scenePeer, (String)"accessCtrlCtx"));
            }
        });
    }

    protected void sendGestureEventToFx(final GestureEvent event) {
        this.scheduleSceneRunnable(new ISceneRunnable(){

            @Override
            public void run(TKSceneListener sceneListener) {
                switch (event.detail) {
                    case 2: {
                        break;
                    }
                    case 4: {
                        SWT2FXEventConverter.this.changeState(GestureStateType.IDLE, event, sceneListener);
                        break;
                    }
                    case 32: {
                        SWT2FXEventConverter.this.changeState(GestureStateType.ZOOMING, event, sceneListener);
                        break;
                    }
                    case 64: {
                        SWT2FXEventConverter.this.changeState(GestureStateType.SCROLLING, event, sceneListener);
                        break;
                    }
                    case 8: {
                        SWT2FXEventConverter.this.changeState(GestureStateType.ROTATING, event, sceneListener);
                        break;
                    }
                    case 16: {
                        SWT2FXEventConverter.this.changeState(GestureStateType.IDLE, event, sceneListener);
                    }
                }
            }
        });
    }

    private void sendHorizontalScrollEvent(Event event, TKSceneListener sceneListener) {
        Point screenPosition = this.canvas.toDisplay(event.x, event.y);
        sceneListener.scrollEvent(ScrollEvent.SCROLL, (double)(event.count > 0 ? 8 : -8), 0.0, 0.0, 0.0, 5.0, 5.0, 0, 0, 0, 0, 0, (double)event.x, (double)event.y, (double)screenPosition.x, (double)screenPosition.y, this.isShift(event), this.isControl(event), this.isAlt(event), this.isMeta(event), false, false);
    }

    protected void sendMouseHorizontalWheelEventToFx(final Event event) {
        this.scheduleSceneRunnable(new ISceneRunnable(){

            @Override
            public void run(TKSceneListener sceneListener) {
                SWT2FXEventConverter.this.sendHorizontalScrollEvent(event, sceneListener);
            }
        });
    }

    private void sendRotateEvent(EventType<RotateEvent> fxEventType, GestureEvent event, TKSceneListener sceneListener) {
        Point screenPosition = this.canvas.toDisplay(event.x, event.y);
        double rotation = fxEventType == RotateEvent.ROTATION_FINISHED ? this.currentGestureState.lastRotation : -event.rotation;
        sceneListener.rotateEvent(fxEventType, rotation - this.currentGestureState.lastRotation, rotation, (double)event.x, (double)event.y, (double)screenPosition.x, (double)screenPosition.y, this.isShift(event), this.isControl(event), this.isAlt(event), this.isMeta(event), false, false);
        this.currentGestureState.lastRotation = rotation;
    }

    private void sendScrollEvent(EventType<ScrollEvent> fxEventType, GestureEvent event, TKSceneListener sceneListener) {
        this.currentGestureState.totalScrollX += (double)event.xDirection;
        this.currentGestureState.totalScrollY += (double)event.yDirection;
        Point screenPosition = this.canvas.toDisplay(event.x, event.y);
        double multiplierCorrection = 1.0;
        if ("cocoa".equals(SWT.getPlatform()) && SWT.getVersion() < 4600) {
            multiplierCorrection = -1.0;
        }
        sceneListener.scrollEvent(fxEventType, (double)event.xDirection, (double)event.yDirection, 0.0, 0.0, multiplierCorrection * 5.0, multiplierCorrection * 5.0, 0, 0, 0, 0, 0, (double)event.x, (double)event.y, (double)screenPosition.x, (double)screenPosition.y, this.isShift(event), this.isControl(event), this.isAlt(event), this.isMeta(event), false, false);
    }

    private void sendSwipeEvent(GestureEvent event, TKSceneListener sceneListener) {
        Point screenPosition = this.canvas.toDisplay(event.x, event.y);
        EventType fxEventType = null;
        if (event.yDirection > 0) {
            fxEventType = SwipeEvent.SWIPE_DOWN;
        } else if (event.yDirection < 0) {
            fxEventType = SwipeEvent.SWIPE_UP;
        } else if (event.xDirection > 0) {
            fxEventType = SwipeEvent.SWIPE_RIGHT;
        } else if (event.xDirection < 0) {
            fxEventType = SwipeEvent.SWIPE_LEFT;
        }
        sceneListener.swipeEvent(fxEventType, 0, (double)event.x, (double)event.y, (double)screenPosition.x, (double)screenPosition.y, this.isShift(event), this.isControl(event), this.isAlt(event), this.isMeta(event), false);
    }

    private void sendZoomEvent(EventType<ZoomEvent> fxEventType, GestureEvent event, TKSceneListener sceneListener) {
        Point screenPosition = this.canvas.toDisplay(event.x, event.y);
        double magnification = fxEventType == ZoomEvent.ZOOM_FINISHED ? this.currentGestureState.lastZoomFactor : event.magnification;
        sceneListener.zoomEvent(fxEventType, magnification / this.currentGestureState.lastZoomFactor, magnification, (double)event.x, (double)event.y, (double)screenPosition.x, (double)screenPosition.y, this.isShift(event), this.isControl(event), this.isAlt(event), this.isMeta(event), false, false);
        this.currentGestureState.lastZoomFactor = magnification;
    }

    protected class GestureState {
        GestureStateType type;
        double totalScrollX = 0.0;
        double totalScrollY = 0.0;
        double lastZoomFactor = 1.0;
        double lastRotation = 0.0;

        public GestureState(GestureStateType type) {
            this.type = type;
        }
    }

    static enum GestureStateType {
        IDLE,
        SCROLLING,
        ROTATING,
        ZOOMING;

    }

    protected static interface ISceneRunnable {
        public void run(TKSceneListener var1);
    }
}

