/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import javafx.scene.Node;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.operations.AbstractCompositeOperation;
import org.eclipse.gef4.mvc.operations.ChangeFocusOperation;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.gef4.zest.fx.operations.HideOperation;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class HidePolicy
extends AbstractTransactionPolicy<Node> {
    protected ITransactionalOperation createDeselectOperation(NodePart part) {
        return new DeselectOperation(part.getRoot().getViewer(), Collections.singletonList(part));
    }

    protected ITransactionalOperation createHideOperation(NodePart part) {
        return new HideOperation((IViewer<Node>)part.getRoot().getViewer(), part);
    }

    protected ITransactionalOperation createOperation() {
        return new ReverseUndoCompositeOperation("Hide");
    }

    protected ITransactionalOperation createUnfocusOperation(NodePart part) {
        IViewer viewer = part.getRoot().getViewer();
        FocusModel focusModel = (FocusModel)viewer.getAdapter((TypeToken)new TypeToken<FocusModel<Node>>(){});
        if (focusModel != null && focusModel.getFocus() == part) {
            return new ChangeFocusOperation(viewer, null);
        }
        return null;
    }

    public NodePart getHost() {
        return (NodePart)super.getHost();
    }

    public void hide() {
        ITransactionalOperation hideOperation;
        ITransactionalOperation deselectOperation;
        this.checkInitialized();
        AbstractCompositeOperation revOp = (AbstractCompositeOperation)this.getOperation();
        ITransactionalOperation unfocusOperation = this.createUnfocusOperation(this.getHost());
        if (unfocusOperation != null) {
            revOp.add((IUndoableOperation)unfocusOperation);
        }
        if ((deselectOperation = this.createDeselectOperation(this.getHost())) != null) {
            revOp.add((IUndoableOperation)deselectOperation);
        }
        if ((hideOperation = this.createHideOperation(this.getHost())) != null) {
            revOp.add((IUndoableOperation)hideOperation);
        }
        this.locallyExecuteOperation();
    }
}

