/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.fx.policies.FXBendFirstAnchorageOnSegmentHandleDragPolicy;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.parts.PartUtils;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.zest.fx.parts.AbstractLabelPart;
import org.eclipse.gef4.zest.fx.parts.EdgePart;
import org.eclipse.gef4.zest.fx.policies.TransformLabelPolicy;

public class BendFirstAnchorageAndRelocateLabelsOnDrag
extends FXBendFirstAnchorageOnSegmentHandleDragPolicy {
    public void drag(MouseEvent e, Dimension delta) {
        super.drag(e, delta);
        for (AbstractLabelPart lp : this.getLabelParts()) {
            ((TransformLabelPolicy)((Object)lp.getAdapter(TransformLabelPolicy.class))).preserveLabelOffset();
        }
    }

    public void dragAborted() {
        for (AbstractLabelPart lp : this.getLabelParts()) {
            this.rollback((AbstractTransactionPolicy)lp.getAdapter(TransformLabelPolicy.class));
            this.restoreRefreshVisuals((IVisualPart)lp);
        }
        super.dragAborted();
    }

    private List<AbstractLabelPart> getEdgeLabelParts(EdgePart edgePart) {
        ArrayList<AbstractLabelPart> linked = new ArrayList<AbstractLabelPart>();
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"label"), AbstractLabelPart.class)));
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"element-external-label"), AbstractLabelPart.class)));
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"edge-source-label"), AbstractLabelPart.class)));
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"edge-target-label"), AbstractLabelPart.class)));
        return linked;
    }

    private List<AbstractLabelPart> getLabelParts() {
        Set labelParts = Collections.newSetFromMap(new IdentityHashMap());
        labelParts.addAll(this.getEdgeLabelParts((EdgePart)((Object)this.getHost().getAnchoragesUnmodifiable().keySet().iterator().next())));
        Iterator iterator = labelParts.iterator();
        while (iterator.hasNext()) {
            if (((AbstractLabelPart)((Object)iterator.next())).getStoredLabelPosition() != null) continue;
            iterator.remove();
        }
        return new ArrayList<AbstractLabelPart>(labelParts);
    }

    public void press(MouseEvent e) {
        super.press(e);
        for (AbstractLabelPart lp : this.getLabelParts()) {
            this.storeAndDisableRefreshVisuals((IVisualPart)lp);
            this.init((AbstractTransactionPolicy)lp.getAdapter(TransformLabelPolicy.class));
        }
    }

    public void release(MouseEvent e, Dimension delta) {
        for (AbstractLabelPart lp : this.getLabelParts()) {
            this.commit((AbstractTransactionPolicy)lp.getAdapter(TransformLabelPolicy.class));
            this.restoreRefreshVisuals((IVisualPart)lp);
        }
        super.release(e, delta);
    }
}

