/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.collections;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.gef4.common.collections.ListListenerHelperEx;

class ObservableListWrapperEx<E>
extends ForwardingList<E>
implements ObservableList<E> {
    private ListListenerHelperEx<E> helper = new ListListenerHelperEx(this);
    private List<E> backingList;

    public ObservableListWrapperEx(List<E> list) {
        this.backingList = list;
    }

    public boolean add(E element) {
        List<E> previousContents = this.delegateCopy();
        boolean result = super.add(element);
        if (result) {
            this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, ListListenerHelperEx.ElementarySubChange.added(Collections.singletonList(element), previousContents.size(), previousContents.size() + 1)));
        }
        return result;
    }

    public void add(int index, E element) {
        List<E> previousContents = this.delegateCopy();
        super.add(index, element);
        this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, ListListenerHelperEx.ElementarySubChange.added(Collections.singletonList(element), index, index + 1)));
    }

    public boolean addAll(Collection<? extends E> collection) {
        List<E> previousContents = this.delegateCopy();
        boolean result = super.addAll(collection);
        this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, ListListenerHelperEx.ElementarySubChange.added(new ArrayList<E>(collection), previousContents.size(), previousContents.size() + collection.size())));
        return result;
    }

    public boolean addAll(E ... elements) {
        return this.addAll((Collection<? extends E>)Arrays.asList(elements));
    }

    public boolean addAll(int index, Collection<? extends E> elements) {
        List<E> previousContents = this.delegateCopy();
        boolean result = super.addAll(index, elements);
        this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, ListListenerHelperEx.ElementarySubChange.added(new ArrayList<E>(elements), index, index + elements.size())));
        return result;
    }

    public void addListener(InvalidationListener listener) {
        this.helper.addListener(listener);
    }

    public void addListener(ListChangeListener<? super E> listener) {
        this.helper.addListener(listener);
    }

    public void clear() {
        List<E> previousContents = this.delegateCopy();
        super.clear();
        if (!previousContents.isEmpty()) {
            this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, ListListenerHelperEx.ElementarySubChange.removed(previousContents, 0, 0)));
        }
    }

    protected List<E> delegate() {
        return this.backingList;
    }

    protected List<E> delegateCopy() {
        return new ArrayList<E>(this.backingList);
    }

    public E remove(int index) {
        List<E> previousContents = this.delegateCopy();
        Object result = super.remove(index);
        this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<Object>(this, previousContents, ListListenerHelperEx.ElementarySubChange.removed(Collections.singletonList(result), index, index)));
        return (E)result;
    }

    public void remove(int from, int to) {
        List<E> previousContents = this.delegateCopy();
        ArrayList<Object> removed = new ArrayList<Object>();
        int i = to - 1;
        while (i >= from) {
            removed.add(0, super.remove(i));
            --i;
        }
        this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, ListListenerHelperEx.ElementarySubChange.removed(removed, from, from)));
    }

    public boolean remove(Object object) {
        List<E> previousContents = this.delegateCopy();
        if (super.remove(object)) {
            int index = previousContents.indexOf(object);
            this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<Object>(this, previousContents, ListListenerHelperEx.ElementarySubChange.removed(Collections.singletonList(object), index, index)));
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection<?> collection) {
        List<E> previousContents = this.delegateCopy();
        if (super.removeAll(collection)) {
            ArrayList<ListListenerHelperEx.ElementarySubChange<ListListenerHelperEx.ElementarySubChange<E>>> elementaryChanges = new ArrayList<ListListenerHelperEx.ElementarySubChange<ListListenerHelperEx.ElementarySubChange<E>>>();
            ListListenerHelperEx.ElementarySubChange<E> currentElementaryChange = null;
            int removeCount = 0;
            for (E e : previousContents) {
                if (!collection.contains(e)) continue;
                if (currentElementaryChange == null || previousContents.indexOf(e) - currentElementaryChange.getFrom() > 1) {
                    if (currentElementaryChange != null) {
                        removeCount += currentElementaryChange.getRemoved().size();
                    }
                    int index = previousContents.indexOf(e) - removeCount;
                    currentElementaryChange = ListListenerHelperEx.ElementarySubChange.removed(Collections.singletonList(e), index, index);
                    elementaryChanges.add(currentElementaryChange);
                    continue;
                }
                ArrayList<E> removed = new ArrayList<E>(currentElementaryChange.getRemoved());
                removed.add(e);
                int index = currentElementaryChange.getFrom();
                elementaryChanges.remove(currentElementaryChange);
                currentElementaryChange = ListListenerHelperEx.ElementarySubChange.removed(removed, index, index);
                elementaryChanges.add(currentElementaryChange);
            }
            this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, elementaryChanges));
            return true;
        }
        return false;
    }

    public boolean removeAll(E ... elements) {
        return this.removeAll((Collection<?>)Arrays.asList(elements));
    }

    public void removeListener(InvalidationListener listener) {
        this.helper.removeListener(listener);
    }

    public void removeListener(ListChangeListener<? super E> listener) {
        this.helper.removeListener(listener);
    }

    public boolean retainAll(Collection<?> collection) {
        List<E> previousContents = this.delegateCopy();
        if (super.retainAll(collection)) {
            ArrayList<ListListenerHelperEx.ElementarySubChange<ListListenerHelperEx.ElementarySubChange<E>>> elementaryChanges = new ArrayList<ListListenerHelperEx.ElementarySubChange<ListListenerHelperEx.ElementarySubChange<E>>>();
            ListListenerHelperEx.ElementarySubChange<E> currentElementaryChange = null;
            int removeCount = 0;
            for (E e : previousContents) {
                if (collection.contains(e)) continue;
                if (currentElementaryChange == null || previousContents.indexOf(e) - currentElementaryChange.getFrom() > 1) {
                    if (currentElementaryChange != null) {
                        removeCount += currentElementaryChange.getRemoved().size();
                    }
                    int index = previousContents.indexOf(e) - removeCount;
                    currentElementaryChange = ListListenerHelperEx.ElementarySubChange.removed(Collections.singletonList(e), index, index);
                    elementaryChanges.add(currentElementaryChange);
                    continue;
                }
                ArrayList<E> removed = new ArrayList<E>(currentElementaryChange.getRemoved());
                removed.add(e);
                int index = currentElementaryChange.getFrom();
                elementaryChanges.remove(currentElementaryChange);
                currentElementaryChange = ListListenerHelperEx.ElementarySubChange.removed(removed, index, index);
                elementaryChanges.add(currentElementaryChange);
            }
            this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, elementaryChanges));
            return true;
        }
        return false;
    }

    public boolean retainAll(E ... elements) {
        return this.retainAll((Collection<?>)Arrays.asList(elements));
    }

    public E set(int index, E element) {
        List<E> previousContents = this.delegateCopy();
        if (this.get(index) != element) {
            Object result = super.remove(index);
            super.add(index, element);
            this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<Object>(this, previousContents, ListListenerHelperEx.ElementarySubChange.replaced(Collections.singletonList(result), Collections.singletonList(element), index, index + 1)));
            return (E)result;
        }
        return element;
    }

    public boolean setAll(Collection<? extends E> collection) {
        List<E> previousContents = this.delegateCopy();
        if (!previousContents.equals(collection)) {
            this.delegate().clear();
            this.delegate().addAll(collection);
            this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, ListListenerHelperEx.ElementarySubChange.replaced(previousContents, this.delegate(), 0, this.size())));
            return true;
        }
        return false;
    }

    public boolean setAll(E ... elements) {
        return this.setAll((Collection<? extends E>)Arrays.asList(elements));
    }

    public void sort() {
        this.sort(null);
    }

    public void sort(Comparator<? super E> c) {
        List<E> previousContents = this.delegateCopy();
        HashMultimap previousIndexes = HashMultimap.create();
        int i = 0;
        while (i < previousContents.size()) {
            previousIndexes.put(previousContents.get(i), (Object)i);
            ++i;
        }
        Object[] a = this.delegate().toArray();
        int[] permutation = new int[a.length];
        Arrays.sort(a, c);
        ListIterator<Object> iterator = this.delegate().listIterator();
        boolean changed = false;
        int i2 = 0;
        while (i2 < a.length) {
            E current = iterator.next();
            if (current != a[i2]) {
                changed = true;
                iterator.set(a[i2]);
            }
            Iterator previousIndexIterator = previousIndexes.get(a[i2]).iterator();
            permutation[((Integer)previousIndexIterator.next()).intValue()] = i2++;
            previousIndexIterator.remove();
        }
        if (changed) {
            this.helper.fireValueChangedEvent(new ListListenerHelperEx.AtomicChange<E>(this, previousContents, ListListenerHelperEx.ElementarySubChange.permutated(permutation, 0, a.length)));
        }
    }
}

