/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt.inject;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.adapt.inject.AdaptableScope;

public class AdaptableScopes {
    private static final Map<Class<? extends IAdaptable>, AdaptableScope<? extends IAdaptable>> scopes = new HashMap<Class<? extends IAdaptable>, AdaptableScope<? extends IAdaptable>>();

    private AdaptableScopes() {
    }

    public static <A extends IAdaptable> AdaptableScope<A> typed(Class<? extends A> type) {
        AdaptableScope<? extends IAdaptable> scope = scopes.get(type);
        if (scope == null) {
            scope = new AdaptableScope<IAdaptable>(type);
            scopes.put(type, scope);
        }
        return scope;
    }

    public static void enter(IAdaptable adaptable) {
        AdaptableScopes.process(adaptable.getClass(), adaptable, new ScopeProcessor(){

            @Override
            public void process(Class<? extends IAdaptable> adaptableType, IAdaptable adaptableInstance) {
                AdaptableScopes.typed(adaptableType).enter(adaptableInstance);
            }
        });
    }

    public static void switchTo(IAdaptable adaptable) {
        AdaptableScopes.process(adaptable.getClass(), adaptable, new ScopeProcessor(){

            @Override
            public void process(Class<? extends IAdaptable> adaptableType, IAdaptable adaptableInstance) {
                AdaptableScopes.typed(adaptableType).switchTo(adaptableInstance);
            }
        });
    }

    public static void leave(IAdaptable adaptable) {
        AdaptableScopes.process(adaptable.getClass(), adaptable, new ScopeProcessor(){

            @Override
            public void process(Class<? extends IAdaptable> adaptableType, IAdaptable adaptableInstance) {
                AdaptableScopes.typed(adaptableType).leave(adaptableInstance);
            }
        });
    }

    private static void process(Class<? extends IAdaptable> adaptableType, IAdaptable adaptableInstance, ScopeProcessor processor) {
        processor.process(adaptableType, adaptableInstance);
        if (adaptableType.getSuperclass() != null && IAdaptable.class.isAssignableFrom(adaptableType.getSuperclass())) {
            AdaptableScopes.process(adaptableType.getSuperclass(), adaptableInstance, processor);
        }
        Class<?>[] classArray = adaptableType.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceType = classArray[n2];
            if (IAdaptable.class.isAssignableFrom(interfaceType)) {
                AdaptableScopes.process(interfaceType, adaptableInstance, processor);
            }
            ++n2;
        }
    }

    private static interface ScopeProcessor {
        public void process(Class<? extends IAdaptable> var1, IAdaptable var2);
    }
}

