/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.examples.graph.ui.properties;

import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.zest.fx.ZestProperties;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class NodePropertySource
implements IPropertySource {
    private static final String POSITION_DELIMITER = ", ";
    private static final String SIZE_DELIMITER = " x ";
    private static final IPropertyDescriptor POSITION_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"node-position", "node-position");
    private static final IPropertyDescriptor SIZE_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"node-size", "node-size");
    private Node node;
    private Dimension initialSize;
    private Point initialPosition;

    public NodePropertySource(Node node) {
        this.node = node;
        this.initialPosition = ZestProperties.getPosition((Node)node);
        this.initialSize = ZestProperties.getSize((Node)node);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{POSITION_PROPERTY_DESCRIPTOR, SIZE_PROPERTY_DESCRIPTOR};
    }

    public Object getPropertyValue(Object id) {
        if (POSITION_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            Point position = ZestProperties.getPosition((Node)this.node);
            return position == null ? "null" : String.valueOf(position.x) + POSITION_DELIMITER + position.y;
        }
        if (SIZE_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            Dimension size = ZestProperties.getSize((Node)this.node);
            return size == null ? "null" : String.valueOf(size.width) + SIZE_DELIMITER + size.height;
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (POSITION_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            return ZestProperties.getPosition((Node)this.node) != null;
        }
        if (SIZE_PROPERTY_DESCRIPTOR.equals(id)) {
            return ZestProperties.getSize((Node)this.node) != null;
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (POSITION_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            ZestProperties.setPosition((Node)this.node, (Point)this.initialPosition);
        } else if (SIZE_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            ZestProperties.setSize((Node)this.node, (Dimension)this.initialSize);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (POSITION_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            String[] xy = ((String)value).split(POSITION_DELIMITER);
            ZestProperties.setPosition((Node)this.node, (Point)new Point(Double.parseDouble(xy[0]), Double.parseDouble(xy[1])));
        } else if (SIZE_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            String[] wh = ((String)value).split(SIZE_DELIMITER);
            ZestProperties.setSize((Node)this.node, (Dimension)new Dimension(Double.parseDouble(wh[0]), Double.parseDouble(wh[1])));
        }
    }
}

