/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.beans.property;

import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.gef.common.beans.binding.MultisetExpressionHelper;
import org.eclipse.gef.common.beans.property.MultisetProperty;
import org.eclipse.gef.common.collections.MultisetChangeListener;
import org.eclipse.gef.common.collections.ObservableMultiset;

public abstract class MultisetPropertyBase<E>
extends MultisetProperty<E> {
    private final MultisetChangeListener<E> invalidatingValueObserver = new MultisetChangeListener<E>(){

        @Override
        public void onChanged(MultisetChangeListener.Change<? extends E> change) {
            MultisetPropertyBase.this.invalidateProperties();
            MultisetPropertyBase.this.invalidated();
            MultisetPropertyBase.this.fireValueChangedEvent(change);
        }
    };
    private MultisetExpressionHelper<E> helper = null;
    private ObservableMultiset<E> value = null;
    private boolean valid = true;
    private SizeProperty sizeProperty = null;
    private EmptyProperty emptyProperty = null;
    private ObservableValue<? extends ObservableMultiset<E>> observedValue = null;
    private InvalidationListener invalidatingObservedValueObserver = null;

    public MultisetPropertyBase() {
    }

    public MultisetPropertyBase(ObservableMultiset<E> initialValue) {
        this.value = initialValue;
        if (initialValue != null) {
            initialValue.addListener(this.invalidatingValueObserver);
        }
    }

    @Override
    public void addListener(ChangeListener<? super ObservableMultiset<E>> listener) {
        if (this.helper == null) {
            this.helper = new MultisetExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        if (this.helper == null) {
            this.helper = new MultisetExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    @Override
    public void addListener(MultisetChangeListener<? super E> listener) {
        if (this.helper == null) {
            this.helper = new MultisetExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    @Override
    protected void appendValueToString(StringBuilder result) {
        if (this.isBound()) {
            result.append("bound, ");
            if (this.valid) {
                result.append("value: " + this.get());
            } else {
                result.append("invalid");
            }
        } else {
            result.append("value: " + this.get());
        }
    }

    public void bind(ObservableValue<? extends ObservableMultiset<E>> observedValue) {
        if (observedValue == null) {
            throw new NullPointerException("Cannot bind to null.");
        }
        if (!observedValue.equals(this.observedValue)) {
            this.unbind();
            this.observedValue = observedValue;
            if (this.invalidatingObservedValueObserver == null) {
                this.invalidatingObservedValueObserver = new InvalidatingObserver(this);
            }
            observedValue.addListener(this.invalidatingObservedValueObserver);
            this.markInvalid(this.value);
        }
    }

    @Override
    public ReadOnlyBooleanProperty emptyProperty() {
        if (this.emptyProperty == null) {
            this.emptyProperty = new EmptyProperty();
        }
        return this.emptyProperty;
    }

    protected void fireValueChangedEvent() {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent();
        }
    }

    protected void fireValueChangedEvent(MultisetChangeListener.Change<? extends E> change) {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent(change);
        }
    }

    public ObservableMultiset<E> get() {
        if (!this.valid) {
            this.value = this.observedValue == null ? this.value : (ObservableMultiset)this.observedValue.getValue();
            this.valid = true;
            if (this.value != null) {
                this.value.addListener(this.invalidatingValueObserver);
            }
        }
        return this.value;
    }

    protected void invalidated() {
    }

    private void invalidateProperties() {
        if (this.sizeProperty != null) {
            this.sizeProperty.fireValueChangedEvent();
        }
        if (this.emptyProperty != null) {
            this.emptyProperty.fireValueChangedEvent();
        }
    }

    public boolean isBound() {
        return this.observedValue != null;
    }

    private void markInvalid(ObservableMultiset<E> oldValue) {
        if (this.valid) {
            if (oldValue != null) {
                oldValue.removeListener(this.invalidatingValueObserver);
            }
            this.valid = false;
            this.invalidateProperties();
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableMultiset<E>> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    @Override
    public void removeListener(MultisetChangeListener<? super E> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void set(ObservableMultiset<E> newValue) {
        if (this.isBound()) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        if (this.value != newValue) {
            ObservableMultiset<E> oldValue = this.value;
            this.value = newValue;
            this.markInvalid(oldValue);
        }
    }

    @Override
    public ReadOnlyIntegerProperty sizeProperty() {
        if (this.sizeProperty == null) {
            this.sizeProperty = new SizeProperty();
        }
        return this.sizeProperty;
    }

    public void unbind() {
        if (this.observedValue != null) {
            this.value = (ObservableMultiset)this.observedValue.getValue();
            this.observedValue.removeListener(this.invalidatingObservedValueObserver);
            this.invalidatingObservedValueObserver = null;
            this.observedValue = null;
        }
    }

    private class EmptyProperty
    extends ReadOnlyBooleanPropertyBase {
        private EmptyProperty() {
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public boolean get() {
            return MultisetPropertyBase.this.isEmpty();
        }

        public Object getBean() {
            return MultisetPropertyBase.this;
        }

        public String getName() {
            return "empty";
        }
    }

    private static class InvalidatingObserver<E>
    implements InvalidationListener {
        private WeakReference<MultisetPropertyBase<E>> multisetPropertyRef;

        public InvalidatingObserver(MultisetPropertyBase<E> setMultimapProperty) {
            this.multisetPropertyRef = new WeakReference<MultisetPropertyBase<E>>(setMultimapProperty);
        }

        public void invalidated(Observable observable) {
            MultisetPropertyBase multisetProperty = (MultisetPropertyBase)this.multisetPropertyRef.get();
            if (multisetProperty == null) {
                observable.removeListener((InvalidationListener)this);
            } else {
                multisetProperty.markInvalid(multisetProperty.value);
            }
        }
    }

    private class SizeProperty
    extends ReadOnlyIntegerPropertyBase {
        private SizeProperty() {
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public int get() {
            return MultisetPropertyBase.this.size();
        }

        public Object getBean() {
            return MultisetPropertyBase.this;
        }

        public String getName() {
            return "size";
        }
    }
}

