/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.AttributeType;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhs;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Stmt;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DotAstHelper {
    public static NodeId getNodeId(NodeId nodeId) {
        Object _xblockexpression = null;
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)nodeId, DotGraph.class);
        EList<Stmt> _stmts = dotGraph.getStmts();
        Iterable _filter = Iterables.filter(_stmts, NodeStmt.class);
        for (NodeStmt nodeStmt : _filter) {
            boolean _tripleNotEquals;
            boolean _and = false;
            NodeId _node = nodeStmt.getNode();
            boolean bl = _tripleNotEquals = _node != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _equals;
                NodeId _node_1 = nodeStmt.getNode();
                ID _name = _node_1.getName();
                ID _name_1 = nodeId.getName();
                _and = _equals = Objects.equal((Object)_name, (Object)_name_1);
            }
            if (!_and) continue;
            return nodeStmt.getNode();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static List<NodeId> getAllNodeIds(NodeId baseNodeId) {
        LinkedList _xblockexpression = null;
        LinkedList result = CollectionLiterals.newLinkedList((Object[])new NodeId[0]);
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)baseNodeId, DotGraph.class);
        EList<Stmt> _stmts = dotGraph.getStmts();
        Iterable _filter = Iterables.filter(_stmts, NodeStmt.class);
        for (NodeStmt nodeStmt : _filter) {
            boolean _notEquals;
            boolean _tripleNotEquals;
            NodeId nodeId = nodeStmt.getNode();
            boolean _and = false;
            boolean _and_1 = false;
            boolean bl = _tripleNotEquals = nodeId != null;
            if (!_tripleNotEquals) {
                _and_1 = false;
            } else {
                boolean _equals;
                ID _name = nodeId.getName();
                ID _name_1 = baseNodeId.getName();
                _and_1 = _equals = Objects.equal((Object)_name, (Object)_name_1);
            }
            _and = !_and_1 ? false : (_notEquals = !Objects.equal((Object)nodeId, (Object)baseNodeId));
            if (!_and) continue;
            result.add(nodeId);
        }
        EList<Stmt> _stmts_1 = dotGraph.getStmts();
        Iterable _filter_1 = Iterables.filter(_stmts_1, EdgeStmtNode.class);
        for (EdgeStmtNode edgeStmtNode : _filter_1) {
            boolean _tripleNotEquals_3;
            boolean _tripleNotEquals_2;
            NodeId _node;
            EList<EdgeRhs> _edgeRHS;
            EdgeRhs edgeRHS;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            NodeId nodeId = edgeStmtNode.getNode();
            boolean _and = false;
            boolean _and_1 = false;
            boolean bl = _tripleNotEquals = nodeId != null;
            if (!_tripleNotEquals) {
                _and_1 = false;
            } else {
                boolean _equals;
                ID _name = nodeId.getName();
                ID _name_1 = baseNodeId.getName();
                _and_1 = _equals = Objects.equal((Object)_name, (Object)_name_1);
            }
            _and = !_and_1 ? false : (_tripleNotEquals_1 = nodeId != baseNodeId);
            if (_and) {
                result.add(nodeId);
            }
            if (!((edgeRHS = (EdgeRhs)IterableExtensions.head(_edgeRHS = edgeStmtNode.getEdgeRHS())) instanceof EdgeRhsNode)) continue;
            nodeId = _node = ((EdgeRhsNode)edgeRHS).getNode();
            boolean _and_2 = false;
            boolean _and_3 = false;
            boolean bl2 = _tripleNotEquals_2 = nodeId != null;
            if (!_tripleNotEquals_2) {
                _and_3 = false;
            } else {
                boolean _equals_1;
                ID _name_2 = nodeId.getName();
                ID _name_3 = baseNodeId.getName();
                _and_3 = _equals_1 = Objects.equal((Object)_name_2, (Object)_name_3);
            }
            _and_2 = !_and_3 ? false : (_tripleNotEquals_3 = nodeId != baseNodeId);
            if (!_and_2) continue;
            result.add(nodeId);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static String getColorSchemeAttributeValue(Attribute attribute) {
        return DotAstHelper.getDependedOnAttributeValue(attribute, "colorscheme");
    }

    public static String getDependedOnAttributeValue(Attribute dependentAttribute, String attributeName) {
        DotGraph dotGraph;
        boolean _tripleNotEquals_8;
        AttrStmt attrStmt;
        boolean _tripleNotEquals_6;
        NodeStmt nodeStmt;
        boolean _tripleNotEquals_3;
        boolean _tripleNotEquals;
        EdgeStmtNode edgeStmtNode = (EdgeStmtNode)EcoreUtil2.getContainerOfType((EObject)dependentAttribute, EdgeStmtNode.class);
        boolean bl = _tripleNotEquals = edgeStmtNode != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_2;
            boolean _tripleNotEquals_1;
            EList<AttrList> _attrLists = edgeStmtNode.getAttrLists();
            ID dependedOnValue = DotAstHelper.getAttributeValue(_attrLists, attributeName);
            boolean bl2 = _tripleNotEquals_1 = dependedOnValue != null;
            if (_tripleNotEquals_1) {
                return dependedOnValue.toValue();
            }
            ID _globalDependedOnValue = DotAstHelper.getGlobalDependedOnValue(edgeStmtNode, AttributeType.EDGE, attributeName);
            dependedOnValue = _globalDependedOnValue;
            boolean bl3 = _tripleNotEquals_2 = dependedOnValue != null;
            if (_tripleNotEquals_2) {
                return dependedOnValue.toValue();
            }
        }
        boolean bl4 = _tripleNotEquals_3 = (nodeStmt = (NodeStmt)EcoreUtil2.getContainerOfType((EObject)dependentAttribute, NodeStmt.class)) != null;
        if (_tripleNotEquals_3) {
            boolean _tripleNotEquals_5;
            boolean _tripleNotEquals_4;
            EList<AttrList> _attrLists_1 = nodeStmt.getAttrLists();
            ID dependedOnValue_1 = DotAstHelper.getAttributeValue(_attrLists_1, attributeName);
            boolean bl5 = _tripleNotEquals_4 = dependedOnValue_1 != null;
            if (_tripleNotEquals_4) {
                return dependedOnValue_1.toValue();
            }
            ID _globalDependedOnValue_1 = DotAstHelper.getGlobalDependedOnValue(nodeStmt, AttributeType.NODE, attributeName);
            dependedOnValue_1 = _globalDependedOnValue_1;
            boolean bl6 = _tripleNotEquals_5 = dependedOnValue_1 != null;
            if (_tripleNotEquals_5) {
                return dependedOnValue_1.toValue();
            }
        }
        boolean bl7 = _tripleNotEquals_6 = (attrStmt = (AttrStmt)EcoreUtil2.getContainerOfType((EObject)dependentAttribute, AttrStmt.class)) != null;
        if (_tripleNotEquals_6) {
            boolean _tripleNotEquals_7;
            EList<AttrList> _attrLists_2 = attrStmt.getAttrLists();
            ID dependedOnValue_2 = DotAstHelper.getAttributeValue(_attrLists_2, attributeName);
            boolean bl8 = _tripleNotEquals_7 = dependedOnValue_2 != null;
            if (_tripleNotEquals_7) {
                return dependedOnValue_2.toValue();
            }
        }
        boolean bl9 = _tripleNotEquals_8 = (dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)dependentAttribute, DotGraph.class)) != null;
        if (_tripleNotEquals_8) {
            boolean _tripleNotEquals_10;
            boolean _tripleNotEquals_9;
            ID dependedOnValue_3 = DotAstHelper.getAttributeValueAll(dotGraph, attributeName);
            boolean bl10 = _tripleNotEquals_9 = dependedOnValue_3 != null;
            if (_tripleNotEquals_9) {
                return dependedOnValue_3.toValue();
            }
            ID _globalDependedOnValue_2 = DotAstHelper.getGlobalDependedOnValue(dotGraph, AttributeType.GRAPH, attributeName);
            dependedOnValue_3 = _globalDependedOnValue_2;
            boolean bl11 = _tripleNotEquals_10 = dependedOnValue_3 != null;
            if (_tripleNotEquals_10) {
                return dependedOnValue_3.toValue();
            }
        }
        return null;
    }

    private static ID getGlobalDependedOnValue(EObject eObject, AttributeType attributeType, String attributeName) {
        DotGraph _containerOfType;
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals;
        Object _xblockexpression = null;
        EObject container = EcoreUtil2.getContainerOfType((EObject)eObject, Subgraph.class);
        boolean bl = _tripleNotEquals = container != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            EList<Stmt> _stmts = ((Subgraph)container).getStmts();
            ID value = DotAstHelper.getAttributeValue(_stmts, attributeType, attributeName);
            boolean bl2 = _tripleNotEquals_1 = value != null;
            if (_tripleNotEquals_1) {
                return value;
            }
        }
        boolean bl3 = _tripleNotEquals_2 = (container = (_containerOfType = (DotGraph)EcoreUtil2.getContainerOfType((EObject)eObject, DotGraph.class))) != null;
        if (_tripleNotEquals_2) {
            boolean _tripleNotEquals_3;
            EList<Stmt> _stmts_1 = ((DotGraph)container).getStmts();
            ID value_1 = DotAstHelper.getAttributeValue(_stmts_1, attributeType, attributeName);
            boolean bl4 = _tripleNotEquals_3 = value_1 != null;
            if (_tripleNotEquals_3) {
                return value_1;
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private static ID getAttributeValue(EList<Stmt> stmts, AttributeType attributeType, String attributeName) {
        Object _xblockexpression = null;
        for (Stmt stmt : stmts) {
            AttributeType _type;
            boolean _equals;
            if (!(stmt instanceof AttrStmt) || !(_equals = Objects.equal((Object)((Object)(_type = ((AttrStmt)stmt).getType())), (Object)((Object)attributeType)))) continue;
            EList<AttrList> _attrLists = ((AttrStmt)stmt).getAttrLists();
            return DotAstHelper.getAttributeValue(_attrLists, attributeName);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static ID getAttributeValue(DotGraph graph, String name) {
        Object _xblockexpression = null;
        EList<Stmt> _stmts = graph.getStmts();
        for (Stmt stmt : _stmts) {
            ID value;
            boolean _tripleNotEquals;
            ID _switchResult = null;
            boolean _matched = false;
            if (!_matched && stmt instanceof Attribute) {
                _matched = true;
                _switchResult = DotAstHelper.getAttributeValue((Attribute)stmt, name);
            }
            boolean bl = _tripleNotEquals = (value = _switchResult) != null;
            if (!_tripleNotEquals) continue;
            return value;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static ID getAttributeValueAll(DotGraph graph, String name) {
        Object _xblockexpression = null;
        EList<Stmt> _stmts = graph.getStmts();
        for (Stmt stmt : _stmts) {
            ID value;
            boolean _tripleNotEquals;
            ID _switchResult = null;
            boolean _matched = false;
            if (!_matched && stmt instanceof AttrStmt) {
                _matched = true;
                EList<AttrList> _attrLists = ((AttrStmt)stmt).getAttrLists();
                _switchResult = DotAstHelper.getAttributeValue(_attrLists, name);
            }
            if (!_matched && stmt instanceof Attribute) {
                _matched = true;
                _switchResult = DotAstHelper.getAttributeValue((Attribute)stmt, name);
            }
            boolean bl = _tripleNotEquals = (value = _switchResult) != null;
            if (!_tripleNotEquals) continue;
            return value;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static ID getAttributeValue(Subgraph subgraph, String name) {
        Object _xblockexpression = null;
        EList<Stmt> _stmts = subgraph.getStmts();
        for (Stmt stmt : _stmts) {
            ID value;
            boolean _tripleNotEquals;
            ID _switchResult = null;
            boolean _matched = false;
            if (!_matched && stmt instanceof Attribute) {
                _matched = true;
                _switchResult = DotAstHelper.getAttributeValue((Attribute)stmt, name);
            }
            boolean bl = _tripleNotEquals = (value = _switchResult) != null;
            if (!_tripleNotEquals) continue;
            return value;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static ID getAttributeValue(List<AttrList> attrLists, String name) {
        Object _xblockexpression = null;
        for (AttrList attrList : attrLists) {
            boolean _tripleNotEquals;
            ID value = DotAstHelper.getAttributeValue(attrList, name);
            boolean bl = _tripleNotEquals = value != null;
            if (!_tripleNotEquals) continue;
            return value;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private static ID getAttributeValue(AttrList attrList, final String name) {
        EList<Attribute> _attributes = attrList.getAttributes();
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                ID _name = it.getName();
                String _value = _name.toValue();
                return Objects.equal((Object)_value, (Object)name);
            }
        };
        Attribute _findFirst = (Attribute)IterableExtensions.findFirst(_attributes, (Functions.Function1)_function);
        ID _value = null;
        if (_findFirst != null) {
            _value = _findFirst.getValue();
        }
        return _value;
    }

    private static ID getAttributeValue(Attribute attribute, String name) {
        Object _xblockexpression = null;
        ID _name = attribute.getName();
        String _value = _name.toValue();
        boolean _equals = _value.equals(name);
        if (_equals) {
            return attribute.getValue();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }
}

