/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.model.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.StructuredActivity;
import org.eclipse.gef.examples.flow.model.Transition;

public class DeleteCommand
extends Command {
    private Activity child;
    private StructuredActivity parent;
    private int index = -1;
    private List<Transition> sourceConnections = new ArrayList<Transition>();
    private List<Transition> targetConnections = new ArrayList<Transition>();

    private void deleteConnections(Activity a) {
        if (a instanceof StructuredActivity) {
            StructuredActivity structAct = (StructuredActivity)a;
            structAct.getChildren().forEach(this::deleteConnections);
        }
        this.sourceConnections.addAll(a.getIncomingTransitions());
        this.sourceConnections.forEach(t -> {
            t.source.removeOutput((Transition)t);
            a.removeInput((Transition)t);
        });
        this.targetConnections.addAll(a.getOutgoingTransitions());
        this.targetConnections.forEach(t -> {
            t.target.removeInput((Transition)t);
            a.removeOutput((Transition)t);
        });
    }

    public void execute() {
        this.primExecute();
    }

    protected void primExecute() {
        this.deleteConnections(this.child);
        this.index = this.parent.getChildren().indexOf(this.child);
        this.parent.removeChild(this.child);
    }

    public void redo() {
        this.primExecute();
    }

    private void restoreConnections() {
        this.sourceConnections.forEach(t -> {
            t.target.addInput((Transition)t);
            t.source.addOutput((Transition)t);
        });
        this.sourceConnections.clear();
        this.targetConnections.forEach(t -> {
            t.source.addOutput((Transition)t);
            t.target.addInput((Transition)t);
        });
        this.targetConnections.clear();
    }

    public void setChild(Activity a) {
        this.child = a;
    }

    public void setParent(StructuredActivity sa) {
        this.parent = sa;
    }

    public void undo() {
        this.parent.addChild(this.child, this.index);
        this.restoreConnections();
    }
}

