/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.OrderedLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.ContainerHighlightEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.LogicContainerEditPart;
import org.eclipse.gef.examples.logicdesigner.edit.LogicFlowEditPolicy;
import org.eclipse.gef.examples.logicdesigner.figures.LogicFlowBorder;
import org.eclipse.gef.examples.logicdesigner.model.LogicFlowContainer;

public class LogicFlowContainerEditPart
extends LogicContainerEditPart {
    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new LogicFlowEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ContainerHighlightEditPolicy());
    }

    @Override
    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.updateLayout(this.getLogicFlowContainer().getLayout());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (LogicFlowContainer.ID_LAYOUT.equals(prop)) {
            this.updateLayout((Integer)evt.getNewValue());
        } else {
            super.propertyChange(evt);
        }
    }

    protected void updateLayout(Integer newLayout) {
        this.getFigure().setLayoutManager((LayoutManager)this.createLayout(newLayout));
    }

    private OrderedLayout createLayout(Integer newLayout) {
        FlowLayout layout;
        if (newLayout.equals(LogicFlowContainer.LAYOUT_SINGLE_ROW)) {
            layout = new ToolbarLayout(false);
            ((ToolbarLayout)layout).setSpacing(5);
        } else {
            layout = new FlowLayout();
        }
        return layout;
    }

    protected LogicFlowContainer getLogicFlowContainer() {
        return (LogicFlowContainer)this.getModel();
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        figure.setLayoutManager((LayoutManager)this.createLayout(this.getLogicFlowContainer().getLayout()));
        figure.setBorder((Border)new LogicFlowBorder());
        figure.setOpaque(true);
        return figure;
    }
}

