/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportAwareConnectionLayerClippingStrategy;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.examples.logicdesigner.LogicContextMenuProvider;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.LogicPlugin;
import org.eclipse.gef.examples.logicdesigner.actions.IncrementDecrementAction;
import org.eclipse.gef.examples.logicdesigner.dnd.TextTransferDropTargetListener;
import org.eclipse.gef.examples.logicdesigner.edit.GraphicalPartFactory;
import org.eclipse.gef.examples.logicdesigner.edit.TreePartFactory;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicRuler;
import org.eclipse.gef.examples.logicdesigner.palette.LogicPaletteCustomizer;
import org.eclipse.gef.examples.logicdesigner.rulers.LogicRulerProvider;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.CopyTemplateAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.MatchHeightAction;
import org.eclipse.gef.ui.actions.MatchSizeAction;
import org.eclipse.gef.ui.actions.MatchWidthAction;
import org.eclipse.gef.ui.actions.PasteTemplateAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ToggleRulerVisibilityAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class LogicEditor
extends GraphicalEditorWithFlyoutPalette {
    private KeyHandler sharedKeyHandler;
    private PaletteRoot root;
    private OutlinePage outlinePage;
    private boolean editorSaving = false;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part != LogicEditor.this) {
                return;
            }
            if (!((IFileEditorInput)LogicEditor.this.getEditorInput()).getFile().exists()) {
                Shell shell = LogicEditor.this.getSite().getShell();
                String title = LogicMessages.GraphicalEditor_FILE_DELETED_TITLE_UI;
                String message = LogicMessages.GraphicalEditor_FILE_DELETED_WITHOUT_SAVE_INFO;
                String[] buttons = new String[]{LogicMessages.GraphicalEditor_SAVE_BUTTON_UI, LogicMessages.GraphicalEditor_CLOSE_BUTTON_UI};
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttons, 0);
                if (dialog.open() == 0) {
                    if (!LogicEditor.this.performSaveAs()) {
                        this.partActivated(part);
                    }
                } else {
                    LogicEditor.this.closeEditor(false);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private LogicDiagram logicDiagram = new LogicDiagram();
    private ResourceTracker resourceListener = new ResourceTracker();
    private RulerComposite rulerComp;
    protected static final String PALETTE_DOCK_LOCATION = "Dock location";
    protected static final String PALETTE_SIZE = "Palette Size";
    protected static final String PALETTE_STATE = "Palette state";
    protected static final int DEFAULT_PALETTE_SIZE = 130;

    static {
        LogicPlugin.getDefault().getPreferenceStore().setDefault(PALETTE_SIZE, 130);
    }

    public LogicEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
        ConnectionLayer connectionLayer = (ConnectionLayer)root.getLayer((Object)"Connection Layer");
        connectionLayer.setClippingStrategy((IClippingStrategy)new ViewportAwareConnectionLayerClippingStrategy(connectionLayer));
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory());
        LogicContextMenuProvider provider = new LogicContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.gef.examples.logic.editor.contextmenu", (MenuManager)provider, (ISelectionProvider)viewer);
        viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler()));
        this.loadProperties();
        ToggleRulerVisibilityAction showRulers = new ToggleRulerVisibilityAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)showRulers);
        ToggleSnapToGeometryAction snapAction = new ToggleSnapToGeometryAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)snapAction);
        ToggleGridAction showGrid = new ToggleGridAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)showGrid);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                LogicEditor.this.handleActivationChanged(event);
            }
        };
        this.getGraphicalControl().addListener(26, listener);
        this.getGraphicalControl().addListener(27, listener);
    }

    protected void writeToOutputStream(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(this.getLogicDiagram());
        out.close();
    }

    protected GraphicalEditorWithFlyoutPalette.CustomPalettePage createPalettePage() {
        return new GraphicalEditorWithFlyoutPalette.CustomPalettePage(this, this.getPaletteViewerProvider()){

            public void init(IPageSite pageSite) {
                super.init(pageSite);
                IAction copy = LogicEditor.this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
                pageSite.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
            }
        };
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){
            private IMenuListener menuListener;

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.setCustomizer((PaletteCustomizer)new LogicPaletteCustomizer());
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }

            protected void hookPaletteViewer(PaletteViewer viewer) {
                super.hookPaletteViewer(viewer);
                final CopyTemplateAction copy = (CopyTemplateAction)LogicEditor.this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
                viewer.addSelectionChangedListener((ISelectionChangedListener)copy);
                if (this.menuListener == null) {
                    this.menuListener = new IMenuListener(){

                        public void menuAboutToShow(IMenuManager manager) {
                            manager.appendToGroup("org.eclipse.gef.group.copy", (IAction)copy);
                        }
                    };
                }
                viewer.getContextMenu().addMenuListener(this.menuListener);
            }
        };
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.partListener = null;
        ((IFileEditorInput)this.getEditorInput()).getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        super.dispose();
    }

    public void doSave(final IProgressMonitor progressMonitor) {
        this.editorSaving = true;
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                LogicEditor.this.saveProperties();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                LogicEditor.this.writeToOutputStream(out);
                IFile file = ((IFileEditorInput)LogicEditor.this.getEditorInput()).getFile();
                file.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, false, progressMonitor);
                LogicEditor.this.getCommandStack().markSaveLocation();
            }
        });
        this.editorSaving = false;
    }

    public void doSaveAs() {
        this.performSaveAs();
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            this.outlinePage = new OutlinePage((EditPartViewer)new TreeViewer());
            return this.outlinePage;
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    protected Control getGraphicalControl() {
        return this.rulerComp;
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected LogicDiagram getLogicDiagram() {
        return this.logicDiagram;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = LogicPlugin.createPalette();
        }
        return this.root;
    }

    public void gotoMarker(IMarker marker) {
    }

    protected void handleActivationChanged(Event event) {
        IAction copy = null;
        if (event.type == 27) {
            copy = this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
        }
        if (this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()) != copy) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
            this.getEditorSite().getActionBars().updateActionBars();
        }
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getGraphicalViewer().setContents((Object)this.getLogicDiagram());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new TextTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), (Transfer)TextTransfer.getInstance()));
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new CopyTemplateAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new MatchSizeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new MatchWidthAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new MatchHeightAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PasteTemplateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new IncrementDecrementAction((IWorkbenchPart)this, true);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new IncrementDecrementAction((IWorkbenchPart)this, false);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new RulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    protected FigureCanvas getEditor() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void loadProperties() {
        LogicRuler ruler = this.getLogicDiagram().getRuler(8);
        LogicRulerProvider provider = null;
        if (ruler != null) {
            provider = new LogicRulerProvider(ruler);
        }
        this.getGraphicalViewer().setProperty("vertical ruler", (Object)provider);
        ruler = this.getLogicDiagram().getRuler(1);
        provider = null;
        if (ruler != null) {
            provider = new LogicRulerProvider(ruler);
        }
        this.getGraphicalViewer().setProperty("horizontal ruler", (Object)provider);
        this.getGraphicalViewer().setProperty("ruler$visibility", (Object)new Boolean(this.getLogicDiagram().getRulerVisibility()));
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)new Boolean(this.getLogicDiagram().isSnapToGeometryEnabled()));
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)new Boolean(this.getLogicDiagram().isGridEnabled()));
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)new Boolean(this.getLogicDiagram().isGridEnabled()));
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (manager != null) {
            manager.setZoom(this.getLogicDiagram().getZoom());
        }
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    protected boolean performSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile file = workspace.getRoot().getFile(path);
        if (!file.exists()) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    LogicEditor.this.saveProperties();
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        LogicEditor.this.writeToOutputStream(out);
                        file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), true, monitor);
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)op);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.superSetInput((IEditorInput)new FileEditorInput(file));
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void saveProperties() {
        this.getLogicDiagram().setRulerVisibility((Boolean)this.getGraphicalViewer().getProperty("ruler$visibility"));
        this.getLogicDiagram().setGridEnabled((Boolean)this.getGraphicalViewer().getProperty("SnapToGrid.isEnabled"));
        this.getLogicDiagram().setSnapToGeometry((Boolean)this.getGraphicalViewer().getProperty("SnapToGeometry.isEnabled"));
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (manager != null) {
            this.getLogicDiagram().setZoom(manager.getZoom());
        }
    }

    protected void setInput(IEditorInput input) {
        this.superSetInput(input);
        IFile file = ((IFileEditorInput)input).getFile();
        try {
            InputStream is = file.getContents(false);
            ObjectInputStream ois = new ObjectInputStream(is);
            this.setLogicDiagram((LogicDiagram)ois.readObject());
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.editorSaving) {
            if (this.getGraphicalViewer() != null) {
                this.getGraphicalViewer().setContents((Object)this.getLogicDiagram());
                this.loadProperties();
            }
            if (this.outlinePage != null) {
                this.outlinePage.setContents(this.getLogicDiagram());
            }
        }
    }

    public void setLogicDiagram(LogicDiagram diagram) {
        this.logicDiagram = diagram;
    }

    protected void superSetInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.setPartName(file.getName());
        }
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    class OutlinePage
    extends ContentOutlinePage
    implements IAdaptable {
        private PageBook pageBook;
        private Control outline;
        private Canvas overview;
        private IAction showOutlineAction;
        private IAction showOverviewAction;
        static final int ID_OUTLINE = 0;
        static final int ID_OVERVIEW = 1;
        private Thumbnail thumbnail;
        private DisposeListener disposeListener;

        public OutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = LogicEditor.this.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.DELETE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "Increment";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "Decrement";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            bars.updateActionBars();
        }

        protected void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)LogicEditor.this.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new TreePartFactory());
            LogicContextMenuProvider provider = new LogicContextMenuProvider(this.getViewer(), LogicEditor.this.getActionRegistry());
            this.getViewer().setContextMenu((MenuManager)provider);
            this.getSite().registerContextMenu("org.eclipse.gef.examples.logic.outline.contextmenu", (MenuManager)provider, this.getSite().getSelectionProvider());
            this.getViewer().setKeyHandler(LogicEditor.this.getCommonKeyHandler());
            this.getViewer().addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener(this.getViewer()));
            IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
            this.showOutlineAction = new Action(){

                public void run() {
                    OutlinePage.this.showPage(0);
                }
            };
            this.showOutlineAction.setImageDescriptor(ImageDescriptor.createFromFile(LogicPlugin.class, (String)"icons/outline.gif"));
            this.showOutlineAction.setToolTipText(LogicMessages.LogicEditor_outline_show_outline);
            tbm.add(this.showOutlineAction);
            this.showOverviewAction = new Action(){

                public void run() {
                    OutlinePage.this.showPage(1);
                }
            };
            this.showOverviewAction.setImageDescriptor(ImageDescriptor.createFromFile(LogicPlugin.class, (String)"icons/overview.gif"));
            this.showOverviewAction.setToolTipText(LogicMessages.LogicEditor_outline_show_overview);
            tbm.add(this.showOverviewAction);
            this.showPage(0);
        }

        public void createControl(Composite parent) {
            this.pageBook = new PageBook(parent, 0);
            this.outline = this.getViewer().createControl((Composite)this.pageBook);
            this.overview = new Canvas((Composite)this.pageBook, 0);
            this.pageBook.showPage(this.outline);
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
        }

        public void dispose() {
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            super.dispose();
            LogicEditor.this.outlinePage = null;
            LogicEditor.this.outlinePage = null;
        }

        public Object getAdapter(Class type) {
            if (type == ZoomManager.class) {
                return LogicEditor.this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
            }
            return null;
        }

        public Control getControl() {
            return this.pageBook;
        }

        protected void hookOutlineViewer() {
            LogicEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        protected void initializeOutlineViewer() {
            this.setContents(LogicEditor.this.getLogicDiagram());
        }

        protected void initializeOverview() {
            LightweightSystem lws = new LightweightSystem(this.overview);
            RootEditPart rep = LogicEditor.this.getGraphicalViewer().getRootEditPart();
            if (rep instanceof ScalableFreeformRootEditPart) {
                ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
                this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
                this.thumbnail.setBorder((Border)new MarginBorder(3));
                this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
                lws.setContents((IFigure)this.thumbnail);
                this.disposeListener = new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (OutlinePage.this.thumbnail != null) {
                            OutlinePage.this.thumbnail.deactivate();
                            OutlinePage.this.thumbnail = null;
                        }
                    }
                };
                LogicEditor.this.getEditor().addDisposeListener(this.disposeListener);
            }
        }

        public void setContents(Object contents) {
            this.getViewer().setContents(contents);
        }

        protected void showPage(int id) {
            if (id == 0) {
                this.showOutlineAction.setChecked(true);
                this.showOverviewAction.setChecked(false);
                this.pageBook.showPage(this.outline);
                if (this.thumbnail != null) {
                    this.thumbnail.setVisible(false);
                }
            } else if (id == 1) {
                if (this.thumbnail == null) {
                    this.initializeOverview();
                }
                this.showOutlineAction.setChecked(false);
                this.showOverviewAction.setChecked(true);
                this.pageBook.showPage((Control)this.overview);
                this.thumbnail.setVisible(true);
            }
        }

        protected void unhookOutlineViewer() {
            LogicEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            if (this.disposeListener != null && LogicEditor.this.getEditor() != null && !LogicEditor.this.getEditor().isDisposed()) {
                LogicEditor.this.getEditor().removeDisposeListener(this.disposeListener);
            }
        }
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((IFileEditorInput)LogicEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = LogicEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!LogicEditor.this.isDirty()) {
                                LogicEditor.this.closeEditor(false);
                            }
                        }
                    });
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            LogicEditor.this.superSetInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            } else if (delta.getKind() == 4 && !LogicEditor.this.editorSaving) {
                final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getFullPath());
                Display display = LogicEditor.this.getSite().getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LogicEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                        LogicEditor.this.getCommandStack().flush();
                    }
                });
            }
            return false;
        }
    }
}

