/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BenchmarkTextPackage {
    static Font BIG = new Font(null, "Times", 18, 1);
    static StyledLine typing;

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(1264);
        shell.setLayout((Layout)new FillLayout());
        FigureCanvas canvas = new FigureCanvas((Composite)shell);
        Figure page = new Figure();
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(false);
        layout.setMinorAlignment(1);
        page.setLayoutManager((LayoutManager)layout);
        int i = 0;
        while (i < 50000) {
            StyledLine line = new StyledLine();
            if (i % 20 == 0) {
                line.setFont(BIG);
            }
            line.setText("This is line number " + i);
            if (i == 99) {
                typing = line;
            }
            page.add((IFigure)line);
            ++i;
        }
        canvas.setContents((IFigure)page);
        canvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                typing.setText(String.valueOf(typing.getText()) + e.character);
                typing.revalidate();
                typing.repaint();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        shell.setSize(400, 300);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    static class StyledLine
    extends Figure {
        Dimension pref;
        private String text;

        StyledLine() {
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            if (this.pref == null) {
                this.pref = FigureUtilities.getTextExtents((String)this.text, (Font)this.getFont());
            }
            return this.pref;
        }

        protected void paintFigure(Graphics graphics) {
            graphics.setFont(this.getFont());
            graphics.drawText(this.text, this.bounds.x, this.bounds.y);
        }

        public void setText(String text) {
            this.text = text;
            this.pref = null;
            this.revalidate();
        }

        public String getText() {
            return this.text;
        }
    }
}

