/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;
import org.eclipse.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.GraphModelEntityFactory;
import org.eclipse.zest.core.viewers.internal.GraphModelEntityRelationshipFactory;
import org.eclipse.zest.core.viewers.internal.GraphModelFactory;
import org.eclipse.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.zest.core.viewers.internal.ZoomManager;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.layouts.LayoutAlgorithm;

public class GraphViewer
extends AbstractStructuredGraphViewer
implements ISelectionProvider {
    protected Graph graph = null;
    private IStylingGraphModelFactory modelFactory = null;
    private List selectionChangedListeners = null;
    ZoomManager zoomManager = null;

    public GraphViewer(Composite composite, int style) {
        super(style);
        this.graph = new Graph(composite, style);
        this.hookControl((Control)this.graph);
    }

    public void setControl(Graph graphModel) {
        this.graph = graphModel;
        this.hookControl((Control)this.graph);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.selectionChangedListeners = new ArrayList();
        this.getGraphControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator iterator = GraphViewer.this.selectionChangedListeners.iterator();
                ISelection structuredSelection = GraphViewer.this.getSelection();
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)GraphViewer.this, structuredSelection);
                while (iterator.hasNext()) {
                    ISelectionChangedListener listener = (ISelectionChangedListener)iterator.next();
                    listener.selectionChanged(event);
                }
                GraphViewer.this.firePostSelectionChanged(event);
            }
        });
        control.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                DoubleClickEvent doubleClickEvent = new DoubleClickEvent((Viewer)GraphViewer.this, GraphViewer.this.getSelection());
                GraphViewer.this.fireDoubleClick(doubleClickEvent);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public int getStyle() {
        return this.graph.getStyle();
    }

    @Override
    public Graph getGraphControl() {
        return super.getGraphControl();
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm algorithm, boolean runLayout) {
        this.graph.setLayoutAlgorithm(algorithm, runLayout);
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm algorithm) {
        super.setLayoutAlgorithm(algorithm);
    }

    @Override
    public void setNodeStyle(int nodeStyle) {
        super.setNodeStyle(nodeStyle);
        this.graph.setNodeStyle(nodeStyle);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        if (contentProvider instanceof IGraphContentProvider) {
            this.modelFactory = null;
            super.setContentProvider(contentProvider);
        } else if (contentProvider instanceof IGraphEntityContentProvider) {
            this.modelFactory = null;
            super.setContentProvider(contentProvider);
        } else if (contentProvider instanceof IGraphEntityRelationshipContentProvider) {
            this.modelFactory = null;
            super.setContentProvider(contentProvider);
        } else {
            throw new IllegalArgumentException("Invalid content provider, only IGraphContentProvider, IGraphEntityContentProvider, or IGraphEntityRelationshipContentProvider are supported.");
        }
    }

    public GraphItem findGraphItem(Object element) {
        Widget[] result = this.findItems(element);
        return result.length == 0 || !(result[0] instanceof GraphItem) ? null : (GraphItem)result[0];
    }

    @Override
    public void applyLayout() {
        this.graph.applyLayout();
    }

    @Override
    protected void setSelectionToWidget(List l, boolean reveal) {
        GraphItem[] listOfItems = this.findItems(l);
        this.graph.setSelection(listOfItems);
    }

    public Control getControl() {
        return this.graph;
    }

    @Override
    public Object[] getNodeElements() {
        return super.getNodeElements();
    }

    @Override
    public Object[] getConnectionElements() {
        return super.getConnectionElements();
    }

    @Override
    public void reveal(Object element) {
        super.reveal(element);
    }

    @Override
    public void setConnectionStyle(int connectionStyle) {
        super.setConnectionStyle(connectionStyle);
    }

    @Override
    public void unReveal(Object element) {
        super.unReveal(element);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.remove(listener);
        }
    }

    @Override
    protected ZoomManager getZoomManager() {
        if (this.zoomManager == null) {
            this.zoomManager = new ZoomManager(this.getGraphControl().getRootLayer(), this.getGraphControl().getViewport());
        }
        return this.zoomManager;
    }

    @Override
    protected IStylingGraphModelFactory getFactory() {
        if (this.modelFactory == null) {
            if (this.getContentProvider() instanceof IGraphContentProvider) {
                this.modelFactory = new GraphModelFactory(this);
            } else if (this.getContentProvider() instanceof IGraphEntityContentProvider) {
                this.modelFactory = new GraphModelEntityFactory(this);
            } else if (this.getContentProvider() instanceof IGraphEntityRelationshipContentProvider) {
                this.modelFactory = new GraphModelEntityRelationshipFactory(this);
            }
        }
        return this.modelFactory;
    }

    @Override
    protected LayoutAlgorithm getLayoutAlgorithm() {
        return this.graph.getLayoutAlgorithm();
    }
}

