/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.console;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.remote.console.ITerminalConsole;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.internal.console.Activator;
import org.eclipse.remote.internal.console.ConsoleMessages;
import org.eclipse.remote.internal.console.TerminalConsoleConnector;
import org.eclipse.remote.internal.console.TerminalConsolePage;
import org.eclipse.terminal.connector.TerminalState;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.progress.UIJob;

public class TerminalConsole
extends AbstractConsole
implements ITerminalConsole {
    private final String encoding;
    private final TerminalConsoleConnector terminalConnector;
    private final int index;

    public TerminalConsole(IRemoteConnection connection, int index, String encoding) {
        super(connection.getName(), Activator.getDefault().getImageRegistry().getDescriptor("TerminalView"));
        this.encoding = encoding;
        this.terminalConnector = new TerminalConsoleConnector(connection);
        this.index = index;
    }

    public TerminalConsoleConnector getTerminalConnector() {
        return this.terminalConnector;
    }

    @Override
    public IRemoteConnection getConnection() {
        return this.terminalConnector.getConnection();
    }

    public int getIndex() {
        return this.index;
    }

    public synchronized void setState(TerminalState terminalState) {
        StringBuffer nameBuff = new StringBuffer(this.getConnection().getName());
        if (this.index > 0) {
            nameBuff.append(' ');
            nameBuff.append(String.valueOf(this.index));
        }
        nameBuff.append(" (");
        if (terminalState == TerminalState.CLOSED) {
            nameBuff.append(ConsoleMessages.STATUS_CLOSED);
        } else if (terminalState == TerminalState.CONNECTED) {
            nameBuff.append(ConsoleMessages.STATUS_CONNECTED);
        } else if (terminalState == TerminalState.CONNECTING) {
            nameBuff.append(ConsoleMessages.STATUS_CONNECTING);
        }
        nameBuff.append(")");
        final String name = nameBuff.toString();
        if (!name.equals(this.getName())) {
            UIJob job = new UIJob("updating name"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TerminalConsole.this.setName(name);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        view.setFocus();
        return new TerminalConsolePage(this, this.encoding);
    }
}

