/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.pda.ui.viewmodel.launch;

import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractContainerVMNode;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.examples.dsf.pda.service.PDACommandControl;
import org.eclipse.cdt.examples.dsf.pda.service.PDAVirtualMachineDMContext;
import org.eclipse.cdt.examples.dsf.pda.ui.PDAUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.ui.IMemento;

public class PDAVirtualMachineVMNode
extends AbstractContainerVMNode
implements IElementMementoProvider {
    private final String MEMENTO_NAME = "PDAPROGRAM_MEMENTO_NAME";

    public PDAVirtualMachineVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public String toString() {
        return "PDAContainerVMNode(" + this.getSession().getId() + ")";
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        PDACommandControl commandControl = (PDACommandControl)this.getServicesTracker().getService(PDACommandControl.class);
        if (commandControl == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        update.setChild((Object)this.createVMContext((IDMContext)commandControl.getContext()), 0);
        update.done();
    }

    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            PDAVirtualMachineDMContext dmc = (PDAVirtualMachineDMContext)this.findDmcInPath(updates[i].getViewerInput(), updates[i].getElementPath(), PDAVirtualMachineDMContext.class);
            if (dmc != null) {
                updates[i].setProperty("name", (Object)"PDA");
                updates[i].setProperty("id", (Object)dmc.getProgram());
            } else {
                updates[i].setStatus((IStatus)new Status(4, PDAUIPlugin.PLUGIN_ID, 10002, "Invalid context", null));
            }
            ++i;
        }
        super.updatePropertiesInSessionThread(updates);
    }

    private String produceProgramElementName(String viewName, PDAVirtualMachineDMContext execCtx) {
        return "PDA." + execCtx.getProgram();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString("PDAPROGRAM_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof PDAVirtualMachineDMContext) {
                String elementName = this.produceProgramElementName(request.getPresentationContext().getId(), (PDAVirtualMachineDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof PDAVirtualMachineDMContext) {
                String elementName = this.produceProgramElementName(request.getPresentationContext().getId(), (PDAVirtualMachineDMContext)dmc);
                memento.putString("PDAPROGRAM_MEMENTO_NAME", elementName);
            }
            request.done();
            ++n2;
        }
    }
}

