/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.preferences;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.utils.MarkerConfig;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;
import org.osgi.service.prefs.BackingStoreException;

public final class PreferenceHelper {
    private static final Gson DEFAULT_GSON = new GsonBuilder().registerTypeAdapter(IThemeAssociation.class, type -> new ThemeAssociation()).registerTypeAdapterFactory(new TypeAdapterFactory(){

        public <T> @Nullable TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MarkerConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter jsonElementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter problemAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MarkerConfig.ProblemMarkerConfig.class));
            final TypeAdapter taskAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MarkerConfig.TaskMarkerConfig.class));
            return new TypeAdapter<MarkerConfig>(){

                public void write(JsonWriter out, @Nullable MarkerConfig value) throws IOException {
                    Class<MarkerConfig> valueClass = ((MarkerConfig)NullSafetyHelper.castNonNull((Object)value)).getClass();
                    if (valueClass.isAssignableFrom(MarkerConfig.ProblemMarkerConfig.class)) {
                        problemAdapter.write(out, (Object)((MarkerConfig.ProblemMarkerConfig)value));
                    } else if (valueClass.isAssignableFrom(MarkerConfig.TaskMarkerConfig.class)) {
                        taskAdapter.write(out, (Object)((MarkerConfig.TaskMarkerConfig)value));
                    }
                }

                public @Nullable MarkerConfig read(JsonReader in) throws IOException {
                    JsonObject objectJson = ((JsonElement)NullSafetyHelper.castNonNull((Object)((JsonElement)jsonElementAdapter.read(in)))).getAsJsonObject();
                    return switch (MarkerConfig.Type.valueOf(objectJson.get("type").getAsString())) {
                        case MarkerConfig.Type.PROBLEM -> (MarkerConfig)problemAdapter.fromJsonTree((JsonElement)objectJson);
                        case MarkerConfig.Type.TASK -> (MarkerConfig)taskAdapter.fromJsonTree((JsonElement)objectJson);
                        default -> throw new MatchException(null, null);
                    };
                }
            };
        }
    }).create();

    public static IThemeAssociation[] loadThemeAssociations(String json) {
        return (IThemeAssociation[])NullSafetyHelper.castNonNull((Object)((ThemeAssociation[])DEFAULT_GSON.fromJson(json, ThemeAssociation[].class)));
    }

    public static String toJsonThemeAssociations(Collection<IThemeAssociation> themeAssociations) {
        return DEFAULT_GSON.toJson(themeAssociations);
    }

    public static Set<MarkerConfig> loadMarkerConfigs() {
        String json = TMUIPlugin.getPreference("org.eclipse.tm4e.ui.taskTags", null);
        Set<MarkerConfig> result = null;
        if (json != null) {
            try {
                result = PreferenceHelper.loadMarkerConfigs(json);
            }
            catch (JsonSyntaxException ex) {
                TMUIPlugin.logError((Exception)((Object)ex));
            }
        }
        return result == null ? MarkerConfig.getDefaults() : result;
    }

    public static Set<MarkerConfig> loadMarkerConfigs(String json) {
        return (Set)NullSafetyHelper.castNonNull((Object)((Set)DEFAULT_GSON.fromJson(json, new TypeToken<Set<MarkerConfig>>(){}.getType())));
    }

    public static String toJsonMarkerConfigs(Set<MarkerConfig> markerConfigs) {
        return DEFAULT_GSON.toJson(markerConfigs);
    }

    public static void saveMarkerConfigs(Set<MarkerConfig> markerConfigs) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui");
        prefs.put("org.eclipse.tm4e.ui.taskTags", PreferenceHelper.toJsonMarkerConfigs(markerConfigs));
        prefs.flush();
    }

    public static boolean isTMTokenHoverEnabled() {
        return TMUIPlugin.getPreference("org.eclipse.tm4e.ui.tmScopeHoverEnabled", false);
    }

    public static void saveTMTokenHoverEnabled(boolean isEnabled) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui");
        prefs.putBoolean("org.eclipse.tm4e.ui.tmScopeHoverEnabled", isEnabled);
        prefs.flush();
    }

    private PreferenceHelper() {
    }
}

