/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.RefactoringSessionReader;
import org.eclipse.ltk.internal.core.refactoring.RefactoringSessionTransformer;
import org.eclipse.ltk.internal.core.refactoring.XmlProcessorFactoryLtk;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptor;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptorProxy;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringContributionManager;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class RefactoringHistoryManager {
    public static final char DELIMITER_COMPONENT = '\t';
    public static final char DELIMITER_ENTRY = '\n';
    private static final Calendar fgCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT+00:00"));
    private RefactoringSessionDescriptor fCachedDescriptor = null;
    private Document fCachedDocument = null;
    private IPath fCachedPath = null;
    private IFileStore fCachedStore = null;
    private final IFileStore fHistoryStore;
    private final String fProjectName;

    public static void checkArgumentMap(Map<String, String> arguments) throws CoreException {
        Assert.isNotNull(arguments);
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            if (entry.getKey() instanceof String) {
                String string = entry.getKey();
                char[] characters = string.toCharArray();
                if (characters.length == 0) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10007, RefactoringCoreMessages.RefactoringHistoryManager_empty_argument, null));
                }
                char[] cArray = characters;
                int n = characters.length;
                int n2 = 0;
                while (n2 < n) {
                    char character = cArray[n2];
                    if (Character.isWhitespace(character)) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10007, RefactoringCoreMessages.RefactoringHistoryManager_whitespace_argument_key, null));
                    }
                    ++n2;
                }
            } else {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10007, Messages.format(RefactoringCoreMessages.RefactoringHistoryManager_non_string_argument, entry.getKey()), null));
            }
            if (entry.getValue() instanceof String) continue;
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10007, Messages.format(RefactoringCoreMessages.RefactoringHistoryManager_non_string_value, entry.getKey()), null));
        }
    }

    private static CoreException createCoreException(Throwable exception) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10006, exception.getLocalizedMessage(), exception));
    }

    public static String escapeString(String string) {
        if (string.indexOf(9) < 0) {
            int length = string.length();
            StringBuilder buffer = new StringBuilder(length + 16);
            int index = 0;
            while (index < length) {
                char character = string.charAt(index);
                if ('\t' == character) {
                    buffer.append('\t');
                }
                buffer.append(character);
                ++index;
            }
            return buffer.toString();
        }
        return string;
    }

    public static Map<String, String> getArgumentMap(RefactoringDescriptor descriptor) {
        Map<String, String> arguments = null;
        RefactoringContribution contribution = RefactoringContributionManager.getInstance().getRefactoringContribution(descriptor.getID());
        if (contribution != null) {
            arguments = contribution.retrieveArgumentMap(descriptor);
        } else if (descriptor instanceof DefaultRefactoringDescriptor) {
            arguments = ((DefaultRefactoringDescriptor)descriptor).getArguments();
        }
        return arguments;
    }

    private static void readRefactoringDescriptorProxies(IFileStore store, String project, Collection<RefactoringDescriptorProxy> collection, long start, long end, IProgressMonitor monitor, String task) throws CoreException {
        try {
            SubMonitor subMon;
            block22: {
                subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, (int)22);
                IFileInfo info = store.fetchInfo(0, (IProgressMonitor)subMon.newChild(2, 1));
                if (!info.isDirectory() && info.exists() && "refactorings.index".equalsIgnoreCase(store.getName())) {
                    try {
                        try {
                            Throwable throwable = null;
                            Object var12_12 = null;
                            try (InputStream stream = store.openInputStream(0, (IProgressMonitor)subMon.newChild(1, 1));){
                                RefactoringDescriptorProxy[] proxies = RefactoringHistoryManager.readRefactoringDescriptorProxies(stream, project, start, end);
                                collection.addAll(Arrays.asList(proxies));
                                monitor.worked(1);
                                break block22;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException exception) {
                            throw RefactoringHistoryManager.createCoreException(exception);
                        }
                    }
                    finally {
                        monitor.worked(1);
                    }
                }
                monitor.worked(4);
            }
            IFileStore[] stores = store.childStores(0, (IProgressMonitor)subMon.split(2, 1));
            SubMonitor subMonitor = subMon.newChild(12);
            try {
                subMonitor.beginTask(task, stores.length);
                IFileStore[] iFileStoreArray = stores;
                int n = stores.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore s = iFileStoreArray[n2];
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(s, project, collection, start, end, (IProgressMonitor)subMonitor.newChild(1), task);
                    ++n2;
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static RefactoringDescriptorProxy[] readRefactoringDescriptorProxies(InputStream stream, String project, long start, long end) throws IOException {
        ArrayList<DefaultRefactoringDescriptorProxy> list = new ArrayList<DefaultRefactoringDescriptorProxy>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
        while (reader.ready()) {
            int index;
            String line = reader.readLine();
            if (line == null || (index = line.indexOf(9)) <= 0) continue;
            try {
                long stamp = Long.parseLong(line.substring(0, index));
                if (stamp < start || stamp > end) continue;
                list.add(new DefaultRefactoringDescriptorProxy(RefactoringHistoryManager.unescapeString(line.substring(index + 1)), project, stamp));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return list.toArray(new RefactoringDescriptorProxy[list.size()]);
    }

    public static DefaultRefactoringDescriptor[] readRefactoringDescriptors(InputStream stream) throws CoreException {
        ArrayList<RefactoringDescriptor> list = new ArrayList<RefactoringDescriptor>(64);
        RefactoringHistoryManager.readRefactoringDescriptors(stream, list, (IProgressMonitor)new NullProgressMonitor());
        return list.toArray(new DefaultRefactoringDescriptor[list.size()]);
    }

    private static void readRefactoringDescriptors(InputStream stream, Collection<RefactoringDescriptor> collection, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 1);
            RefactoringDescriptor[] results = new RefactoringSessionReader(true, null).readSession(new InputSource(new BufferedInputStream(stream))).getRefactorings();
            Collections.addAll(collection, results);
        }
        finally {
            monitor.done();
        }
    }

    private static void removeIndexTree(IFileStore store, IProgressMonitor monitor, String task) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)16);
        try {
            IFileInfo info = store.fetchInfo(0, (IProgressMonitor)subMon.newChild(1, 1));
            if (info.isDirectory()) {
                if (".refactorings".equalsIgnoreCase(info.getName())) {
                    return;
                }
                IFileStore[] stores = store.childStores(0, (IProgressMonitor)subMon.newChild(1, 1));
                SubMonitor subMonitor = subMon.newChild(1, 1);
                try {
                    subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, stores.length);
                    IFileStore[] iFileStoreArray = stores;
                    int n = stores.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFileStore s = iFileStoreArray[n2];
                        IFileInfo current = s.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1, 1));
                        if (current.isDirectory()) {
                            char[] cArray = s.getName().toCharArray();
                            int n3 = cArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                char character = cArray[n4];
                                if (Character.isDigit(character)) {
                                    return;
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            IFileStore parent = store.getParent();
            store.delete(0, (IProgressMonitor)subMon.newChild(1, 1));
            RefactoringHistoryManager.removeIndexTree(parent, (IProgressMonitor)subMon.newChild(12, 1), task);
        }
        finally {
            subMon.done();
        }
    }

    public static void sortRefactoringDescriptorsAscending(RefactoringDescriptor[] descriptors) {
        Arrays.sort(descriptors, Comparator.comparing(RefactoringDescriptor::getTimeStamp));
    }

    public static void sortRefactoringDescriptorsAscending(RefactoringDescriptorProxy[] proxies) {
        Arrays.sort(proxies, Comparator.comparing(RefactoringDescriptorProxy::getTimeStamp));
    }

    public static void sortRefactoringDescriptorsDescending(RefactoringDescriptorProxy[] proxies) {
        Arrays.sort(proxies, Comparator.comparing(RefactoringDescriptorProxy::getTimeStamp).reversed());
    }

    public static IPath stampToPath(long stamp) {
        fgCalendar.setTimeInMillis(stamp);
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(fgCalendar.get(1));
        buffer.append('/');
        buffer.append(fgCalendar.get(2) + 1);
        buffer.append('/');
        buffer.append(fgCalendar.get(3));
        return new Path(buffer.toString());
    }

    private static Document transformDescriptor(RefactoringDescriptor descriptor, boolean projects) throws CoreException {
        RefactoringSessionTransformer transformer = new RefactoringSessionTransformer(projects);
        try {
            transformer.beginSession(null, "1.0");
            try {
                String id = descriptor.getID();
                transformer.beginRefactoring(id, descriptor.getTimeStamp(), descriptor.getProject(), descriptor.getDescription(), descriptor.getComment(), descriptor.getFlags());
                Map<String, String> arguments = RefactoringHistoryManager.getArgumentMap(descriptor);
                if (arguments != null) {
                    RefactoringHistoryManager.checkArgumentMap(arguments);
                    for (Map.Entry<String, String> entry : arguments.entrySet()) {
                        transformer.createArgument(entry.getKey(), entry.getValue());
                    }
                }
            }
            finally {
                transformer.endRefactoring();
            }
        }
        finally {
            transformer.endSession();
        }
        return transformer.getResult();
    }

    public static String unescapeString(String string) {
        if (string.indexOf(9) < 0) {
            int length = string.length();
            StringBuilder buffer = new StringBuilder(length);
            int index = 0;
            while (index < length) {
                char escape;
                char character = string.charAt(index);
                if ('\t' != character || index >= length - 1 || '\t' != (escape = string.charAt(index + 1))) {
                    buffer.append(character);
                }
                ++index;
            }
            return buffer.toString();
        }
        return string;
    }

    private static void writeIndexEntry(IFileStore file, RefactoringDescriptorProxy[] proxies, int flags, IProgressMonitor monitor, String task) throws CoreException, IOException {
        OutputStream output = null;
        try {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            file.getParent().mkdir(0, (IProgressMonitor)subMon.newChild(1, 1));
            output = new BufferedOutputStream(file.openOutputStream(flags, (IProgressMonitor)subMon.newChild(1, 1)));
            RefactoringHistoryManager.writeRefactoringDescriptorProxies(output, proxies);
        }
        finally {
            monitor.done();
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeRefactoringDescriptorProxies(OutputStream stream, RefactoringDescriptorProxy[] proxies) throws IOException {
        StringBuilder buffer = new StringBuilder(proxies.length * 64);
        RefactoringHistoryManager.sortRefactoringDescriptorsAscending(proxies);
        RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = proxies;
        int n = proxies.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
            buffer.append(proxy.getTimeStamp());
            buffer.append('\t');
            buffer.append(RefactoringHistoryManager.escapeString(proxy.getDescription()));
            buffer.append('\n');
            ++n2;
        }
        stream.write(buffer.toString().getBytes("utf-8"));
    }

    public static void writeRefactoringSession(OutputStream stream, RefactoringSessionDescriptor descriptor, boolean stamps) throws CoreException {
        RefactoringSessionTransformer transformer = new RefactoringSessionTransformer(true);
        RefactoringDescriptor[] descriptors = descriptor.getRefactorings();
        try {
            transformer.beginSession(descriptor.getComment(), descriptor.getVersion());
            RefactoringDescriptor[] refactoringDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                RefactoringDescriptor current = refactoringDescriptorArray[n2];
                if (current != null) {
                    try {
                        long stamp = stamps ? current.getTimeStamp() : -1L;
                        transformer.beginRefactoring(current.getID(), stamp, current.getProject(), current.getDescription(), current.getComment(), current.getFlags());
                        Map<String, String> arguments = RefactoringHistoryManager.getArgumentMap(current);
                        if (arguments != null) {
                            RefactoringHistoryManager.checkArgumentMap(arguments);
                            for (Map.Entry<String, String> entry : arguments.entrySet()) {
                                transformer.createArgument(entry.getKey(), entry.getValue());
                            }
                        }
                    }
                    finally {
                        transformer.endRefactoring();
                    }
                }
                ++n2;
            }
        }
        finally {
            transformer.endSession();
        }
        Document result = transformer.getResult();
        RefactoringHistoryManager.writeNode(stream, result);
    }

    private static void writeNode(OutputStream stream, Document document) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DOMWriter writer = new DOMWriter(new OutputStreamWriter(stream, Charset.forName("UTF-8")));){
            writer.printDocument(document);
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    RefactoringHistoryManager(IFileStore store, String name) {
        Assert.isNotNull((Object)store);
        Assert.isTrue((name == null || !"".equals(name) ? 1 : 0) != 0);
        this.fHistoryStore = store;
        this.fProjectName = name;
    }

    void addRefactoringDescriptor(RefactoringDescriptor descriptor, boolean sort, IProgressMonitor monitor) throws CoreException {
        block25: {
            try {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.RefactoringHistoryService_updating_history, (int)18);
                long stamp = descriptor.getTimeStamp();
                if (stamp < 0L) break block25;
                IPath path = RefactoringHistoryManager.stampToPath(stamp);
                IFileStore folder = this.fHistoryStore.getFileStore(path);
                IFileStore history = folder.getChild("refactorings.history");
                IFileStore index = folder.getChild("refactorings.index");
                RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[]{new DefaultRefactoringDescriptorProxy(descriptor.getDescription(), descriptor.getProject(), descriptor.getTimeStamp())};
                if (history.fetchInfo(0, (IProgressMonitor)subMon.newChild(1, 1)).exists()) {
                    InputStream input = null;
                    try {
                        try {
                            input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)subMon.newChild(1, 1)));
                            Document document = this.getCachedDocument(path, input);
                            try {
                                input.close();
                                input = null;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            monitor.worked(1);
                            Document result = RefactoringHistoryManager.transformDescriptor(descriptor, false);
                            if (result != null) {
                                boolean found = false;
                                NodeList list = result.getElementsByTagName("refactoring");
                                Element root = document.getDocumentElement();
                                if (sort) {
                                    String string = Long.toString(stamp);
                                    int length = list.getLength();
                                    int offset = 0;
                                    while (offset < length) {
                                        Element element = (Element)list.item(offset);
                                        String attribute = element.getAttribute("stamp");
                                        if (attribute != null && string.compareTo(attribute) > 0) {
                                            root.insertBefore(document.importNode(element, true), element);
                                            found = true;
                                            break;
                                        }
                                        ++offset;
                                    }
                                }
                                if (!found) {
                                    root.appendChild(document.importNode(list.item(0), true));
                                }
                                this.writeHistoryEntry(history, document, (IProgressMonitor)subMon.newChild(10, 1), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                                if (sort) {
                                    HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>(64);
                                    RefactoringHistoryManager.readRefactoringDescriptorProxies(index, null, set, 0L, Long.MAX_VALUE, (IProgressMonitor)subMon.newChild(2, 1), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                                    RefactoringHistoryManager.writeIndexEntry(index, set.toArray(new RefactoringDescriptorProxy[set.size()]), 0, (IProgressMonitor)subMon.newChild(3, 1), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                                } else {
                                    RefactoringHistoryManager.writeIndexEntry(index, proxies, 1, (IProgressMonitor)subMon.newChild(5, 1), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                                }
                            }
                            break block25;
                        }
                        catch (IOException | ParserConfigurationException | SAXException exception) {
                            throw RefactoringHistoryManager.createCoreException(exception);
                        }
                    }
                    finally {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                try {
                    Document result = RefactoringHistoryManager.transformDescriptor(descriptor, false);
                    this.writeHistoryEntry(history, result, (IProgressMonitor)subMon.newChild(1, 1), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                    RefactoringHistoryManager.writeIndexEntry(index, proxies, 0, (IProgressMonitor)subMon.newChild(1, 1), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                }
                catch (IOException exception) {
                    throw RefactoringHistoryManager.createCoreException(exception);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private Document getCachedDocument(IPath path, InputStream input) throws SAXException, IOException, ParserConfigurationException {
        Document document;
        if (path.equals((Object)this.fCachedPath) && this.fCachedDocument != null) {
            return this.fCachedDocument;
        }
        DocumentBuilder parser = XmlProcessorFactoryLtk.createDocumentBuilderFactoryWithErrorOnDOCTYPE().newDocumentBuilder();
        parser.setErrorHandler(new DefaultHandler());
        this.fCachedDocument = document = parser.parse(new InputSource(input));
        this.fCachedPath = path;
        return document;
    }

    private RefactoringSessionDescriptor getCachedSession(IFileStore store, String projectName, InputStream input) throws CoreException {
        if (store.equals(this.fCachedStore) && this.fCachedDescriptor != null) {
            return this.fCachedDescriptor;
        }
        try {
            RefactoringSessionDescriptor descriptor;
            this.fCachedDescriptor = descriptor = new RefactoringSessionReader(false, projectName).readSession(new InputSource(input));
            this.fCachedStore = store;
            return descriptor;
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new MultiStatus(RefactoringCorePlugin.getPluginId(), 10006, new IStatus[]{e.getStatus()}, Messages.format(RefactoringCoreMessages.RefactoringHistoryManager_error_reading_file, BasicElementLabels.getURLPart(store.toURI().toString())), null));
        }
    }

    RefactoringHistory readRefactoringHistory(long start, long end, IProgressMonitor monitor) {
        try {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, (int)200);
            HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>();
            try {
                IFileStore store;
                if (this.fHistoryStore.fetchInfo(0, (IProgressMonitor)subMon.newChild(20, 1)).exists()) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(this.fHistoryStore, this.fProjectName, set, start, end, (IProgressMonitor)subMon.newChild(80), RefactoringCoreMessages.RefactoringHistoryService_retrieving_history);
                }
                if ((store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(".refactorings").getChild(".workspace")).fetchInfo(0, (IProgressMonitor)subMon.newChild(20, 1)).exists()) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(store, null, set, start, end, (IProgressMonitor)subMon.newChild(80), RefactoringCoreMessages.RefactoringHistoryService_retrieving_history);
                }
            }
            catch (CoreException exception) {
                RefactoringCorePlugin.log(exception);
            }
            RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[set.size()];
            set.toArray(proxies);
            RefactoringHistoryImplementation refactoringHistoryImplementation = new RefactoringHistoryImplementation(proxies);
            return refactoringHistoryImplementation;
        }
        finally {
            monitor.done();
        }
    }

    private void removeRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, IPath path, IProgressMonitor monitor, String task) throws CoreException {
        block21: {
            try {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)task, (int)5);
                IFileStore folder = this.fHistoryStore.getFileStore(path);
                IFileStore index = folder.getChild("refactorings.index");
                if (!index.fetchInfo(0, (IProgressMonitor)subMon.newChild(1, 1)).exists()) break block21;
                HashSet<RefactoringDescriptorProxy> resultingProxies = new HashSet<RefactoringDescriptorProxy>(64);
                RefactoringHistoryManager.readRefactoringDescriptorProxies(index, null, resultingProxies, 0L, Long.MAX_VALUE, (IProgressMonitor)subMon.newChild(1), task);
                if (resultingProxies.size() == proxies.length) {
                    RefactoringHistoryManager.removeIndexTree(folder, (IProgressMonitor)subMon.newChild(1), task);
                    break block21;
                }
                IFileStore history = folder.getChild("refactorings.history");
                if (!history.fetchInfo(0, (IProgressMonitor)subMon.newChild(1, 1)).exists()) break block21;
                InputStream input = null;
                Document document = null;
                try {
                    try {
                        input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)subMon.newChild(1, 1)));
                        document = this.getCachedDocument(path, input);
                    }
                    catch (IOException | ParserConfigurationException | SAXException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                HashSet<Node> removedNodes = new HashSet<Node>(proxies.length);
                NodeList list = document.getElementsByTagName("refactoring");
                int length = list.getLength();
                int offset = 0;
                while (offset < length) {
                    String value;
                    Node item;
                    Node node = list.item(offset);
                    NamedNodeMap attributes = node.getAttributes();
                    if (attributes != null && (item = attributes.getNamedItem("stamp")) != null && (value = item.getNodeValue()) != null) {
                        RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = proxies;
                        int n = proxies.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
                            long stamp = proxy.getTimeStamp();
                            if (value.equals(String.valueOf(stamp))) {
                                resultingProxies.remove(new DefaultRefactoringDescriptorProxy(proxy.getDescription(), proxy.getProject(), stamp));
                                removedNodes.add(node);
                            }
                            ++n2;
                        }
                    }
                    ++offset;
                }
                for (Node node : removedNodes) {
                    node.getParentNode().removeChild(node);
                }
                try {
                    RefactoringHistoryManager.writeIndexEntry(index, resultingProxies.toArray(new RefactoringDescriptorProxy[resultingProxies.size()]), 0, (IProgressMonitor)subMon.newChild(1, 1), task);
                    this.writeHistoryEntry(history, document, (IProgressMonitor)subMon.newChild(1, 1), task);
                }
                catch (IOException exception) {
                    throw RefactoringHistoryManager.createCoreException(exception);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    void removeRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, IProgressMonitor monitor, String task) throws CoreException {
        try {
            HashMap<IPath, ArrayList<RefactoringDescriptorProxy>> paths = new HashMap<IPath, ArrayList<RefactoringDescriptorProxy>>();
            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = proxies;
            int n = proxies.length;
            int n2 = 0;
            while (n2 < n) {
                RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
                IPath path = RefactoringHistoryManager.stampToPath(proxy.getTimeStamp());
                ArrayList<RefactoringDescriptorProxy> collection = (ArrayList<RefactoringDescriptorProxy>)paths.get(path);
                if (collection == null) {
                    collection = new ArrayList<RefactoringDescriptorProxy>(64);
                    paths.put(path, collection);
                }
                collection.add(proxy);
                ++n2;
            }
            Set entries = paths.entrySet();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)task, (int)entries.size());
            for (Map.Entry entry : entries) {
                Collection collection = (Collection)entry.getValue();
                this.removeRefactoringDescriptors(collection.toArray(new RefactoringDescriptorProxy[collection.size()]), (IPath)entry.getKey(), (IProgressMonitor)subMonitor.newChild(1), task);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Exception decompiling
     */
    RefactoringDescriptor requestDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setComment(RefactoringDescriptorProxy proxy, String comment, IProgressMonitor monitor) throws CoreException {
        block17: {
            try {
                IPath path;
                IFileStore folder;
                IFileStore history;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.RefactoringHistoryService_updating_history, (int)100);
                long stamp = proxy.getTimeStamp();
                if (stamp < 0L || !(history = (folder = this.fHistoryStore.getFileStore(path = RefactoringHistoryManager.stampToPath(stamp))).getChild("refactorings.history")).fetchInfo(0, (IProgressMonitor)subMonitor.newChild(20, 1)).exists()) break block17;
                InputStream input = null;
                try {
                    try {
                        input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)subMonitor.newChild(40, 1)));
                        Document document = this.getCachedDocument(path, input);
                        try {
                            input.close();
                            input = null;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        String time = String.valueOf(stamp);
                        NodeList list = document.getElementsByTagName("refactoring");
                        int length = list.getLength();
                        int index = 0;
                        while (index < length) {
                            Element element = (Element)list.item(index);
                            if (time.equals(element.getAttribute("stamp"))) {
                                element.setAttribute("comment", comment);
                                break;
                            }
                            ++index;
                        }
                        this.writeHistoryEntry(history, document, (IProgressMonitor)subMonitor.newChild(40, 1), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                    }
                    catch (IOException | ParserConfigurationException | SAXException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void writeHistoryEntry(IFileStore file, Document document, IProgressMonitor monitor, String task) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)task, (int)2);
        file.getParent().mkdir(0, (IProgressMonitor)subMon.newChild(1, 1));
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedOutputStream output = new BufferedOutputStream(file.openOutputStream(0, (IProgressMonitor)subMon.newChild(1, 1)));){
                    RefactoringHistoryManager.writeNode(output, document);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                this.fCachedDocument = null;
                this.fCachedPath = null;
                this.fCachedDescriptor = null;
                this.fCachedStore = null;
                monitor.done();
            }
        }
        finally {
            this.fCachedDocument = null;
            this.fCachedPath = null;
            this.fCachedDescriptor = null;
            this.fCachedStore = null;
            monitor.done();
        }
    }

    private static final class DOMWriter
    extends PrintWriter {
        private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

        public DOMWriter(Writer output) {
            super(output);
        }

        public void printDocument(Document doc) {
            this.println(XML_VERSION);
            this.printElement(doc.getDocumentElement());
        }

        public void printElement(Element element) {
            boolean hasChildren = element.hasChildNodes();
            this.startTag(element, hasChildren);
            if (hasChildren) {
                boolean prevWasText = false;
                NodeList children = element.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    Node node = children.item(i);
                    if (node instanceof Element) {
                        if (!prevWasText) {
                            this.println();
                        }
                        this.printElement((Element)children.item(i));
                        prevWasText = false;
                    } else if (node instanceof Text) {
                        this.print(DOMWriter.getEscaped(node.getNodeValue()));
                        prevWasText = true;
                    }
                    ++i;
                }
                if (!prevWasText) {
                    this.println();
                }
                this.endTag(element);
            }
        }

        private void startTag(Element element, boolean hasChildren) {
            StringBuilder sb = new StringBuilder();
            sb.append("<");
            sb.append(element.getTagName());
            NamedNodeMap attributes = element.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Attr attribute = (Attr)attributes.item(i);
                sb.append(" ");
                sb.append(attribute.getName());
                sb.append("=\"");
                sb.append(DOMWriter.getEscaped(String.valueOf(attribute.getValue())));
                sb.append("\"");
                ++i;
            }
            sb.append(hasChildren ? ">" : "/>");
            this.print(sb.toString());
        }

        private void endTag(Element element) {
            StringBuilder sb = new StringBuilder();
            sb.append("</");
            sb.append(element.getNodeName());
            sb.append(">");
            this.print(sb.toString());
        }

        private static void appendEscapedChar(StringBuilder buffer, char c) {
            String replacement = DOMWriter.getReplacement(c);
            if (replacement != null) {
                buffer.append('&');
                buffer.append(replacement);
                buffer.append(';');
            } else {
                buffer.append(c);
            }
        }

        private static String getEscaped(String s) {
            StringBuilder result = new StringBuilder(s.length() + 10);
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                DOMWriter.appendEscapedChar(result, c);
                ++n2;
            }
            return result.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
                case '\r': {
                    return "#x0D";
                }
                case '\n': {
                    return "#x0A";
                }
                case '\t': {
                    return "#x09";
                }
            }
            return null;
        }
    }
}

