/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.refactoring.descriptors.EncapsulateFieldDescriptor;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.DimensionRewrite;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.sef.AccessAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SelfEncapsulateFieldRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_GETTER = "getter";
    private static final String ATTRIBUTE_SETTER = "setter";
    private static final String ATTRIBUTE_INSERTION = "insertion";
    private static final String ATTRIBUTE_COMMENTS = "comments";
    private static final String ATTRIBUTE_DECLARING = "declaring";
    private IField fField;
    private TextChangeManager fChangeManager = new TextChangeManager();
    private CompilationUnit fRoot;
    private VariableDeclarationFragment fFieldDeclaration;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private int fVisibility = -1;
    private String fGetterName = "";
    private boolean fCreateGetter;
    private String fSetterName = "";
    private boolean fCreateSetter;
    private String fArgName;
    private boolean fSetterMustReturnValue;
    private int fInsertionIndex;
    private boolean fEncapsulateDeclaringClass = true;
    private boolean fGenerateJavadoc;
    private List<IMethodBinding> fUsedReadNames;
    private List<IMethodBinding> fUsedModifyNames;
    private boolean fConsiderVisibility = true;
    private static final String NO_NAME = "";

    public SelfEncapsulateFieldRefactoring(IField field) throws JavaModelException {
        this.fField = field;
        if (field != null) {
            this.initialize(field);
        }
    }

    private void initialize(IField field) throws JavaModelException {
        this.setGetterName(GetterSetterUtil.getGetterName(field, null));
        this.setSetterName(GetterSetterUtil.getSetterName(field, null));
        String argBaseName = StubUtility.getBaseName(field);
        this.fArgName = StubUtility.suggestArgumentName(field.getJavaProject(), argBaseName, new String[0]);
        this.checkArgName();
    }

    public void reinitialize() {
        try {
            this.initialize(this.fField);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public IField getField() {
        return this.fField;
    }

    public String getGetterName() {
        return this.fGetterName;
    }

    public void setGetterName(String name) {
        Assert.isNotNull((Object)name);
        this.fGetterName = name;
        this.fCreateGetter = !name.isEmpty();
    }

    public String getSetterName() {
        return this.fSetterName;
    }

    public void setSetterName(String name) {
        Assert.isNotNull((Object)name);
        this.fSetterName = name;
        this.fCreateSetter = !name.isEmpty();
    }

    public void setInsertionIndex(int index) {
        this.fInsertionIndex = index;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    public void setEncapsulateDeclaringClass(boolean encapsulateDeclaringClass) {
        this.fEncapsulateDeclaringClass = encapsulateDeclaringClass;
    }

    public boolean getEncapsulateDeclaringClass() {
        return this.fEncapsulateDeclaringClass;
    }

    public boolean getGenerateJavadoc() {
        return this.fGenerateJavadoc;
    }

    public void setGenerateJavadoc(boolean value) {
        this.fGenerateJavadoc = value;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fVisibility < 0) {
            this.fVisibility = this.fField.getFlags() & 7;
        }
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkAvailability((IJavaElement)this.fField));
        if (result.hasFatalError()) {
            return result;
        }
        this.fRoot = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)this.fField.getCompilationUnit(), true, pm);
        ISourceRange sourceRange = this.fField.getNameRange();
        ASTNode node = NodeFinder.perform((ASTNode)this.fRoot, (int)sourceRange.getOffset(), (int)sourceRange.getLength());
        if (node == null) {
            return this.mappingErrorFound(result, node);
        }
        this.fFieldDeclaration = ASTNodes.getParent(node, VariableDeclarationFragment.class);
        if (this.fFieldDeclaration == null) {
            return this.mappingErrorFound(result, node);
        }
        if (this.fFieldDeclaration.resolveBinding() == null) {
            if (!this.processCompilerError(result, node)) {
                result.addFatalError(RefactoringCoreMessages.SelfEncapsulateField_type_not_resolveable);
            }
            return result;
        }
        this.computeUsedNames();
        return result;
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus result, ASTNode node) {
        if (node != null && (node.getFlags() & 1) != 0 && this.processCompilerError(result, node)) {
            return result;
        }
        result.addFatalError(this.getMappingErrorMessage());
        return result;
    }

    private boolean processCompilerError(RefactoringStatus result, ASTNode node) {
        Message[] messages = ASTNodes.getMessages(node, 2);
        if (messages.length == 0) {
            return false;
        }
        result.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_compiler_errors_field, new String[]{BasicElementLabels.getJavaElementName(this.fField.getElementName()), messages[0].getMessage()}));
        return true;
    }

    private String getMappingErrorMessage() {
        return Messages.format(RefactoringCoreMessages.SelfEncapsulateField_cannot_analyze_selected_field, BasicElementLabels.getJavaElementName(this.fField.getElementName()));
    }

    public RefactoringStatus checkMethodNames() {
        return this.checkMethodNames(this.isUsingLocalGetter(), this.isUsingLocalSetter());
    }

    public RefactoringStatus checkMethodNames(boolean usingLocalGetter, boolean usingLocalSetter) {
        RefactoringStatus result = new RefactoringStatus();
        IType declaringType = this.fField.getDeclaringType();
        if (this.fCreateGetter) {
            SelfEncapsulateFieldRefactoring.checkName(result, this.fGetterName, this.fUsedReadNames, declaringType, usingLocalGetter, this.fField);
        }
        if (this.fCreateSetter) {
            SelfEncapsulateFieldRefactoring.checkName(result, this.fSetterName, this.fUsedModifyNames, declaringType, usingLocalSetter, this.fField);
        }
        return result;
    }

    private static void checkName(RefactoringStatus status, String name, List<IMethodBinding> usedNames, IType type, boolean reUseExistingField, IField field) {
        if (NO_NAME.equals(name)) {
            status.addFatalError(RefactoringCoreMessages.Checks_Choose_name);
            return;
        }
        boolean isStatic = false;
        try {
            isStatic = Flags.isStatic((int)field.getFlags());
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
        }
        status.merge(Checks.checkMethodName(name, (IJavaElement)field));
        for (IMethodBinding method : usedNames) {
            String selector = method.getName();
            if (!selector.equals(name)) continue;
            if (!reUseExistingField) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_method_exists, new String[]{BindingLabelProviderCore.getBindingLabel((IBinding)method, 2235681801344L), BasicElementLabels.getJavaElementName(type.getElementName())}));
                continue;
            }
            boolean methodIsStatic = Modifier.isStatic((int)method.getModifiers());
            if (methodIsStatic && !isStatic) {
                status.addWarning(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_static_method_but_nonstatic_field, new String[]{BasicElementLabels.getJavaElementName(method.getName()), BasicElementLabels.getJavaElementName(field.getElementName())}));
            }
            if (!methodIsStatic && isStatic) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_nonstatic_method_but_static_field, new String[]{BasicElementLabels.getJavaElementName(method.getName()), BasicElementLabels.getJavaElementName(field.getElementName())}));
            }
            return;
        }
        if (reUseExistingField) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_methoddoesnotexist_status_fatalError, new String[]{BasicElementLabels.getJavaElementName(name), BasicElementLabels.getJavaElementName(type.getElementName())}));
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(NO_NAME, 12);
        pm.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_checking_preconditions);
        RefactoringStatus result = new RefactoringStatus();
        this.fRewriter = ASTRewrite.create((AST)this.fRoot.getAST());
        this.fChangeManager.clear();
        boolean usingLocalGetter = this.isUsingLocalGetter();
        boolean usingLocalSetter = this.isUsingLocalSetter();
        result.merge(this.checkMethodNames(usingLocalGetter, usingLocalSetter));
        pm.worked(1);
        if (result.hasFatalError()) {
            return result;
        }
        pm.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_searching_for_cunits);
        IProgressMonitor subPm = Progress.subMonitor(pm, 5);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fField, (int)2);
        if (pattern == null) {
            return result;
        }
        ICompilationUnit[] affectedCUs = RefactoringSearchEngine.findAffectedCompilationUnits(pattern, RefactoringScopeFactory.create((IJavaElement)this.fField, this.fConsiderVisibility), subPm, result, true);
        this.checkAffectedCUs(result, affectedCUs);
        this.checkInHierarchy(result, usingLocalGetter, usingLocalSetter);
        if (result.hasFatalError()) {
            return result;
        }
        pm.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_analyzing);
        IProgressMonitor sub = Progress.subMonitor(pm, 5);
        sub.beginTask(NO_NAME, affectedCUs.length);
        IVariableBinding fieldIdentifier = this.fFieldDeclaration.resolveBinding();
        ITypeBinding declaringClass = ASTNodes.getParent((ASTNode)this.fFieldDeclaration, AbstractTypeDeclaration.class).resolveBinding();
        ArrayList<TextEditGroup> ownerDescriptions = new ArrayList<TextEditGroup>();
        ICompilationUnit owner = this.fField.getCompilationUnit();
        this.fImportRewrite = StubUtility.createImportRewrite(this.fRoot, true);
        ICompilationUnit[] iCompilationUnitArray = affectedCUs;
        int n = affectedCUs.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<Object> descriptions;
            ImportRewrite importRewrite;
            ICompilationUnit unit = iCompilationUnitArray[n2];
            sub.subTask(BasicElementLabels.getFileName((ITypeRoot)unit));
            CompilationUnit root = null;
            ASTRewrite rewriter = null;
            if (owner.equals(unit)) {
                root = this.fRoot;
                rewriter = this.fRewriter;
                importRewrite = this.fImportRewrite;
                descriptions = ownerDescriptions;
            } else {
                root = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)unit, true);
                rewriter = ASTRewrite.create((AST)root.getAST());
                descriptions = new ArrayList();
                importRewrite = StubUtility.createImportRewrite(root, true);
            }
            this.checkCompileErrors(result, root, unit);
            AccessAnalyzer analyzer = new AccessAnalyzer(this, unit, fieldIdentifier, declaringClass, rewriter, importRewrite);
            root.accept((ASTVisitor)analyzer);
            result.merge(analyzer.getStatus());
            if (!this.fSetterMustReturnValue) {
                this.fSetterMustReturnValue = analyzer.getSetterMustReturnValue();
            }
            if (result.hasFatalError()) {
                this.fChangeManager.clear();
                return result;
            }
            descriptions.addAll(analyzer.getGroupDescriptions());
            if (!owner.equals(unit)) {
                this.createEdits(unit, rewriter, descriptions, importRewrite);
            }
            sub.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        ownerDescriptions.addAll(this.addGetterSetterChanges(this.fRoot, this.fRewriter, owner.findRecommendedLineSeparator(), usingLocalSetter, usingLocalGetter));
        this.createEdits(owner, this.fRewriter, ownerDescriptions, this.fImportRewrite);
        sub.done();
        IFile[] filesToBeModified = ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
        result.merge(Checks.validateModifiesFiles(filesToBeModified, this.getValidationContext(), pm));
        if (result.hasFatalError()) {
            return result;
        }
        ResourceChangeChecker.checkFilesToBeChanged((IFile[])filesToBeModified, (IProgressMonitor)Progress.subMonitor(pm, 1));
        return result;
    }

    private void checkAffectedCUs(RefactoringStatus result, ICompilationUnit[] affectedCUs) {
        AffectedCUVisitor visitor = new AffectedCUVisitor();
        try {
            ICompilationUnit[] iCompilationUnitArray = affectedCUs;
            int n = affectedCUs.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit cu = iCompilationUnitArray[n2];
                CompilationUnit root = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)cu, true);
                root.accept((ASTVisitor)visitor);
                ++n2;
            }
        }
        catch (AbortSearchException e) {
            result.addError(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_subtype_method_exists, new String[]{visitor.isGetterConflict() ? this.getGetterName() : this.getSetterName(), visitor.getTypeName()}));
        }
    }

    private void createEdits(ICompilationUnit unit, ASTRewrite rewriter, List<TextEditGroup> groups, ImportRewrite importRewrite) throws CoreException {
        TextChange change = this.fChangeManager.get(unit);
        MultiTextEdit root = new MultiTextEdit();
        change.setEdit((TextEdit)root);
        root.addChild(importRewrite.rewriteImports(null));
        root.addChild(rewriter.rewriteAST());
        for (TextEditGroup textEditGroup : groups) {
            change.addTextEditGroup(textEditGroup);
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        String visibility;
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fField.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 589830;
        IType declaring = this.fField.getDeclaringType();
        try {
            if (declaring.isAnonymous() || declaring.isLocal()) {
                flags |= 0x40000;
            }
        }
        catch (JavaModelException exception) {
            JavaManipulationPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.SelfEncapsulateField_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fField.getElementName()));
        String header = Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_descriptor_description, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)this.fField, 2235681801344L), JavaElementLabelsCore.getElementLabel((IJavaElement)declaring, 2235681801344L)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_original_pattern, JavaElementLabelsCore.getElementLabel((IJavaElement)this.fField, 2235681801344L)));
        if (this.fCreateGetter) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_getter_pattern, BasicElementLabels.getJavaElementName(this.fGetterName)));
        }
        if (this.fCreateSetter) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_setter_pattern, BasicElementLabels.getJavaElementName(this.fSetterName)));
        }
        if (NO_NAME.equals(visibility = JdtFlags.getVisibilityString(this.fVisibility))) {
            visibility = RefactoringCoreMessages.SelfEncapsulateField_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_visibility_pattern, visibility));
        if (this.fEncapsulateDeclaringClass) {
            comment.addSetting(RefactoringCoreMessages.SelfEncapsulateField_use_accessors);
        } else {
            comment.addSetting(RefactoringCoreMessages.SelfEncapsulateField_do_not_use_accessors);
        }
        if (this.fGenerateJavadoc) {
            comment.addSetting(RefactoringCoreMessages.SelfEncapsulateField_generate_comments);
        }
        EncapsulateFieldDescriptor descriptor = RefactoringSignatureDescriptorFactory.createEncapsulateFieldDescriptor(project, description, comment.asString(), arguments, flags);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fField));
        arguments.put(ATTRIBUTE_VISIBILITY, Integer.toString(this.fVisibility));
        arguments.put(ATTRIBUTE_INSERTION, Integer.toString(this.fInsertionIndex));
        if (this.fCreateSetter) {
            arguments.put(ATTRIBUTE_SETTER, this.fSetterName);
        }
        if (this.fCreateGetter) {
            arguments.put(ATTRIBUTE_GETTER, this.fGetterName);
        }
        arguments.put(ATTRIBUTE_COMMENTS, Boolean.toString(this.fGenerateJavadoc));
        arguments.put(ATTRIBUTE_DECLARING, Boolean.toString(this.fEncapsulateDeclaringClass));
        DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange(descriptor, this.getName());
        TextChange[] changes = this.fChangeManager.getAllChanges();
        pm.beginTask(NO_NAME, changes.length);
        pm.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_create_changes);
        TextChange[] textChangeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            TextChange change = textChangeArray[n2];
            result.add((Change)change);
            pm.worked(1);
            ++n2;
        }
        pm.done();
        return result;
    }

    public String getName() {
        return RefactoringCoreMessages.SelfEncapsulateField_name;
    }

    private void checkCompileErrors(RefactoringStatus result, CompilationUnit root, ICompilationUnit element) {
        IProblem[] iProblemArray = root.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (!this.isIgnorableProblem(problem)) {
                result.addWarning(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_compiler_errors_update, BasicElementLabels.getFileName((ITypeRoot)element)), JavaStatusContext.create((ITypeRoot)element));
                return;
            }
            ++n2;
        }
    }

    private void checkInHierarchy(RefactoringStatus status, boolean usingLocalGetter, boolean usingLocalSetter) {
        AbstractTypeDeclaration declaration = ASTNodes.getParent((ASTNode)this.fFieldDeclaration, AbstractTypeDeclaration.class);
        ITypeBinding type = declaration.resolveBinding();
        if (type != null) {
            ITypeBinding fieldType = this.fFieldDeclaration.resolveBinding().getType();
            if (this.fCreateGetter) {
                SelfEncapsulateFieldRefactoring.checkMethodInHierarchy(type, this.fGetterName, fieldType, new ITypeBinding[0], status, usingLocalGetter);
            }
            if (this.fCreateSetter) {
                SelfEncapsulateFieldRefactoring.checkMethodInHierarchy(type, this.fSetterName, this.fFieldDeclaration.getAST().resolveWellKnownType("void"), new ITypeBinding[]{fieldType}, status, usingLocalSetter);
            }
        }
    }

    public static void checkMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding returnType, ITypeBinding[] parameters, RefactoringStatus result, boolean reUseMethod) {
        IMethodBinding method = Bindings.findMethodInHierarchy(type, methodName, parameters);
        if (method != null) {
            boolean returnTypeClash = false;
            ITypeBinding methodReturnType = method.getReturnType();
            if (returnType != null && methodReturnType != null) {
                String returnTypeKey = returnType.getKey();
                String methodReturnTypeKey = methodReturnType.getKey();
                if (returnTypeKey == null && methodReturnTypeKey == null) {
                    returnTypeClash = returnType != methodReturnType;
                } else if (returnTypeKey != null && methodReturnTypeKey != null) {
                    returnTypeClash = !returnTypeKey.equals(methodReturnTypeKey);
                }
            }
            ITypeBinding dc = method.getDeclaringClass();
            if (returnTypeClash) {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_returnTypeClash, new Object[]{BasicElementLabels.getJavaElementName(methodName), BasicElementLabels.getJavaElementName(dc.getName())}), JavaStatusContext.create(method));
            } else if (!reUseMethod) {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_overrides, new Object[]{BasicElementLabels.getJavaElementName(methodName), BasicElementLabels.getJavaElementName(dc.getName())}), JavaStatusContext.create(method));
            }
        } else if (reUseMethod) {
            result.addError(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_nosuchmethod_status_fatalError, BasicElementLabels.getJavaElementName(methodName)), JavaStatusContext.create(method));
        }
    }

    private void computeUsedNames() {
        this.fUsedReadNames = new ArrayList<IMethodBinding>(0);
        this.fUsedModifyNames = new ArrayList<IMethodBinding>(0);
        IVariableBinding binding = this.fFieldDeclaration.resolveBinding();
        ITypeBinding type = binding.getType();
        IMethodBinding[] iMethodBindingArray = binding.getDeclaringClass().getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            ITypeBinding[] parameters = method.getParameterTypes();
            if (parameters == null || parameters.length == 0) {
                this.fUsedReadNames.add(method);
            } else if (parameters.length == 1 && parameters[0] == type) {
                this.fUsedModifyNames.add(method);
            }
            ++n2;
        }
    }

    private List<TextEditGroup> addGetterSetterChanges(CompilationUnit root, ASTRewrite rewriter, String lineDelimiter, boolean usingLocalSetter, boolean usingLocalGetter) throws CoreException {
        TextEditGroup description;
        ArrayList<TextEditGroup> result = new ArrayList<TextEditGroup>(2);
        AST ast = root.getAST();
        FieldDeclaration decl = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, 23);
        int position = 0;
        int numberOfMethods = 0;
        List<BodyDeclaration> members = ASTNodes.getBodyDeclarations(decl.getParent());
        for (BodyDeclaration element : members) {
            if (element.getNodeType() == 31) {
                if (this.fInsertionIndex == -1) break;
                if (this.fInsertionIndex == numberOfMethods) {
                    ++position;
                    break;
                }
                ++numberOfMethods;
            }
            ++position;
        }
        ListRewrite rewrite = this.fRewriter.getListRewrite(decl.getParent(), this.getBodyDeclarationsProperty(decl.getParent()));
        if (!usingLocalGetter && this.fCreateGetter) {
            description = new TextEditGroup(RefactoringCoreMessages.SelfEncapsulateField_add_getter);
            result.add(description);
            rewrite.insertAt((ASTNode)this.createGetterMethod(ast, rewriter, lineDelimiter), position++, description);
        }
        if (!JdtFlags.isFinal((IMember)this.fField) && !usingLocalSetter && this.fCreateSetter) {
            description = new TextEditGroup(RefactoringCoreMessages.SelfEncapsulateField_add_setter);
            result.add(description);
            rewrite.insertAt((ASTNode)this.createSetterMethod(ast, rewriter, lineDelimiter), position, description);
        }
        if (!JdtFlags.isPrivate((IMember)this.fField) && this.fCreateGetter && this.fCreateSetter) {
            result.add(this.makeDeclarationPrivate(rewriter, decl));
        }
        return result;
    }

    private TextEditGroup makeDeclarationPrivate(ASTRewrite rewriter, FieldDeclaration decl) {
        TextEditGroup description = new TextEditGroup(RefactoringCoreMessages.SelfEncapsulateField_change_visibility);
        VariableDeclarationFragment[] vdfs = new VariableDeclarationFragment[]{this.fFieldDeclaration};
        int includedModifiers = 2;
        int excludedModifiers = 5;
        VariableDeclarationRewrite.rewriteModifiers(decl, vdfs, includedModifiers, excludedModifiers, rewriter, description);
        return description;
    }

    private ChildListPropertyDescriptor getBodyDeclarationsProperty(ASTNode declaration) {
        if (declaration instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        if (declaration instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)declaration).getBodyDeclarationsProperty();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private MethodDeclaration createSetterMethod(AST ast, ASTRewrite rewriter, String lineDelimiter) throws CoreException {
        String string;
        FieldDeclaration field = ASTNodes.getParent((ASTNode)this.fFieldDeclaration, FieldDeclaration.class);
        Type type = field.getType();
        MethodDeclaration result = ast.newMethodDeclaration();
        result.setName(ast.newSimpleName(this.fSetterName));
        result.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.createModifiers()));
        if (this.fSetterMustReturnValue) {
            result.setReturnType2((Type)rewriter.createCopyTarget((ASTNode)type));
        }
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        result.parameters().add(param);
        param.setName(ast.newSimpleName(this.fArgName));
        param.setType((Type)rewriter.createCopyTarget((ASTNode)type));
        List modifiers = field.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            String annotationName;
            if (!modifier.isAnnotation() || !"NonNull".equals(annotationName = ((Annotation)modifier).getTypeName().getFullyQualifiedName()) && !"Nullable".equals(annotationName)) continue;
            Annotation fieldAnnotation = (Annotation)rewriter.createCopyTarget((ASTNode)((Annotation)modifier));
            param.modifiers().add(fieldAnnotation);
        }
        List<Dimension> extraDimensions = DimensionRewrite.copyDimensions(this.fFieldDeclaration.extraDimensions(), rewriter);
        param.extraDimensions().addAll(extraDimensions);
        Block block = ast.newBlock();
        result.setBody(block);
        String fieldAccess = this.createFieldAccess();
        String body = CodeGeneration.getSetterMethodBodyContent(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fSetterName, fieldAccess, this.fArgName, lineDelimiter);
        if (body != null) {
            ASTNode setterNode = rewriter.createStringPlaceholder(body, 8);
            block.statements().add(setterNode);
        } else {
            Assignment ass = ast.newAssignment();
            ass.setLeftHandSide((Expression)rewriter.createStringPlaceholder(fieldAccess, 40));
            ass.setRightHandSide((Expression)ast.newSimpleName(this.fArgName));
            block.statements().add(ass);
        }
        if (this.fSetterMustReturnValue) {
            ReturnStatement rs = ast.newReturnStatement();
            rs.setExpression((Expression)ast.newSimpleName(this.fArgName));
            block.statements().add(rs);
        }
        if (this.fGenerateJavadoc && (string = CodeGeneration.getSetterComment(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fSetterName, this.fField.getElementName(), ASTNodes.asString((ASTNode)type), this.fArgName, StubUtility.getBaseName(this.fField), lineDelimiter)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string, 29);
            result.setJavadoc(javadoc);
        }
        return result;
    }

    private MethodDeclaration createGetterMethod(AST ast, ASTRewrite rewriter, String lineDelimiter) throws CoreException {
        String string;
        FieldDeclaration field = ASTNodes.getParent((ASTNode)this.fFieldDeclaration, FieldDeclaration.class);
        Type type = field.getType();
        MethodDeclaration result = ast.newMethodDeclaration();
        result.setName(ast.newSimpleName(this.fGetterName));
        result.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.createModifiers()));
        List modifiers = field.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            String annotationName;
            if (!modifier.isAnnotation() || !"NonNull".equals(annotationName = ((Annotation)modifier).getTypeName().getFullyQualifiedName()) && !"Nullable".equals(annotationName)) continue;
            Annotation fieldAnnotation = (Annotation)rewriter.createCopyTarget((ASTNode)((Annotation)modifier));
            result.modifiers().add(fieldAnnotation);
        }
        Type returnType = DimensionRewrite.copyTypeAndAddDimensions(type, this.fFieldDeclaration.extraDimensions(), rewriter);
        result.setReturnType2(returnType);
        Block block = ast.newBlock();
        result.setBody(block);
        String body = CodeGeneration.getGetterMethodBodyContent(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fGetterName, this.fField.getElementName(), lineDelimiter);
        if (body != null) {
            ASTNode getterNode = rewriter.createStringPlaceholder(body, 8);
            block.statements().add(getterNode);
        } else {
            ReturnStatement rs = ast.newReturnStatement();
            rs.setExpression((Expression)ast.newSimpleName(this.fField.getElementName()));
            block.statements().add(rs);
        }
        if (this.fGenerateJavadoc && (string = CodeGeneration.getGetterComment(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fGetterName, this.fField.getElementName(), ASTNodes.asString((ASTNode)type), StubUtility.getBaseName(this.fField), lineDelimiter)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string, 29);
            result.setJavadoc(javadoc);
        }
        return result;
    }

    private int createModifiers() throws JavaModelException {
        int result = 0;
        if (Flags.isPublic((int)this.fVisibility)) {
            result |= 1;
        } else if (Flags.isProtected((int)this.fVisibility)) {
            result |= 4;
        } else if (Flags.isPrivate((int)this.fVisibility)) {
            result |= 2;
        }
        if (JdtFlags.isStatic((IMember)this.fField)) {
            result |= 8;
        }
        return result;
    }

    private String createFieldAccess() throws JavaModelException {
        String fieldName = this.fField.getElementName();
        boolean nameConflict = this.fArgName.equals(fieldName);
        if (JdtFlags.isStatic((IMember)this.fField)) {
            if (nameConflict) {
                return JavaModelUtil.concatenateName(this.fField.getDeclaringType().getElementName(), fieldName);
            }
        } else if (nameConflict || StubUtility.useThisForFieldAccess(this.fField.getJavaProject())) {
            return "this." + fieldName;
        }
        return fieldName;
    }

    private void checkArgName() {
        String fieldName = this.fField.getElementName();
        boolean isStatic = true;
        try {
            isStatic = JdtFlags.isStatic((IMember)this.fField);
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
        }
        if (isStatic && this.fArgName.equals(fieldName) && fieldName.equals(this.fField.getDeclaringType().getElementName()) || JavaConventionsUtil.validateIdentifier(this.fArgName, (IJavaElement)this.fField).getSeverity() == 4) {
            this.fArgName = "_" + this.fArgName;
        }
    }

    private String getTypeName(ASTNode type) {
        if (type instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)type).getName().getIdentifier();
        }
        if (type instanceof AnonymousClassDeclaration) {
            ClassInstanceCreation node = ASTNodes.getParent(type, ClassInstanceCreation.class);
            return ASTNodes.asString((ASTNode)node.getType());
        }
        Assert.isTrue((boolean)false, (String)"Should not happen");
        return null;
    }

    public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String insertion;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 8) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.self.encapsulate");
            }
            this.fField = (IField)element;
            try {
                this.initialize(this.fField);
            }
            catch (JavaModelException exception) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.self.encapsulate");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        String name = arguments.getAttribute(ATTRIBUTE_GETTER);
        if (name == null || name.isEmpty()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_GETTER));
        }
        this.fGetterName = name;
        name = arguments.getAttribute(ATTRIBUTE_SETTER);
        if (name == null || name.isEmpty()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SETTER));
        }
        this.fSetterName = name;
        String encapsulate = arguments.getAttribute(ATTRIBUTE_DECLARING);
        if (encapsulate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DECLARING));
        }
        this.fEncapsulateDeclaringClass = Boolean.parseBoolean(encapsulate);
        String matches = arguments.getAttribute(ATTRIBUTE_COMMENTS);
        if (matches == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_COMMENTS));
        }
        this.fGenerateJavadoc = Boolean.parseBoolean(matches);
        String visibility = arguments.getAttribute(ATTRIBUTE_VISIBILITY);
        if (visibility != null && !NO_NAME.equals(visibility)) {
            int flag = 0;
            try {
                flag = Integer.parseInt(visibility);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
            }
            this.fVisibility = flag;
        }
        if ((insertion = arguments.getAttribute(ATTRIBUTE_INSERTION)) != null && !NO_NAME.equals(insertion)) {
            int index = 0;
            try {
                index = Integer.parseInt(insertion);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_INSERTION));
            }
            this.fInsertionIndex = index;
        }
        return new RefactoringStatus();
    }

    public boolean isUsingLocalGetter() {
        return SelfEncapsulateFieldRefactoring.checkName(this.fGetterName, this.fUsedReadNames);
    }

    public boolean isUsingLocalSetter() {
        return SelfEncapsulateFieldRefactoring.checkName(this.fSetterName, this.fUsedModifyNames);
    }

    private static boolean checkName(String name, List<IMethodBinding> usedNames) {
        for (IMethodBinding method : usedNames) {
            String selector = method.getName();
            if (!selector.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnorableProblem(IProblem problem) {
        return problem.getID() == 33554503;
    }

    public boolean isConsiderVisibility() {
        return this.fConsiderVisibility;
    }

    public void setConsiderVisibility(boolean considerVisibility) {
        this.fConsiderVisibility = considerVisibility;
    }

    private class AffectedCUVisitor
    extends ASTVisitor {
        private String fTypeName = null;
        private boolean fGetterConflict = false;

        private AffectedCUVisitor() {
        }

        public String getTypeName() {
            return this.fTypeName;
        }

        public boolean isGetterConflict() {
            return this.fGetterConflict;
        }

        public boolean visit(TypeDeclaration node) {
            ITypeBinding typeBinding = node.resolveBinding();
            while (typeBinding != null) {
                IMethodBinding[] methodBindings;
                IMethodBinding[] iMethodBindingArray = methodBindings = typeBinding.getDeclaredMethods();
                int n = methodBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethodBinding methodBinding = iMethodBindingArray[n2];
                    if (methodBinding.getName().equals(SelfEncapsulateFieldRefactoring.this.getGetterName()) && methodBinding.getParameterNames().length == 0) {
                        this.fTypeName = typeBinding.getName();
                        this.fGetterConflict = true;
                        throw new AbortSearchException();
                    }
                    if (methodBinding.getName().equals(SelfEncapsulateFieldRefactoring.this.getSetterName()) && methodBinding.getParameterNames().length == 1 && methodBinding.getParameterTypes()[0].isEqualTo((IBinding)SelfEncapsulateFieldRefactoring.this.fFieldDeclaration.resolveBinding().getType())) {
                        this.fTypeName = typeBinding.getName();
                        throw new AbortSearchException();
                    }
                    ++n2;
                }
                typeBinding = typeBinding.getSuperclass();
            }
            return true;
        }
    }
}

