/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.text.correction.IInvocationContextCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.MissingReturnTypeCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.MissingReturnTypeInLambdaCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ReplaceCorrectionProposalCore;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.TypeMismatchSubProcessor;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;

public class ReturnTypeSubProcessor {
    /*
     * WARNING - void declaration
     */
    public static void addVoidMethodReturnsProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)selectedNode);
        BodyDeclaration bodyDeclaration = decl;
        if (bodyDeclaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration;
            if (selectedNode.getNodeType() == 41) {
                ReturnStatement returnStatement = (ReturnStatement)selectedNode;
                Expression expr = returnStatement.getExpression();
                if (expr != null) {
                    void methodDeclaration2;
                    AST ast = astRoot.getAST();
                    ITypeBinding binding = Bindings.normalizeTypeBinding((ITypeBinding)expr.resolveTypeBinding());
                    if (binding == null) {
                        binding = ast.resolveWellKnownType("java.lang.Object");
                    }
                    if (binding.isWildcardType()) {
                        binding = ASTResolving.normalizeWildcardType((ITypeBinding)binding, (boolean)true, (AST)ast);
                    }
                    ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                    String label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_voidmethodreturns_description, BindingLabelProviderCore.getBindingLabel((IBinding)binding, (long)0x200009L));
                    LinkedCorrectionProposalCore proposal = new LinkedCorrectionProposalCore(label, cu, rewrite, 6);
                    ImportRewrite imports = proposal.createImportRewrite(astRoot);
                    ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)methodDeclaration2, imports);
                    Type newReturnType = imports.addImport(binding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
                    if (methodDeclaration2.isConstructor()) {
                        rewrite.set((ASTNode)methodDeclaration2, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
                        rewrite.set((ASTNode)methodDeclaration2, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)newReturnType, null);
                    } else {
                        rewrite.replace((ASTNode)methodDeclaration2.getReturnType2(), (ASTNode)newReturnType, null);
                    }
                    String key = "return_type";
                    proposal.addLinkedPosition(rewrite.track((ASTNode)newReturnType), true, key);
                    ITypeBinding[] bindings = ASTResolving.getRelaxingTypes((AST)ast, (ITypeBinding)binding);
                    int i = 0;
                    while (i < bindings.length) {
                        proposal.addLinkedPositionProposal(key, bindings[i]);
                        ++i;
                    }
                    Javadoc javadoc = methodDeclaration2.getJavadoc();
                    if (javadoc != null) {
                        TagElement newTag = ast.newTagElement();
                        newTag.setTagName("@return");
                        TextElement commentStart = ast.newTextElement();
                        newTag.fragments().add(commentStart);
                        JavadocTagsSubProcessor.insertTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), newTag, null);
                        proposal.addLinkedPosition(rewrite.track((ASTNode)commentStart), false, "comment_start");
                    }
                    proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
                }
                ASTRewrite rewrite = ASTRewrite.create((AST)decl.getAST());
                rewrite.remove((ASTNode)returnStatement.getExpression(), null);
                String label = CorrectionMessages.ReturnTypeSubProcessor_removereturn_description;
                ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 5);
                proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addMissingReturnTypeProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) {
        void parentTypeDecl;
        ASTNode parentType;
        void methodDeclaration;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)selectedNode);
        BodyDeclaration bodyDeclaration = decl;
        if (!(bodyDeclaration instanceof MethodDeclaration)) return;
        MethodDeclaration methodDeclaration2 = (MethodDeclaration)bodyDeclaration;
        MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration;
        ReturnStatementCollector eval = new ReturnStatementCollector();
        decl.accept((ASTVisitor)eval);
        AST ast = astRoot.getAST();
        ITypeBinding typeBinding = eval.getTypeBinding(decl.getAST());
        typeBinding = Bindings.normalizeTypeBinding((ITypeBinding)typeBinding);
        if (typeBinding == null) {
            typeBinding = ast.resolveWellKnownType("void");
        }
        if (typeBinding.isWildcardType()) {
            typeBinding = ASTResolving.normalizeWildcardType((ITypeBinding)typeBinding, (boolean)true, (AST)ast);
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_missingreturntype_description, BindingLabelProviderCore.getBindingLabel((IBinding)typeBinding, (long)0x200009L));
        LinkedCorrectionProposalCore proposal = new LinkedCorrectionProposalCore(label, cu, rewrite, 6);
        ImportRewrite imports = proposal.createImportRewrite(astRoot);
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)decl, imports);
        Type type = imports.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
        rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)type, null);
        rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        Javadoc javadoc = methodDeclaration.getJavadoc();
        if (javadoc != null && typeBinding != null) {
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@return");
            TextElement commentStart = ast.newTextElement();
            newTag.fragments().add(commentStart);
            JavadocTagsSubProcessor.insertTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), newTag, null);
            proposal.addLinkedPosition(rewrite.track((ASTNode)commentStart), false, "comment_start");
        }
        String key = "return_type";
        proposal.addLinkedPosition(rewrite.track((ASTNode)type), true, key);
        if (typeBinding != null) {
            ITypeBinding[] bindings = ASTResolving.getRelaxingTypes((AST)ast, (ITypeBinding)typeBinding);
            int i = 0;
            while (i < bindings.length) {
                proposal.addLinkedPositionProposal(key, bindings[i]);
                ++i;
            }
        }
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        ASTNode aSTNode = parentType = ASTResolving.findParentType((ASTNode)decl);
        if (!(aSTNode instanceof AbstractTypeDeclaration)) return;
        AbstractTypeDeclaration i = (AbstractTypeDeclaration)aSTNode;
        AbstractTypeDeclaration cfr_ignored_1 = (AbstractTypeDeclaration)aSTNode;
        ASTNode aSTNode2 = parentType;
        if (aSTNode2 instanceof TypeDeclaration) {
            void concreteParentTypeDecl;
            TypeDeclaration typeDeclaration = (TypeDeclaration)aSTNode2;
            TypeDeclaration cfr_ignored_2 = (TypeDeclaration)aSTNode2;
            if (concreteParentTypeDecl.isInterface()) {
                return;
            }
        }
        boolean bl = false;
        boolean isInterface = bl;
        if (isInterface) return;
        String constructorName = parentTypeDecl.getName().getIdentifier();
        SimpleName nameNode = methodDeclaration.getName();
        label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_wrongconstructorname_description, BasicElementLabels.getJavaElementName((String)constructorName));
        ReplaceCorrectionProposalCore p2 = new ReplaceCorrectionProposalCore(label, cu, nameNode.getStartPosition(), nameNode.getLength(), constructorName, 5);
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)p2, "quickfix"));
    }

    /*
     * WARNING - void declaration
     */
    public static void addMissingReturnStatementProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) {
        ReturnStatement returnStatement;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        ASTNode aSTNode = selectedNode;
        if (aSTNode instanceof ReturnStatement) {
            void returnStatement2;
            ReturnStatement returnStatement3 = (ReturnStatement)aSTNode;
            ReturnStatement cfr_ignored_0 = (ReturnStatement)aSTNode;
            returnStatement = returnStatement2;
        } else {
            returnStatement = null;
        }
        ReturnStatement existingStatement = returnStatement;
        ASTNode aSTNode2 = selectedNode;
        if (aSTNode2 instanceof LambdaExpression) {
            void lambda;
            LambdaExpression lambdaExpression = (LambdaExpression)aSTNode2;
            LambdaExpression cfr_ignored_1 = (LambdaExpression)aSTNode2;
            MissingReturnTypeInLambdaCorrectionProposalCore proposal = new MissingReturnTypeInLambdaCorrectionProposalCore(cu, (LambdaExpression)lambda, existingStatement, 6);
            proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        } else {
            BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)selectedNode);
            BodyDeclaration bodyDeclaration = decl;
            if (bodyDeclaration instanceof MethodDeclaration) {
                void methodDecl;
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                MethodDeclaration cfr_ignored_2 = (MethodDeclaration)bodyDeclaration;
                Block block = methodDecl.getBody();
                if (block == null) {
                    return;
                }
                MissingReturnTypeCorrectionProposalCore p1 = new MissingReturnTypeCorrectionProposalCore(cu, (MethodDeclaration)methodDecl, existingStatement, 6);
                proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)p1, "quickfix"));
                Type returnType = methodDecl.getReturnType2();
                if (returnType != null && !"void".equals(ASTNodes.asString((ASTNode)returnType))) {
                    TagElement tagElement;
                    AST ast = methodDecl.getAST();
                    ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                    rewrite.replace((ASTNode)returnType, (ASTNode)ast.newPrimitiveType(PrimitiveType.VOID), null);
                    Javadoc javadoc = methodDecl.getJavadoc();
                    if (javadoc != null && (tagElement = JavadocTagsSubProcessor.findTag(javadoc, "@return", null)) != null) {
                        rewrite.remove((ASTNode)tagElement, null);
                    }
                    String label = CorrectionMessages.ReturnTypeSubProcessor_changetovoid_description;
                    ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 5);
                    proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addMethodReturnsVoidProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<ProposalKindWrapper> proposals) throws JavaModelException {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof ReturnStatement)) {
            return;
        }
        ReturnStatement returnStatement = (ReturnStatement)selectedNode;
        Expression expression = returnStatement.getExpression();
        if (expression == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)selectedNode);
        BodyDeclaration bodyDeclaration = decl;
        if (bodyDeclaration instanceof MethodDeclaration) {
            void methDecl;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration;
            Type retType = methDecl.getReturnType2();
            if (retType == null || retType.resolveBinding() == null) {
                return;
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, expression, retType.resolveBinding(), false, 4, proposals);
        }
    }

    private static class ReturnStatementCollector
    extends ASTVisitor {
        private ArrayList<ReturnStatement> fResult = new ArrayList();

        private ReturnStatementCollector() {
        }

        public ITypeBinding getTypeBinding(AST ast) {
            boolean couldBeObject = false;
            int i = 0;
            while (i < this.fResult.size()) {
                ReturnStatement node = this.fResult.get(i);
                Expression expr = node.getExpression();
                if (expr != null) {
                    ITypeBinding binding = Bindings.normalizeTypeBinding((ITypeBinding)expr.resolveTypeBinding());
                    if (binding != null) {
                        return binding;
                    }
                } else {
                    return ast.resolveWellKnownType("void");
                }
                couldBeObject = true;
                ++i;
            }
            if (couldBeObject) {
                return ast.resolveWellKnownType("java.lang.Object");
            }
            return ast.resolveWellKnownType("void");
        }

        public boolean visit(ReturnStatement node) {
            this.fResult.add(node);
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            return false;
        }

        public boolean visit(EnumDeclaration node) {
            return false;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return false;
        }
    }
}

