/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;

public class UndoDeleteResourceChange
extends Change {
    private final IResourceSnapshot<? extends IResource> fResourceDescription;

    public UndoDeleteResourceChange(IResourceSnapshot<? extends IResource> resourceDescription) {
        this.fResourceDescription = resourceDescription;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_change_name, BasicElementLabels.getResourceName(this.fResourceDescription.getName()));
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.fResourceDescription.isValid()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_cannot_restore, BasicElementLabels.getResourceName(this.fResourceDescription.getName())));
        }
        if (this.fResourceDescription.verifyExistence(true)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_already_exists, BasicElementLabels.getResourceName(this.fResourceDescription.getName())));
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IResource created = this.fResourceDescription.createResource(pm);
        created.refreshLocal(2, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
        return new DeleteResourceChange(created.getFullPath(), true);
    }

    public String toString() {
        return "Remove " + this.fResourceDescription.getName();
    }
}

