/// <reference types="node" />
/**
 * This method actually launches 'gdb --version' to determine the version of
 * the GDB that is being used.
 *
 * @param gdbPath the path to the GDB executable to be called
 * @return the detected version of GDB at gdbPath
 */
export declare function getGdbVersion(gdbPath: string, gdbCwd?: string, environment?: Record<string, string | null>): Promise<string>;
/**
 * Find gdb version info from a string object which is supposed to
 * contain output text of "gdb --version" command.
 *
 * @param stdout
 * 		output text from "gdb --version" command .
 * @return
 * 		String representation of version of gdb such as "10.1" on success
 */
export declare function parseGdbVersionOutput(stdout: string): string | undefined;
/**
 * Compares two version numbers.
 * Returns -1, 0, or 1 if v1 is less than, equal to, or greater than v2, respectively.
 * @param v1 The first version
 * @param v2 The second version
 * @return -1, 0, or 1 if v1 is less than, equal to, or greater than v2, respectively.
 */
export declare function compareVersions(v1: string, v2: string): number;
/**
 * This method is providing an automatic operation to including new variables to process.env.
 * Method is not injecting the new variables to current thread, rather it is returning a new
 * object with included parameters.
 *
 * @param source
 * 		Source environment variables to include.
 * @param valuesToMerge
 * 		Key-Value dictionary to include.
 * @return
 * 		New environment variables dictionary.
 */
export declare function createEnvValues(source: NodeJS.ProcessEnv, valuesToMerge: Record<string, string | null>): NodeJS.ProcessEnv;
/**
 * Calculate the CWD that should be used to launch gdb based on the program
 * being debugged or the explicitly set cwd in the launch arguments.
 *
 * Note that launchArgs.program is optional here in preparation for
 * debugging where no program is specified. See #262
 *
 * @param launchArgs Launch Arguments to compute GDB cwd from
 * @returns effective cwd to use
 */
export declare function getGdbCwd(launchArgs: {
    program?: string;
    cwd?: string;
}): string;
