"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/*********************************************************************
 * Copyright (c) 2023 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
const path = require("path");
const os = require("os");
const chai_1 = require("chai");
const utils_1 = require("./utils");
// This mock adapter is overriding the getBreakpointOptions method.
const adapter = 'integration-tests/mocks/debugAdapters/dynamicBreakpointOptions.js';
const argHardwareBreakpointTrue = '--hardware-breakpoint-true';
const argHardwareBreakpointFalse = '--hardware-breakpoint-false';
const argThrowError = '--throw-error';
describe('dynamic breakpoint options with hardware set to false', () => __awaiter(void 0, void 0, void 0, function* () {
    let dc;
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            // Overriding breakpoint option hardware to false
            dc = yield (0, utils_1.standardBeforeEach)(adapter, [argHardwareBreakpointFalse]);
            yield dc.launchRequest((0, utils_1.fillDefaults)(this.currentTest, {
                program: path.join(utils_1.testProgramsDir, 'count'),
                hardwareBreakpoint: true,
            }));
        });
    });
    afterEach(() => __awaiter(void 0, void 0, void 0, function* () {
        yield dc.stop();
    }));
    it('insert breakpoint as software breakpoint', () => __awaiter(void 0, void 0, void 0, function* () {
        const bpResp = yield dc.setBreakpointsRequest({
            source: {
                name: 'count.c',
                path: path.join(utils_1.testProgramsDir, 'count.c'),
            },
            breakpoints: [
                {
                    column: 1,
                    line: 4,
                },
            ],
        });
        (0, chai_1.expect)(bpResp.body.breakpoints.length).eq(1);
        (0, chai_1.expect)(bpResp.body.breakpoints[0].verified).eq(true);
        (0, chai_1.expect)(bpResp.body.breakpoints[0].message).eq(undefined);
        yield dc.configurationDoneRequest();
        let isCorrect;
        let outputs;
        while (!isCorrect) {
            // Cover the case of getting event in Linux environment.
            // If cannot get correct event, program timeout and test case failed.
            outputs = yield dc.waitForEvent('output');
            isCorrect = outputs.body.output.includes('breakpoint-modified');
        }
        (0, chai_1.expect)(outputs === null || outputs === void 0 ? void 0 : outputs.body.output).includes('type="breakpoint"');
    }));
}));
describe('dynamic breakpoint options with hardware set to true', () => __awaiter(void 0, void 0, void 0, function* () {
    let dc;
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            // Overriding breakpoint option hardware to true
            dc = yield (0, utils_1.standardBeforeEach)(adapter, [argHardwareBreakpointTrue]);
            yield dc.launchRequest((0, utils_1.fillDefaults)(this.currentTest, {
                program: path.join(utils_1.testProgramsDir, 'count'),
                hardwareBreakpoint: false,
            }));
        });
    });
    afterEach(() => __awaiter(void 0, void 0, void 0, function* () {
        yield dc.stop();
    }));
    it('insert breakpoint as hardware breakpoint', function () {
        return __awaiter(this, void 0, void 0, function* () {
            // Hardware breakpoints are not supported for Windows
            if (os.platform() === 'win32') {
                this.skip();
            }
            const bpResp = yield dc.setBreakpointsRequest({
                source: {
                    name: 'count.c',
                    path: path.join(utils_1.testProgramsDir, 'count.c'),
                },
                breakpoints: [
                    {
                        column: 1,
                        line: 4,
                    },
                ],
            });
            (0, chai_1.expect)(bpResp.body.breakpoints.length).eq(1);
            (0, chai_1.expect)(bpResp.body.breakpoints[0].verified).eq(true);
            (0, chai_1.expect)(bpResp.body.breakpoints[0].message).eq(undefined);
            yield dc.configurationDoneRequest();
            let isCorrect;
            let outputs;
            while (!isCorrect) {
                // Cover the case of getting event in Linux environment.
                // If cannot get correct event, program timeout and test case failed.
                outputs = yield dc.waitForEvent('output');
                isCorrect = outputs.body.output.includes('breakpoint-modified');
            }
            (0, chai_1.expect)(outputs === null || outputs === void 0 ? void 0 : outputs.body.output).includes('type="hw breakpoint"');
        });
    });
}));
describe('dynamic breakpoint options with throwing error', () => __awaiter(void 0, void 0, void 0, function* () {
    let dc;
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            // Overriding breakpoint options and throwing error when getBreakpointOptions invoked
            dc = yield (0, utils_1.standardBeforeEach)(adapter, [argThrowError]);
            yield dc.launchRequest((0, utils_1.fillDefaults)(this.currentTest, {
                program: path.join(utils_1.testProgramsDir, 'count'),
                hardwareBreakpoint: false,
            }));
        });
    });
    afterEach(() => __awaiter(void 0, void 0, void 0, function* () {
        yield dc.stop();
    }));
    it('insert breakpoint is not performed', () => __awaiter(void 0, void 0, void 0, function* () {
        const bpResp = yield dc.setBreakpointsRequest({
            source: {
                name: 'count.c',
                path: path.join(utils_1.testProgramsDir, 'count.c'),
            },
            breakpoints: [
                {
                    column: 1,
                    line: 4,
                },
            ],
        });
        (0, chai_1.expect)(bpResp.body.breakpoints.length).eq(1);
        (0, chai_1.expect)(bpResp.body.breakpoints[0].verified).eq(false);
        (0, chai_1.expect)(bpResp.body.breakpoints[0].message).not.eq(undefined);
    }));
}));
//# sourceMappingURL=dynamicBreakpointOptions.spec.js.map