"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterTree = void 0;
const React = __importStar(require("react"));
const message_1 = require("./message");
const filter_1 = require("./filter");
const table_1 = require("./table");
const utils_1 = require("./utils");
const sort_1 = require("./sort");
const lodash_1 = require("lodash");
class FilterTree extends React.Component {
    constructor(props) {
        super(props);
        this._filter = '';
        this.getRootNodes = () => {
            const nodes = [...this.props.nodes];
            return nodes.filter((node) => node.isRoot === true);
        };
        this.getNode = (treeNodes, id) => {
            const nodes = [...treeNodes];
            if (!nodes) {
                return undefined;
            }
            let currentNode;
            while (nodes.length) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                currentNode = nodes.pop();
                if (currentNode.id === id) {
                    return currentNode;
                }
                else {
                    if (currentNode.children && currentNode.children.length) {
                        currentNode.children.forEach((child) => {
                            nodes.push(child);
                        });
                    }
                }
            }
            return undefined;
        };
        this.handleCollapse = (id) => {
            const nodes = (0, sort_1.sortNodes)(this.state.filteredNodes, this.state.sortConfig);
            this.props.onToggleCollapse(id, nodes);
        };
        this.handleClose = (id) => {
            this.props.onClose(id);
        };
        this.handleOrderChange = (nodes) => {
            const ids = (0, utils_1.getAllExpandedNodeIds)(nodes, this.props.collapsedNodes);
            this.props.onOrderChange(ids);
        };
        this.handleSortConfigChange = (sortConfig) => {
            this.setState({ sortConfig: sortConfig });
        };
        this.getAllChildrenIds = (node, ids) => {
            ids.push(node.id);
            if (node.children.length) {
                node.children.forEach((child) => {
                    this.getAllChildrenIds(child, ids);
                });
            }
            return ids;
        };
        this.getParentIdsToCheck = (parentId, ids, toCheck) => {
            ids.push(parentId);
            const parentNode = this.getNode(this.props.nodes, parentId);
            if (parentNode) {
                if (toCheck && this.areAllSiblingsChecked(parentNode)) {
                    this.getParentIdsToCheck(parentNode.parentId, ids, toCheck);
                }
                else if (!toCheck && this.isNodeChecked(parentNode.parentId)) {
                    this.getParentIdsToCheck(parentNode.parentId, ids, toCheck);
                }
            }
            return ids;
        };
        this.isNodeChecked = (id) => this.props.checkedSeries.includes(id);
        this.areAllSiblingsChecked = (node) => {
            const parentNode = this.getNode(this.props.nodes, node.parentId);
            if (parentNode) {
                return parentNode.children.every((child) => this.isNodeChecked(child.id) || node.id === child.id);
            }
            return false;
        };
        this.handleCheck = (id) => {
            let checkedIds = [];
            const checkedNode = this.getNode(this.props.nodes, id);
            if (checkedNode) {
                const childrenIds = this.getAllChildrenIds(checkedNode, []);
                const visibleChildrenIds = childrenIds.filter((childId) => this.getNode(this.state.filteredNodes, childId) !== undefined);
                if (!this.isNodeChecked(id)) {
                    if (checkedNode.children.length) {
                        const childIdsToCheck = visibleChildrenIds.filter(childId => !this.isNodeChecked(childId));
                        checkedIds = checkedIds.concat(childIdsToCheck);
                    }
                    else {
                        checkedIds = checkedIds.concat(id);
                    }
                    if (this.areAllSiblingsChecked(checkedNode) && !this.isNodeChecked(checkedNode.parentId)) {
                        const parentsToCheck = this.getParentIdsToCheck(checkedNode.parentId, [], true);
                        checkedIds = checkedIds.concat(parentsToCheck);
                    }
                }
                else {
                    if (checkedNode.children.length) {
                        checkedIds = checkedIds.concat(visibleChildrenIds);
                    }
                    else {
                        checkedIds = checkedIds.concat(id);
                    }
                    if (this.isNodeChecked(checkedNode.parentId)) {
                        const parentsToCheck = this.getParentIdsToCheck(checkedNode.parentId, [], false);
                        checkedIds = checkedIds.concat(parentsToCheck);
                    }
                }
                this.props.onToggleCheck(checkedIds);
            }
        };
        // returns 0 for unchecked, 1 for checked, 2 for half checked
        this.getCheckedStatus = (id) => {
            const node = this.getNode(this.props.nodes, id);
            if (node) {
                if (node.children.length === 0) {
                    return this.isNodeChecked(id) ? 1 : 0;
                }
                else {
                    if (this.isEveryChildChecked(node)) {
                        return 1;
                    }
                    if (this.isSomeChildChecked(node)) {
                        return 2;
                    }
                }
            }
            return 0;
        };
        this.isEveryChildChecked = (node) => {
            const visibleNodes = node.children.filter((child) => this.getNode(this.state.filteredNodes, child.id) !== undefined);
            let allChildrenChecked = false;
            if (visibleNodes.length) {
                allChildrenChecked = visibleNodes.every((child) => {
                    let isChecked = this.isNodeChecked(child.id);
                    if (child.children.length) {
                        isChecked = isChecked && this.isEveryChildChecked(child);
                    }
                    return isChecked;
                });
            }
            const leaves = this.getAllLeavesId(this.state.filteredNodes, []);
            const allLeavesChecked = leaves.every((id) => this.isNodeChecked(id));
            return allChildrenChecked || allLeavesChecked;
        };
        this.getAllLeavesId = (nodes, ids) => {
            nodes.forEach((node) => {
                if (node.children.length) {
                    this.getAllLeavesId(node.children, ids);
                }
                else {
                    ids.push(node.id);
                }
            });
            return ids;
        };
        this.isSomeChildChecked = (node) => node.children.some((child) => {
            let isChecked = this.isNodeChecked(child.id);
            if (child.children.length) {
                isChecked = isChecked || this.isSomeChildChecked(child);
            }
            return isChecked;
        });
        this.isCollapsed = (id) => this.props.collapsedNodes.includes(id);
        this.handleFilterChanged = (filter) => {
            this._filter = filter;
            let filteredTree = [];
            const matchedIds = [];
            const rootNodes = this.getRootNodes();
            rootNodes.forEach((node) => this.getMatchingIds(node, filter, matchedIds));
            filteredTree = this.filterTree(this.props.nodes, matchedIds);
            this.setState({ filteredNodes: filteredTree });
            this.handleOrderChange(filteredTree);
        };
        this.getMatchingIds = (node, filter, foundIds) => {
            let isMatching = node.labels[0].indexOf(filter) > -1;
            if (node.children && node.children.length) {
                node.children.forEach((child) => {
                    const hasMatchingChild = this.getMatchingIds(child, filter, foundIds);
                    isMatching = isMatching || hasMatchingChild;
                });
            }
            if (isMatching) {
                foundIds.push(node.id);
            }
            return isMatching;
        };
        this.filterTree = (nodes, matchedIds) => nodes.filter((node) => matchedIds.indexOf(node.id) > -1)
            .map((node) => (Object.assign(Object.assign({}, node), { children: node.children ? this.filterTree(node.children, matchedIds) : [] })));
        this.renderFilterTree = () => React.createElement(React.Fragment, null,
            React.createElement(filter_1.Filter, { onChange: (e) => this.handleFilterChanged(e.target.value) }),
            this.renderTable(this.state.filteredNodes));
        this.renderTable = (nodes) => React.createElement(table_1.Table, { nodes: nodes, selectedRow: this.props.selectedRow, collapsedNodes: this.props.collapsedNodes, isCheckable: this.props.showCheckboxes, isClosable: this.props.showCloseIcons, sortConfig: this.state.sortConfig, getCheckedStatus: this.getCheckedStatus, onToggleCollapse: this.handleCollapse, onToggleCheck: this.handleCheck, onRowClick: this.props.onRowClick, onContextMenu: this.props.onContextMenu, onClose: this.handleClose, onSort: this.handleOrderChange, onSortConfigChange: this.handleSortConfigChange, showHeader: this.props.showHeader, headers: this.props.headers, className: this.props.className });
        this.state = {
            filteredNodes: this.props.nodes,
            sortConfig: []
        };
    }
    render() {
        if (!this.props.nodes) {
            return undefined;
        }
        const rootNodes = this.getRootNodes();
        if (rootNodes && rootNodes.length) {
            return React.createElement(React.Fragment, null, this.props.showFilter
                ? this.renderFilterTree()
                : this.renderTable(rootNodes));
        }
        else {
            return React.createElement(message_1.Message, null);
        }
    }
    componentDidUpdate(prevProps) {
        if (!(0, lodash_1.isEqual)(this.props.nodes, prevProps.nodes)) {
            this.handleFilterChanged(this._filter);
        }
    }
}
exports.FilterTree = FilterTree;
FilterTree.defaultProps = {
    checkedSeries: [],
    showFilter: true,
    onToggleCheck: () => { },
    onOrderChange: () => { },
};
//# sourceMappingURL=tree.js.map