"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableOutputComponent = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const abstract_output_component_1 = require("./abstract-output-component");
const React = __importStar(require("react"));
const react_dom_1 = require("react-dom");
const ag_grid_react_1 = require("ag-grid-react");
const query_helper_1 = require("tsp-typescript-client/lib/models/query/query-helper");
const lodash_1 = require("lodash");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const table_renderer_components_1 = require("./table-renderer-components");
const tsp_typescript_client_1 = require("tsp-typescript-client");
const pagination_bar_component_1 = require("./utils/pagination-bar-component");
var Direction;
(function (Direction) {
    Direction[Direction["NEXT"] = 0] = "NEXT";
    Direction[Direction["PREVIOUS"] = 1] = "PREVIOUS";
    Direction[Direction["FIRST"] = 2] = "FIRST";
    Direction[Direction["LAST"] = 3] = "LAST";
})(Direction || (Direction = {}));
class TableOutputComponent extends abstract_output_component_1.AbstractOutputComponent {
    constructor(props) {
        super(props);
        this.debugMode = false;
        this.columnIds = [];
        this.fetchColumns = true;
        this.columnArray = new Array();
        this.pagination = true;
        this.paginationPageSize = 250000;
        this.paginationTotalPages = 0;
        this.showIndexColumn = false;
        this.gridApi = undefined;
        this.gridMatched = false;
        this.gridRedrawn = false;
        this.gridSearched = false;
        this.columnApi = undefined;
        this.prevStartTimestamp = -BigInt(2 ** 63);
        this.startTimestamp = BigInt(2 ** 63);
        this.endTimestamp = -BigInt(2 ** 63);
        this.columnsPacked = false;
        this.timestampCol = undefined;
        this.eventSignal = false;
        this.enableIndexSelection = true;
        this.selectStartIndex = -1;
        this.selectEndIndex = -1;
        this.filterModel = new Map();
        this.tableSize = 0;
        this.onGridReady = async (event) => {
            this.gridApi = event.api;
            this.columnApi = event.columnApi;
            event.api.setDatasource(this.dataSource);
        };
        this.onModelUpdated = async () => {
            this.selectRows();
            if (this.columnArray.length > 0 && !this.columnsPacked && this.columnApi) {
                this.columnApi.autoSizeAllColumns();
                this.columnsPacked = true;
            }
        };
        this.state = {
            outputStatus: tsp_typescript_client_1.ResponseStatus.RUNNING,
            tableColumns: [],
            optionsDropdownOpen: false,
            showToggleColumns: false,
            additionalOptions: true
        };
        this.frameworkComponents = {
            searchFilterRenderer: table_renderer_components_1.SearchFilterRenderer,
            loadingRenderer: table_renderer_components_1.LoadingRenderer,
            cellRenderer: table_renderer_components_1.CellRenderer
        };
        this.dataSource = {
            getRows: async (params) => {
                if (this.fetchColumns) {
                    this.fetchColumns = false;
                    await this.init();
                }
                const rowsThisPage = await this.fetchTableLines(params.startRow, params.endRow - params.startRow);
                for (let i = 0; i < rowsThisPage.length; i++) {
                    const item = rowsThisPage[i];
                    const itemCopy = (0, lodash_1.cloneDeep)(item);
                    rowsThisPage[i] = itemCopy;
                }
                params.successCallback(rowsThisPage, this.tableSize);
            }
        };
        this.pagination = this.props.nbEvents >= this.paginationPageSize;
        this.paginationTotalPages = Math.floor(this.props.nbEvents / this.paginationPageSize);
        this.onEventClick = this.onEventClick.bind(this);
        this.onModelUpdated = this.onModelUpdated.bind(this);
        this.onKeyDown = this.onKeyDown.bind(this);
        this.searchEvents = this.searchEvents.bind(this);
        this.findMatchedEvent = this.findMatchedEvent.bind(this);
        this.checkFocus = this.checkFocus.bind(this);
    }
    renderMainArea() {
        return React.createElement("div", { id: this.props.traceId + this.props.outputDescriptor.id + 'focusContainer', tabIndex: -1, onFocus: event => this.checkFocus(event), className: this.props.backgroundTheme === 'light' ? 'ag-theme-balham' : 'ag-theme-balham-dark', style: {
                height: this.props.style.height,
                width: this.props.outputWidth,
                display: 'flex',
                flexDirection: 'column'
            } },
            React.createElement(ag_grid_react_1.AgGridReact, { columnDefs: this.columnArray, rowModelType: 'infinite', cacheBlockSize: this.props.cacheBlockSize, maxBlocksInCache: this.props.maxBlocksInCache, blockLoadDebounceMillis: this.props.blockLoadDebounce, pagination: true, paginationPageSize: this.paginationPageSize, suppressPaginationPanel: true, debug: this.debugMode, onGridReady: this.onGridReady, onCellClicked: this.onEventClick, rowSelection: 'multiple', onModelUpdated: this.onModelUpdated, onCellKeyDown: this.onKeyDown, components: this.frameworkComponents, enableBrowserTooltips: true }),
            this.pagination &&
                React.createElement(pagination_bar_component_1.PaginationBarComponent, { paginationPageSize: this.paginationPageSize, paginationTotalPages: this.paginationTotalPages, nbEvents: this.props.nbEvents, gridApi: this === null || this === void 0 ? void 0 : this.gridApi }));
    }
    resultsAreEmpty() {
        return this.state.tableColumns.length === 0;
    }
    componentDidMount() {
        this.props.unitController.onSelectionRangeChange(range => { this.handleTimeSelectionChange(range); });
    }
    checkFocus(event) {
        var _a;
        if (!((_a = event.currentTarget) === null || _a === void 0 ? void 0 : _a.contains(event.relatedTarget))) {
            this.setFocus();
        }
    }
    setFocus() {
        var _a, _b;
        if (document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'focusContainer')) {
            (_a = document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'focusContainer')) === null || _a === void 0 ? void 0 : _a.focus();
        }
        else {
            (_b = document.getElementById(this.props.traceId + this.props.outputDescriptor.id)) === null || _b === void 0 ? void 0 : _b.focus();
        }
    }
    componentWillUnmount() {
        // TODO: replace with removing the handler from unit controller
        // See timeline-chart issue #98
        // In the meantime, replace the handler with a noop on unmount
        this.handleTimeSelectionChange = () => Promise.resolve();
    }
    async componentDidUpdate(prevProps, _prevState) {
        var _a;
        if (this.props.nbEvents !== prevProps.nbEvents) {
            (_a = this.gridApi) === null || _a === void 0 ? void 0 : _a.setRowCount(this.props.nbEvents);
            const newPagination = this.props.nbEvents >= this.paginationPageSize;
            if (newPagination !== this.pagination) {
                this.pagination = newPagination;
            }
            this.paginationTotalPages = Math.floor(this.props.nbEvents / this.paginationPageSize);
        }
    }
    onEventClick(event) {
        var _a;
        const columns = event.columnApi.getColumns();
        const data = event.data;
        const mouseEvent = event.event;
        const gridApi = event.api;
        const rowIndex = (_a = event.rowIndex) !== null && _a !== void 0 ? _a : 0;
        const itemPropsObj = this.fetchItemProperties(columns, data);
        const currTimestamp = (this.timestampCol && data) ? data[this.timestampCol] : undefined;
        this.enableIndexSelection = true;
        if (mouseEvent.shiftKey) {
            if (this.selectStartIndex === -1) {
                this.selectStartIndex = rowIndex;
                if (currTimestamp) {
                    this.startTimestamp = BigInt(currTimestamp);
                }
            }
            this.selectEndIndex = rowIndex;
            if (currTimestamp) {
                this.endTimestamp = BigInt(currTimestamp);
            }
            this.selectRows();
        }
        else {
            if (mouseEvent.ctrlKey || mouseEvent.metaKey) {
                gridApi.deselectAll();
                const rowNode = gridApi.getRowNode(String(rowIndex));
                if (rowNode && rowNode.id) {
                    rowNode.setSelected(true);
                }
            }
            this.selectStartIndex = this.selectEndIndex = rowIndex;
            if (currTimestamp) {
                this.startTimestamp = this.endTimestamp = BigInt(currTimestamp);
            }
        }
        // Notfiy selection changed
        this.handleRowSelectionChange(itemPropsObj);
        // Notfiy properties changed
        (0, signal_manager_1.signalManager)().fireItemPropertiesSignalUpdated(itemPropsObj);
    }
    fetchItemProperties(columns, data) {
        const itemPropsObj = {};
        columns === null || columns === void 0 ? void 0 : columns.forEach(column => {
            const headerName = column.getColDef().headerName;
            const colField = column.getColDef().field;
            if (headerName && colField && data && data[colField]) {
                itemPropsObj[headerName] = data[colField];
            }
        });
        return itemPropsObj;
    }
    onKeyDown(event) {
        var _a;
        const gridApi = event.api;
        const keyEvent = event.event;
        const rowIndex = (_a = event.rowIndex) !== null && _a !== void 0 ? _a : 0;
        this.enableIndexSelection = true;
        const currTimestamp = (this.timestampCol && event.data) ? event.data[this.timestampCol] : undefined;
        if (gridApi) {
            let nextRow;
            const currentRow = gridApi.getRowNode(String(rowIndex));
            let isContiguous = true;
            if (keyEvent.shiftKey) {
                if (keyEvent.code === 'ArrowDown') {
                    if (currentRow && !currentRow.isSelected()) {
                        gridApi.deselectAll();
                        isContiguous = false;
                    }
                    nextRow = gridApi.getRowNode(String(rowIndex + 1));
                    if (isContiguous === false) {
                        if (this.timestampCol && (nextRow === null || nextRow === void 0 ? void 0 : nextRow.data)) {
                            this.startTimestamp = this.endTimestamp = BigInt(nextRow.data[this.timestampCol]);
                        }
                        if (nextRow === null || nextRow === void 0 ? void 0 : nextRow.rowIndex) {
                            this.selectStartIndex = this.selectEndIndex = nextRow.rowIndex;
                        }
                    }
                    else {
                        if (this.selectStartIndex && this.selectEndIndex && this.selectEndIndex < this.selectStartIndex) {
                            if (currentRow && currentRow.id) {
                                currentRow.setSelected(false);
                            }
                        }
                        else {
                            if (nextRow === null || nextRow === void 0 ? void 0 : nextRow.id) {
                                nextRow.setSelected(true);
                            }
                        }
                        this.selectEndIndex += 1;
                        if (this.timestampCol && (nextRow === null || nextRow === void 0 ? void 0 : nextRow.data)) {
                            this.endTimestamp = BigInt(nextRow.data[this.timestampCol]);
                        }
                    }
                }
                else if (keyEvent.code === 'ArrowUp') {
                    if (!(currentRow === null || currentRow === void 0 ? void 0 : currentRow.isSelected())) {
                        gridApi.deselectAll();
                        isContiguous = false;
                    }
                    nextRow = gridApi.getRowNode(String(rowIndex - 1));
                    if (isContiguous === false) {
                        if (this.timestampCol && (nextRow === null || nextRow === void 0 ? void 0 : nextRow.data)) {
                            this.startTimestamp = this.endTimestamp = BigInt(nextRow.data[this.timestampCol]);
                        }
                        if (nextRow === null || nextRow === void 0 ? void 0 : nextRow.rowIndex) {
                            this.selectStartIndex = this.selectEndIndex = nextRow.rowIndex;
                        }
                    }
                    else {
                        if (this.selectStartIndex < this.selectEndIndex) {
                            if (currentRow && currentRow.id) {
                                currentRow.setSelected(false);
                            }
                        }
                        else {
                            if (nextRow === null || nextRow === void 0 ? void 0 : nextRow.id) {
                                nextRow.setSelected(true);
                            }
                        }
                        this.selectEndIndex -= 1;
                        if (this.timestampCol && (nextRow === null || nextRow === void 0 ? void 0 : nextRow.data)) {
                            this.endTimestamp = BigInt(nextRow.data[this.timestampCol]);
                        }
                    }
                }
                else if (keyEvent.code === 'Space') {
                    this.selectEndIndex = rowIndex;
                    if (currTimestamp) {
                        this.endTimestamp = BigInt(currTimestamp);
                    }
                    this.selectRows();
                }
            }
            else if (keyEvent.code === 'Space') {
                gridApi.deselectAll();
                if (currentRow && currentRow.id) {
                    currentRow.setSelected(true);
                }
                this.selectStartIndex = this.selectEndIndex = rowIndex;
                this.startTimestamp = this.endTimestamp = BigInt(currTimestamp);
            }
            else {
                gridApi.deselectAll();
                if (keyEvent.code === 'ArrowDown') {
                    nextRow = gridApi.getRowNode(String(rowIndex + 1));
                    if (this.timestampCol && (nextRow === null || nextRow === void 0 ? void 0 : nextRow.data)) {
                        this.startTimestamp = this.endTimestamp = BigInt(nextRow.data[this.timestampCol]);
                    }
                    if (nextRow === null || nextRow === void 0 ? void 0 : nextRow.rowIndex) {
                        this.selectStartIndex = this.selectEndIndex = nextRow.rowIndex;
                    }
                }
                else if (keyEvent.code === 'ArrowUp') {
                    nextRow = gridApi.getRowNode(String(rowIndex - 1));
                    if (this.timestampCol && (nextRow === null || nextRow === void 0 ? void 0 : nextRow.data)) {
                        this.startTimestamp = this.endTimestamp = BigInt(nextRow.data[this.timestampCol]);
                    }
                    if (nextRow === null || nextRow === void 0 ? void 0 : nextRow.rowIndex) {
                        this.selectStartIndex = this.selectEndIndex = nextRow.rowIndex;
                    }
                }
                if (nextRow === null || nextRow === void 0 ? void 0 : nextRow.id) {
                    nextRow.setSelected(true);
                }
            }
            let itemPropsObj;
            const columns = event.columnApi.getColumns();
            itemPropsObj = undefined;
            if (nextRow && nextRow.data) {
                itemPropsObj = this.fetchItemProperties(columns, nextRow.data);
            }
            // Notfiy selection changed
            this.handleRowSelectionChange(itemPropsObj);
            // Notify properties changed
            (0, signal_manager_1.signalManager)().fireItemPropertiesSignalUpdated(itemPropsObj);
        }
    }
    async init() {
        const traceUUID = this.props.traceId;
        const tspClient = this.props.tspClient;
        const outputId = this.props.outputDescriptor.id;
        // Fetch columns
        const tspClientResponse = await tspClient.fetchTableColumns(traceUUID, outputId, query_helper_1.QueryHelper.query());
        const columnsResponse = tspClientResponse.getModel();
        if (!tspClientResponse.isOk() || !columnsResponse) {
            this.setState({
                outputStatus: tsp_typescript_client_1.ResponseStatus.FAILED
            });
            return;
        }
        const colIds = [];
        const columnsArray = new Array();
        if (this.showIndexColumn) {
            columnsArray.push({
                headerName: 'Index',
                field: '0',
                width: this.props.columnWidth,
                cellRenderer: 'loadingRenderer'
            });
            colIds.push(0);
        }
        const columnEntries = columnsResponse.model;
        columnEntries.forEach(columnHeader => {
            const id = this.showIndexColumn ? ++columnHeader.id : columnHeader.id;
            colIds.push(id);
            columnsArray.push({
                headerName: columnHeader.name,
                field: columnHeader.id.toString(),
                width: this.props.columnWidth,
                resizable: true,
                cellRenderer: 'cellRenderer',
                cellRendererParams: {
                    filterModel: this.filterModel,
                    searchResultsColor: this.props.backgroundTheme === 'light' ? '#cccc00' : '#008000'
                },
                suppressMenu: true,
                filter: 'agTextColumnFilter',
                floatingFilter: true,
                floatingFilterComponent: 'searchFilterRenderer',
                floatingFilterComponentParams: {
                    suppressFilterButton: true,
                    onFilterChange: this.searchEvents,
                    onclickNext: () => this.findMatchedEvent(Direction.NEXT),
                    onclickPrevious: () => this.findMatchedEvent(Direction.PREVIOUS),
                    colName: columnHeader.id.toString(),
                    filterModel: this.filterModel
                },
                icons: {
                    filter: ''
                },
                tooltipField: columnHeader.id.toString()
            });
        });
        if (!this.showIndexColumn) {
            columnsArray[0].cellRenderer = 'cellRenderer';
        }
        this.columnIds = colIds;
        this.columnArray = columnsArray;
        // flushSync: force immediate state update instead of waiting for React 18's automatic batching
        (0, react_dom_1.flushSync)(() => {
            this.setState({
                outputStatus: columnsResponse.status,
                tableColumns: this.columnArray
            });
        });
        if (this.columnApi) {
            const columns = this.columnApi.getColumns();
            const timestampHeader = columns === null || columns === void 0 ? void 0 : columns.find(column => column.getColDef().headerName === 'Timestamp ns');
            if (timestampHeader) {
                this.timestampCol = timestampHeader.getColDef().field;
            }
        }
        if (this.props.unitController.selectionRange) {
            this.handleTimeSelectionChange(this.props.unitController.selectionRange);
        }
    }
    handleRowSelectionChange(load) {
        if (this.timestampCol) {
            const startTimestamp = String(this.startTimestamp);
            const endTimestamp = String(this.endTimestamp);
            const payload = { startTimestamp, endTimestamp, load };
            this.prevStartTimestamp = BigInt(startTimestamp);
            this.eventSignal = true;
            this.handleSelectionRangeUpdate(payload);
            (0, signal_manager_1.signalManager)().fireSelectionChangedSignal(payload);
        }
    }
    handleSelectionRangeUpdate(payload) {
        const offset = this.props.viewRange.getOffset() || BigInt(0);
        const startTimestamp = payload['startTimestamp'];
        const endTimestamp = payload['endTimestamp'];
        if (startTimestamp !== undefined && endTimestamp !== undefined) {
            const selectionRangeStart = BigInt(startTimestamp) - offset;
            const selectionRangeEnd = BigInt(endTimestamp) - offset;
            this.props.unitController.selectionRange = {
                start: selectionRangeStart,
                end: selectionRangeEnd
            };
        }
    }
    async handleTimeSelectionChange(range) {
        if (range) {
            if (this.eventSignal) {
                this.eventSignal = false;
                return;
            }
            this.startTimestamp = this.props.range.getStart() + range.start;
            this.endTimestamp = this.props.range.getStart() + range.end;
            if (this.startTimestamp === this.endTimestamp || !this.timestampCol) {
                this.enableIndexSelection = true;
            }
            else {
                this.enableIndexSelection = false;
            }
            if (this.gridApi && this.startTimestamp !== this.prevStartTimestamp) {
                this.prevStartTimestamp = this.startTimestamp;
                this.selectStartIndex = this.selectEndIndex = -1;
                this.gridApi.deselectAll();
                const index = await this.fetchTableIndex(this.startTimestamp > this.endTimestamp ? this.startTimestamp + BigInt(1) : this.startTimestamp);
                if (index) {
                    const startIndex = this.startTimestamp > this.endTimestamp ? index - 1 : index;
                    this.selectStartIndex = this.selectStartIndex === -1 ? startIndex : this.selectStartIndex;
                    this.selectEndIndex = (this.enableIndexSelection && this.selectEndIndex === -1) ? startIndex : this.selectEndIndex;
                    this.updatePageIndex(index);
                    this.selectRows();
                }
            }
            else {
                this.selectRows();
            }
        }
    }
    async fetchTableIndex(timestamp) {
        const traceUUID = this.props.traceId;
        const tspClient = this.props.tspClient;
        const outputId = this.props.outputDescriptor.id;
        const tspClientResponse = await tspClient.fetchTableLines(traceUUID, outputId, query_helper_1.QueryHelper.timeQuery([timestamp], { [query_helper_1.QueryHelper.REQUESTED_TABLE_COUNT_KEY]: 1 }));
        const lineResponse = tspClientResponse.getModel();
        if (!tspClientResponse.isOk() || !lineResponse) {
            return undefined;
        }
        const model = lineResponse.model;
        const lines = model.lines;
        if (lines.length === 0) {
            return undefined;
        }
        return lines[0].index;
    }
    fetchAdditionalParams(direction) {
        let additionalParams = {};
        const filterObj = {};
        if (this.filterModel) {
            this.filterModel.forEach((value, key) => {
                const k = Number.parseInt(key);
                filterObj[k] = value;
            });
            additionalParams = {
                ['table_search_expressions']: filterObj,
            };
            if (direction !== undefined) {
                additionalParams['table_search_direction'] = Direction[direction];
            }
        }
        return additionalParams;
    }
    async fetchTableLines(fetchIndex, linesToFetch) {
        const traceUUID = this.props.traceId;
        const tspClient = this.props.tspClient;
        const outputId = this.props.outputDescriptor.id;
        const additionalParams = this.fetchAdditionalParams();
        const tspClientResponse = await tspClient.fetchTableLines(traceUUID, outputId, query_helper_1.QueryHelper.tableQuery(this.columnIds, fetchIndex, linesToFetch, additionalParams));
        const lineResponse = tspClientResponse.getModel();
        if (!tspClientResponse.isOk() || !lineResponse) {
            return new Array();
        }
        this.tableSize = lineResponse.model.size;
        return this.modelToRow(lineResponse.model);
    }
    modelToRow(model) {
        const linesArray = new Array();
        const lines = model.lines;
        lines.forEach(line => {
            const obj = {};
            const cells = line.cells;
            const columnIds = model.columnIds;
            if (this.showIndexColumn) {
                obj[0] = line.index.toString();
            }
            cells.forEach((cell, index) => {
                const id = this.showIndexColumn ? columnIds[index] + 1 : columnIds[index];
                obj[id] = cell.content;
            });
            obj['isMatched'] = (line.tags !== undefined && line.tags > 0);
            linesArray.push(obj);
        });
        return linesArray;
    }
    async searchEvents(colName, filterValue) {
        const msBetweenChecks = 100;
        while (this.gridMatched) {
            // wait for grid to be done being matched -elsewhere (concurrently)
            await new Promise(cb => setTimeout(cb, msBetweenChecks));
        }
        this.gridRedrawn = true;
        if (filterValue === '') {
            this.filterModel.delete(colName);
        }
        else {
            this.filterModel.set(colName, filterValue);
        }
        if (this.gridApi) {
            this.gridApi.forEachNode(rowNode => {
                if (!rowNode.data) {
                    // hitting Enter early in Search field(s) can lead here
                    return;
                }
                let isMatched = true;
                this.filterModel.forEach((value, key) => {
                    if ((rowNode.data[key].search(new RegExp(value)) === -1)) {
                        isMatched = false;
                    }
                });
                rowNode.data['isMatched'] = isMatched;
            });
            this.gridApi.redrawRows();
        }
        this.gridSearched = true;
        this.gridRedrawn = false;
    }
    async findMatchIndex(currRowIndex, direction = Direction.NEXT) {
        const traceUUID = this.props.traceId;
        const tspClient = this.props.tspClient;
        const outputId = this.props.outputDescriptor.id;
        const additionalParams = this.fetchAdditionalParams(direction);
        const tspClientResponse = await tspClient.fetchTableLines(traceUUID, outputId, query_helper_1.QueryHelper.tableQuery(this.columnIds, currRowIndex, 1, additionalParams));
        const lineResponse = tspClientResponse.getModel();
        if (!tspClientResponse.isOk() || !lineResponse) {
            return undefined;
        }
        const model = lineResponse.model;
        const lines = model.lines;
        if (lines.length === 0) {
            return undefined;
        }
        return { index: lines[0].index, row: this.modelToRow(model)[0] };
    }
    async findMatchedEvent(direction) {
        let isFound = false;
        if (this.gridApi) {
            const msBetweenChecks = 100;
            while (this.gridMatched) {
                // wait for grid to be done being matched -from elsewhere (concurrently)
                await new Promise(cb => setTimeout(cb, msBetweenChecks));
            }
            while (this.gridRedrawn) {
                // wait for grid to be done being redrawn -elsewhere (before assuming it)
                await new Promise(cb => setTimeout(cb, msBetweenChecks));
            }
            this.gridMatched = true;
            if (this.gridSearched) {
                // reset the selection once, upon new search filter just applied
                this.selectStartIndex = this.selectEndIndex = -1;
                this.gridSearched = false;
            }
            // make sure that both index are either both -1 or both have a valid number
            if (this.selectStartIndex !== -1 && this.selectEndIndex === -1) {
                this.selectEndIndex = this.selectStartIndex;
            }
            if (this.selectEndIndex !== -1 && this.selectStartIndex === -1) {
                this.selectStartIndex = this.selectEndIndex;
            }
            let currRowIndex = 0;
            if (this.selectStartIndex !== -1) {
                if (direction === Direction.NEXT) {
                    currRowIndex = Math.max(this.selectStartIndex, this.selectEndIndex) + 1;
                }
                else {
                    currRowIndex = Math.min(this.selectStartIndex, this.selectEndIndex) - 1;
                    if (currRowIndex < 0) {
                        // no backward search if already at index 0
                        this.gridMatched = false;
                        return;
                    }
                }
            }
            else if (direction === Direction.PREVIOUS) {
                // no backward search if there is no selection
                this.gridMatched = false;
                return;
            }
            let rowNodes = [];
            this.gridApi.forEachNode(rowNode => {
                rowNodes.push(rowNode);
            });
            if (direction === Direction.PREVIOUS) {
                rowNodes = rowNodes.reverse();
            }
            this.gridApi.deselectAll();
            // consider only rows starting from the current row index and contiguous rows after that
            let currRowIndexFound = false;
            rowNodes.forEach(rowNode => {
                var _a;
                if (rowNode.rowIndex === currRowIndex) {
                    currRowIndexFound = true;
                    // update current row index to next/previous contiguous row
                    if (direction === Direction.NEXT) {
                        currRowIndex++;
                    }
                    else {
                        currRowIndex--;
                    }
                }
                else {
                    // non-contiguous row found, stop searching in cache
                    currRowIndexFound = false;
                }
                // only checking 'rowNode.rowIndex' below makes its '=== 0' case false:
                if (currRowIndexFound && !isFound && (rowNode.rowIndex || rowNode.rowIndex === 0) && rowNode.data && rowNode.data['isMatched']) {
                    (_a = this.gridApi) === null || _a === void 0 ? void 0 : _a.ensureIndexVisible(rowNode.rowIndex);
                    this.updatePageIndex(rowNode.rowIndex);
                    this.selectStartIndex = this.selectEndIndex = rowNode.rowIndex;
                    if (this.timestampCol) {
                        this.startTimestamp = this.endTimestamp = BigInt(rowNode.data[this.timestampCol]);
                    }
                    let itemPropsObj;
                    if (this.columnApi) {
                        itemPropsObj = this.fetchItemProperties(this.columnApi.getColumns(), rowNode.data);
                    }
                    // Notify selection changed
                    this.handleRowSelectionChange(itemPropsObj);
                    // Notify properties changed
                    (0, signal_manager_1.signalManager)().fireItemPropertiesSignalUpdated(itemPropsObj);
                    isFound = true;
                    rowNode.setSelected(true);
                }
            });
            if (isFound) {
                // Match found in cache
                this.gridMatched = false;
                return;
            }
            // find match outside the cache
            let syncData = undefined;
            if (currRowIndex >= 0) {
                const data = await this.findMatchIndex(currRowIndex, direction);
                if (data !== undefined) {
                    this.updatePageIndex(data.index);
                    this.selectStartIndex = this.selectEndIndex = data.index;
                    if (this.timestampCol) {
                        this.startTimestamp = this.endTimestamp = BigInt(data.row[this.timestampCol]);
                        syncData = data.row;
                    }
                }
            }
            // apply new or previous selection
            if (this.selectStartIndex !== -1 && this.selectEndIndex !== -1) {
                let itemPropsObj;
                if (this.columnApi && syncData) {
                    itemPropsObj = this.fetchItemProperties(this.columnApi.getColumns(), syncData);
                }
                // Notfiy selection changed
                this.handleRowSelectionChange(itemPropsObj);
                // Notfiy properties changed
                (0, signal_manager_1.signalManager)().fireItemPropertiesSignalUpdated(itemPropsObj);
                this.selectRows();
            }
            this.gridMatched = false;
        }
    }
    isValidRowSelection(rowNode) {
        if ((this.enableIndexSelection && this.selectStartIndex !== -1 && this.selectEndIndex !== -1
            && rowNode.rowIndex && rowNode.rowIndex >= Math.min(this.selectStartIndex, this.selectEndIndex)
            && rowNode.rowIndex <= Math.max(this.selectStartIndex, this.selectEndIndex)) || (!this.enableIndexSelection
            && this.timestampCol && BigInt(rowNode.data[this.timestampCol]) >= (this.startTimestamp <= this.endTimestamp ? this.startTimestamp : this.endTimestamp)
            && BigInt(rowNode.data[this.timestampCol]) <= (this.startTimestamp <= this.endTimestamp ? this.endTimestamp : this.startTimestamp))) {
            return true;
        }
        return false;
    }
    selectRows() {
        if (this.gridApi) {
            this.gridApi.forEachNode(rowNode => {
                if (rowNode.id) {
                    rowNode.setSelected(this.isValidRowSelection(rowNode));
                }
            });
        }
    }
    toggleColumnVisibility(columnApi, column) {
        var _a;
        if (!columnApi || !column.field) {
            return;
        }
        columnApi.setColumnsVisible([column.field], !((_a = columnApi.getColumn(column)) === null || _a === void 0 ? void 0 : _a.isVisible()));
        const allCols = (0, lodash_1.cloneDeep)(this.state.tableColumns);
        allCols.map(item => {
            var _a;
            if (item.field === column.field) {
                item.hide = (_a = columnApi.getColumn(column)) === null || _a === void 0 ? void 0 : _a.isVisible();
            }
        });
        this.setState({
            tableColumns: allCols
        });
    }
    renderToggleColumnsTable() {
        /* eslint-disable @typescript-eslint/no-non-null-assertion */
        if (!this.columnApi) {
            return;
        }
        const columns = this.columnApi.getAllGridColumns();
        return React.createElement(React.Fragment, null,
            React.createElement("table", { style: { width: '100%' } },
                React.createElement("tbody", null, columns.map((column, key) => {
                    var _a;
                    return React.createElement("tr", { key: key },
                        React.createElement("td", null,
                            React.createElement("input", { type: 'checkbox', checked: (_a = this.columnApi.getColumn(column)) === null || _a === void 0 ? void 0 : _a.isVisible(), onChange: () => this.toggleColumnVisibility(this.columnApi, column.getColDef()) })),
                        React.createElement("td", null, column.getColDef().headerName));
                }))));
    }
    closeOptionsDropDown() {
        this.setState({
            showToggleColumns: false
        });
    }
    showAdditionalOptions() {
        return React.createElement(React.Fragment, null,
            React.createElement("ul", null,
                React.createElement("li", { className: 'drop-down-list-item', onClick: () => {
                        this.setState({ showToggleColumns: !this.state.showToggleColumns });
                    } },
                    React.createElement("div", { className: 'drop-down-list-item-text' }, "Toggle Columns"))),
            this.state.showToggleColumns && React.createElement("div", { className: 'toggle-columns-table' }, this.renderToggleColumnsTable()));
    }
    updatePageIndex(rowIndex) {
        var _a, _b, _c;
        // Change page if match is not on current page
        const indexPage = Math.floor(rowIndex / this.paginationPageSize);
        if (indexPage !== ((_a = this.gridApi) === null || _a === void 0 ? void 0 : _a.paginationGetCurrentPage())) {
            (_b = this.gridApi) === null || _b === void 0 ? void 0 : _b.paginationGoToPage(indexPage);
            this.forceUpdate();
        }
        (_c = this.gridApi) === null || _c === void 0 ? void 0 : _c.ensureIndexVisible(rowIndex);
    }
}
exports.TableOutputComponent = TableOutputComponent;
TableOutputComponent.defaultProps = {
    cacheBlockSize: 200,
    maxBlocksInCache: 5,
    columnWidth: 200,
    blockLoadDebounce: 250,
    tableHeight: '300px',
    tableWidth: '100%'
};
//# sourceMappingURL=table-output-component.js.map