"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractXYOutputComponent = exports.MouseButton = exports.XY_OUTPUT_KEY_ACTIONS = exports.FLAG_PAN_RIGHT = exports.FLAG_PAN_LEFT = exports.FLAG_ZOOM_OUT = exports.FLAG_ZOOM_IN = exports.ZOOM_OUT_RATE = exports.ZOOM_IN_RATE = void 0;
const abstract_tree_output_component_1 = require("./abstract-tree-output-component");
const responses_1 = require("tsp-typescript-client/lib/models/response/responses");
const query_helper_1 = require("tsp-typescript-client/lib/models/query/query-helper");
const d3_scale_1 = require("d3-scale");
const d3_axis_1 = require("d3-axis");
const d3_selection_1 = require("d3-selection");
const entry_tree_1 = require("./utils/filter-tree/entry-tree");
const React = __importStar(require("react"));
const react_dom_1 = require("react-dom");
const bigint_utils_1 = require("timeline-chart/lib/bigint-utils");
const xy_output_component_utils_1 = require("./utils/xy-output-component-utils");
const react_chartjs_2_1 = require("react-chartjs-2");
const utils_1 = require("./utils/filter-tree/utils");
const lodash_1 = require("lodash");
exports.ZOOM_IN_RATE = 0.8;
exports.ZOOM_OUT_RATE = 1.25;
exports.FLAG_ZOOM_IN = true;
exports.FLAG_ZOOM_OUT = false;
exports.FLAG_PAN_LEFT = true;
exports.FLAG_PAN_RIGHT = false;
var XY_OUTPUT_KEY_ACTIONS;
(function (XY_OUTPUT_KEY_ACTIONS) {
    XY_OUTPUT_KEY_ACTIONS[XY_OUTPUT_KEY_ACTIONS["ZOOM_IN"] = 0] = "ZOOM_IN";
    XY_OUTPUT_KEY_ACTIONS[XY_OUTPUT_KEY_ACTIONS["ZOOM_OUT"] = 1] = "ZOOM_OUT";
    XY_OUTPUT_KEY_ACTIONS[XY_OUTPUT_KEY_ACTIONS["PAN_LEFT"] = 2] = "PAN_LEFT";
    XY_OUTPUT_KEY_ACTIONS[XY_OUTPUT_KEY_ACTIONS["PAN_RIGHT"] = 3] = "PAN_RIGHT";
    XY_OUTPUT_KEY_ACTIONS[XY_OUTPUT_KEY_ACTIONS["SHIFT_PRESS"] = 4] = "SHIFT_PRESS";
})(XY_OUTPUT_KEY_ACTIONS = exports.XY_OUTPUT_KEY_ACTIONS || (exports.XY_OUTPUT_KEY_ACTIONS = {}));
var MouseButton;
(function (MouseButton) {
    MouseButton[MouseButton["NONE"] = -1] = "NONE";
    MouseButton[MouseButton["LEFT"] = 0] = "LEFT";
    MouseButton[MouseButton["MID"] = 1] = "MID";
    MouseButton[MouseButton["RIGHT"] = 2] = "RIGHT";
})(MouseButton = exports.MouseButton || (exports.MouseButton = {}));
class xyPair {
    constructor(x, y) {
        this.x = x;
        this.y = y;
    }
}
class AbstractXYOutputComponent extends abstract_tree_output_component_1.AbstractTreeOutputComponent {
    constructor(props) {
        super(props);
        // Styles
        this.currentColorIndex = 0;
        this.colorMap = new Map();
        this.margin = { top: 15, right: 0, bottom: 5, left: this.getYAxisWidth() };
        // Chart properties
        this.isScatterPlot = this.props.outputDescriptor.id.includes('scatter');
        this.isBarPlot = false;
        this.keyActionMap = new Map();
        this.posPixelSelect = 0;
        this.positionYMove = 0;
        // Event flags
        this.isMouseLeave = false;
        this.clickedMouseButton = MouseButton.NONE;
        this.mouseIsDown = false;
        this.isPanning = false;
        this.isSelecting = false;
        // Positions
        this.positionXMove = 0;
        this.startPositionMouseRightClick = BigInt(0);
        this.endSelection = (event) => {
            if (this.clickedMouseButton === MouseButton.RIGHT) {
                this.applySelectionZoom();
            }
            this.mouseIsDown = false;
            this.isSelecting = false;
            this.isPanning = false;
            this.clickedMouseButton = MouseButton.NONE;
            if (!event.shiftKey && !event.ctrlKey) {
                this.setState({ cursor: 'default' });
            }
            else if (!event.shiftKey && event.ctrlKey) {
                this.setState({ cursor: 'grabbing' });
            }
            else if (event.shiftKey && !event.ctrlKey) {
                this.setState({ cursor: 'crosshair' });
            }
            else {
                this.setState({ cursor: 'default' });
            }
            document.removeEventListener('mouseup', this.endSelection);
        };
        this.plugin = {
            afterDraw: (chartInstance, _easing, _options) => { this.afterChartDraw(chartInstance.ctx, chartInstance.chartArea); }
        };
        this._debouncedUpdateXY = (0, lodash_1.debounce)(() => this.updateXY(), 500);
        this.yAxisRef = React.createRef();
        this.divRef = React.createRef();
        this.chartRef = React.createRef();
        this.afterChartDraw = this.afterChartDraw.bind(this);
    }
    onToggleCollapse(id, nodes) {
        let newList = [...this.state.collapsedNodes];
        const exist = this.state.collapsedNodes.find(expandId => expandId === id);
        if (exist !== undefined) {
            newList = newList.filter(collapsed => id !== collapsed);
        }
        else {
            newList = newList.concat(id);
        }
        const orderedIds = (0, utils_1.getAllExpandedNodeIds)(nodes, newList);
        this.setState({ collapsedNodes: newList, orderedNodes: orderedIds });
    }
    onOrderChange(ids) {
        this.setState({ orderedNodes: ids });
    }
    onToggleCheck(ids) {
        let newList = [...this.state.checkedSeries];
        ids.forEach(id => {
            const exist = this.state.checkedSeries.find(seriesId => seriesId === id);
            if (exist !== undefined) {
                newList = newList.filter(series => id !== series);
            }
            else {
                newList = newList.concat(id);
            }
        });
        this.setState({ checkedSeries: newList });
    }
    updateRange(rangeStart, rangeEnd) {
        if (rangeEnd < rangeStart) {
            const temp = rangeStart;
            rangeStart = rangeEnd;
            rangeEnd = temp;
        }
        this.props.unitController.viewRange = {
            start: rangeStart,
            end: rangeEnd
        };
    }
    applySelectionZoom() {
        const newStartRange = this.startPositionMouseRightClick;
        const newEndRange = this.getTimeForX(this.positionXMove);
        this.updateRange(newStartRange, newEndRange);
    }
    updateSelection() {
        if (this.props.unitController.selectionRange) {
            const xStartPos = this.props.unitController.selectionRange.start;
            this.props.unitController.selectionRange = {
                start: xStartPos,
                end: this.getTimeForX(this.positionXMove)
            };
        }
    }
    componentDidMount() {
        this.waitAnalysisCompletion();
    }
    componentDidUpdate(prevProps, prevState) {
        const viewRangeChanged = this.props.viewRange !== prevProps.viewRange;
        const checkedSeriesChanged = this.state.checkedSeries !== prevState.checkedSeries;
        const collapsedNodesChanged = this.state.collapsedNodes !== prevState.collapsedNodes;
        const chartWidthChanged = this.props.style.width !== prevProps.style.width || this.props.style.chartOffset !== prevProps.style.chartOffset
            || this.props.style.componentLeft !== prevProps.style.componentLeft;
        const outputStatusChanged = this.state.outputStatus !== prevState.outputStatus;
        const needToUpdate = viewRangeChanged || checkedSeriesChanged || collapsedNodesChanged || chartWidthChanged || outputStatusChanged;
        if (needToUpdate) {
            this._debouncedUpdateXY();
        }
        if (this.chartRef.current) {
            if (this.preventDefaultHandler === undefined) {
                this.preventDefaultHandler = (event) => {
                    if (event.ctrlKey) {
                        event.preventDefault();
                    }
                };
                this.divRef.current.addEventListener('wheel', this.preventDefaultHandler);
            }
            if (this.isBarPlot) {
                this.renderChart();
            }
            else {
                this.chartRef.current.chartInstance.render();
            }
        }
    }
    componentWillUnmount() {
        super.componentWillUnmount();
    }
    async fetchTree() {
        this.viewSpinner(true);
        const parameters = query_helper_1.QueryHelper.timeRangeQuery(this.props.range.getStart(), this.props.range.getEnd());
        const tspClientResponse = await this.props.tspClient.fetchXYTree(this.props.traceId, this.props.outputDescriptor.id, parameters);
        const treeResponse = tspClientResponse.getModel();
        if (tspClientResponse.isOk() && treeResponse) {
            if (treeResponse.model) {
                const headers = treeResponse.model.headers;
                const columns = [];
                if (headers && headers.length > 0) {
                    headers.forEach(header => {
                        columns.push({ title: header.name, sortable: true, resizable: true, tooltip: header.tooltip });
                    });
                }
                else {
                    columns.push({ title: 'Name', sortable: true });
                }
                const checkedSeries = this.getAllCheckedIds(treeResponse.model.entries);
                this.setState({
                    outputStatus: treeResponse.status,
                    xyTree: treeResponse.model.entries,
                    checkedSeries,
                    columns
                }, () => {
                    this.updateXY();
                });
            }
            else {
                this.setState({
                    outputStatus: treeResponse.status
                });
            }
            this.viewSpinner(false);
            return treeResponse.status;
        }
        this.setState({
            outputStatus: responses_1.ResponseStatus.FAILED
        });
        this.viewSpinner(false);
        return responses_1.ResponseStatus.FAILED;
    }
    getAllCheckedIds(entries) {
        const checkedSeries = [];
        for (const entry of entries) {
            if (entry.isDefault) {
                checkedSeries.push(entry.id);
            }
        }
        return checkedSeries;
    }
    renderTree() {
        this.onToggleCheck = this.onToggleCheck.bind(this);
        this.onToggleCollapse = this.onToggleCollapse.bind(this);
        this.onOrderChange = this.onOrderChange.bind(this);
        return this.state.xyTree.length ?
            React.createElement("div", { className: 'scrollable', style: { height: this.props.style.height } },
                React.createElement(entry_tree_1.EntryTree, { entries: this.state.xyTree, showCheckboxes: true, collapsedNodes: this.state.collapsedNodes, checkedSeries: this.state.checkedSeries, onToggleCheck: this.onToggleCheck, onToggleCollapse: this.onToggleCollapse, onOrderChange: this.onOrderChange, headers: this.state.columns }))
            : undefined;
    }
    renderYAxis() {
        // Y axis with D3
        const chartHeight = parseInt(this.props.style.height.toString());
        const yScale = (0, d3_scale_1.scaleLinear)()
            .domain([this.state.allMin, Math.max(this.state.allMax, 1)])
            .range([chartHeight - this.margin.bottom, this.margin.top]);
        const yTransform = `translate(${this.margin.left}, 0)`;
        // Abbreviate large numbers
        const scaleYLabel = (d) => (d >= 1000000000000 ? Math.round(d / 100000000000) / 10 + 'G' :
            d >= 1000000000 ? Math.round(d / 100000000) / 10 + 'B' :
                d >= 1000000 ? Math.round(d / 100000) / 10 + 'M' :
                    d >= 1000 ? Math.round(d / 100) / 10 + 'K' :
                        Math.round(d * 10) / 10);
        if (this.state.allMax > 0) {
            (0, d3_selection_1.select)(this.yAxisRef.current).call((0, d3_axis_1.axisLeft)(yScale).tickSizeOuter(0).ticks(4)).call(g => g.select('.domain').remove());
            (0, d3_selection_1.select)(this.yAxisRef.current).selectAll('.tick text').style('font-size', '11px').text((d) => scaleYLabel(d));
        }
        return React.createElement(React.Fragment, null,
            React.createElement("svg", { height: chartHeight, width: this.margin.left },
                React.createElement("g", { className: 'y-axis', ref: this.yAxisRef, transform: yTransform })));
    }
    resultsAreEmpty() {
        return this.state.xyTree.length === 0;
    }
    setFocus() {
        var _a, _b;
        if (document.getElementById(this.getOutputComponentDomId() + 'focusContainer')) {
            (_a = document.getElementById(this.getOutputComponentDomId() + 'focusContainer')) === null || _a === void 0 ? void 0 : _a.focus();
        }
        else {
            (_b = document.getElementById(this.getOutputComponentDomId())) === null || _b === void 0 ? void 0 : _b.focus();
        }
    }
    chooseChart() {
        const param = {
            viewRange: this.getDisplayedRange(),
            allMax: this.state.allMax,
            allMin: this.state.allMin,
            isScatterPlot: this.isScatterPlot
        };
        const chartOptions = (0, xy_output_component_utils_1.xyChartFactory)(param);
        if (!this.isScatterPlot) {
            return (React.createElement(react_chartjs_2_1.Line, { data: this.state.xyData, height: parseInt(this.props.style.height.toString()), options: chartOptions, ref: this.chartRef, plugins: [this.plugin] }));
        }
        return (React.createElement(react_chartjs_2_1.Scatter, { data: this.state.xyData, height: parseInt(this.props.style.height.toString()), options: chartOptions, ref: this.chartRef, plugins: [this.plugin] }));
    }
    async updateXY() {
        var _a;
        let start = BigInt(0);
        let end = BigInt(0);
        const viewRange = this.getDisplayedRange();
        if (viewRange) {
            start = viewRange.getStart();
            end = viewRange.getEnd();
        }
        const xyDataParameters = query_helper_1.QueryHelper.selectionTimeRangeQuery(start, end, this.getChartWidth(), this.state.checkedSeries);
        const tspClientResponse = await this.props.tspClient.fetchXY(this.props.traceId, this.props.outputDescriptor.id, xyDataParameters);
        const xyDataResponse = tspClientResponse.getModel();
        if (tspClientResponse.isOk() && ((_a = xyDataResponse === null || xyDataResponse === void 0 ? void 0 : xyDataResponse.model) === null || _a === void 0 ? void 0 : _a.series)) {
            const series = xyDataResponse.model.series;
            if (series.length !== 0 && series[0].style) {
                // Rely on type set for the first series to conclude for all series, if many.
                // This is because support for per-series (potentially varying) type is lacking across-
                this.isScatterPlot = series[0].style.values['series-type'] === 'scatter';
            }
            if (this.isScatterPlot) {
                this.buildScatterData(series);
            }
            else {
                this.buildXYData(series);
            }
        }
    }
    viewSpinner(status) {
        if (document.getElementById(this.getOutputComponentDomId() + 'handleSpinner')) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            document.getElementById(this.getOutputComponentDomId() + 'handleSpinner').style.visibility = status ? 'visible' : 'hidden';
        }
    }
    buildScatterData(seriesObj) {
        var _a;
        const dataSetArray = new Array();
        let xValues = [];
        const offset = (_a = this.props.viewRange.getOffset()) !== null && _a !== void 0 ? _a : BigInt(0);
        seriesObj.forEach(series => {
            const color = this.getSeriesColor(series.seriesName);
            xValues = series.xValues;
            const yValues = series.yValues;
            let pairs = [];
            xValues.forEach((value, index) => {
                const adjusted = Number(value - offset);
                pairs.push(new xyPair(adjusted, yValues[index]));
            });
            const process = this.state.xyTree.filter(element => element.id === series.seriesId);
            dataSetArray.push({
                label: process[0].labels[0],
                data: pairs,
                backgroundColor: color,
                borderColor: color,
                showLine: false,
                fill: false
            });
            pairs = [];
        });
        const scatterData = {
            labels: xValues,
            datasets: dataSetArray
        };
        // flushSync: force immediate state update instead of waiting for React 18's automatic batching
        (0, react_dom_1.flushSync)(() => {
            this.setState({ xyData: scatterData });
        });
        this.calculateYRange();
    }
    buildXYData(seriesObj) {
        const dataSetArray = new Array();
        let xValues = [];
        seriesObj.forEach(series => {
            const color = this.getSeriesColor(series.seriesName);
            xValues = series.xValues;
            dataSetArray.push({
                label: series.seriesName,
                fill: false,
                borderColor: color,
                backgroundColor: color,
                borderWidth: 2,
                data: series.yValues
            });
        });
        const lineData = {
            labels: xValues,
            datasets: dataSetArray
        };
        // flushSync: force immediate state update instead of waiting for React 18's automatic batching
        (0, react_dom_1.flushSync)(() => {
            this.setState({ xyData: lineData });
        });
        this.calculateYRange();
    }
    getSeriesColor(key) {
        const colors = ['rgba(191, 33, 30, 1)', 'rgba(30, 56, 136, 1)', 'rgba(71, 168, 189, 1)', 'rgba(245, 230, 99, 1)', 'rgba(255, 173, 105, 1)',
            'rgba(216, 219, 226, 1)', 'rgba(212, 81, 19, 1)', 'rgba(187, 155, 176  , 1)', 'rgba(6, 214, 160, 1)', 'rgba(239, 71, 111, 1)'];
        let colorIndex = this.colorMap.get(key);
        if (colorIndex === undefined) {
            colorIndex = this.currentColorIndex % colors.length;
            this.colorMap.set(key, colorIndex);
            this.currentColorIndex++;
        }
        return colors[colorIndex];
    }
    calculateYRange() {
        var _a, _b;
        let localMax = 0;
        let localMin = 0;
        if (this.state && this.state.xyData) {
            (_b = (_a = this.state.xyData) === null || _a === void 0 ? void 0 : _a.datasets) === null || _b === void 0 ? void 0 : _b.forEach((dSet, i) => {
                let rowMax;
                let rowMin;
                if (this.isScatterPlot) {
                    rowMax = Math.max(...dSet.data.map((d) => d.y));
                    rowMin = Math.min(...dSet.data.map((d) => d.y));
                }
                else {
                    rowMax = Math.max(...dSet.data);
                    rowMin = Math.min(...dSet.data);
                }
                localMax = Math.max(localMax, rowMax);
                localMin = i === 0 ? rowMin : Math.min(localMin, rowMin);
            });
        }
        this.setState({
            allMax: localMax * 1.01,
            allMin: localMin * 0.99
        });
    }
    getTimeForX(x) {
        var _a;
        const range = this.getDisplayedRange();
        const offset = (_a = range.getOffset()) !== null && _a !== void 0 ? _a : BigInt(0);
        const duration = range.getDuration();
        const chartWidth = this.getChartWidth() === 0 ? 1 : this.getChartWidth();
        const time = range.getStart() - offset +
            bigint_utils_1.BIMath.round(x / chartWidth * Number(duration));
        return time;
    }
    getXForTime(time) {
        const range = this.getDisplayedRange();
        const start = range.getStart();
        const duration = range.getDuration();
        const chartWidth = this.getChartWidth() === 0 ? 1 : this.getChartWidth();
        const x = Number(time - start) / Number(duration) * chartWidth;
        return x;
    }
    zoom(isZoomIn) {
        if (this.props.unitController.viewRangeLength >= 1) {
            const zoomCenterTime = this.getZoomTime();
            const startDistance = zoomCenterTime - this.props.unitController.viewRange.start;
            const zoomFactor = isZoomIn ? exports.ZOOM_IN_RATE : exports.ZOOM_OUT_RATE;
            const newDuration = bigint_utils_1.BIMath.clamp(Number(this.props.unitController.viewRangeLength) * zoomFactor, BigInt(2), this.props.unitController.absoluteRange);
            const newStartRange = bigint_utils_1.BIMath.max(0, zoomCenterTime - bigint_utils_1.BIMath.round(Number(startDistance) * zoomFactor));
            const newEndRange = newStartRange + newDuration;
            this.updateRange(newStartRange, newEndRange);
        }
    }
    pan(panLeft) {
        const panFactor = 0.1;
        const percentRange = bigint_utils_1.BIMath.round(Number(this.props.unitController.viewRangeLength) * panFactor);
        const panNumber = panLeft ? BigInt(-1) : BigInt(1);
        const startRange = this.props.unitController.viewRange.start + (panNumber * percentRange);
        const endRange = this.props.unitController.viewRange.end + (panNumber * percentRange);
        if (startRange < 0) {
            this.props.unitController.viewRange = {
                start: BigInt(0),
                end: this.props.unitController.viewRangeLength
            };
        }
        else if (endRange > this.props.unitController.absoluteRange) {
            this.props.unitController.viewRange = {
                start: this.props.unitController.absoluteRange - this.props.unitController.viewRangeLength,
                end: this.props.unitController.absoluteRange
            };
        }
        else {
            this.props.unitController.viewRange = {
                start: startRange,
                end: endRange
            };
        }
    }
    tooltip(x, y) {
        var _a;
        const xPos = this.positionXMove;
        const timeForX = this.getTimeForX(xPos);
        let timeLabel = timeForX.toString();
        if (this.props.unitController.numberTranslator) {
            timeLabel = this.props.unitController.numberTranslator(timeForX);
        }
        const chartWidth = this.isBarPlot ? this.getChartWidth() : this.chartRef.current.chartInstance.width;
        const chartHeight = this.isBarPlot ? parseInt(this.props.style.height.toString()) : this.chartRef.current.chartInstance.height;
        const arraySize = this.state.xyData.labels.length;
        const index = Math.max(Math.round((xPos / chartWidth) * (arraySize - 1)), 0);
        const points = [];
        let zeros = 0;
        this.state.xyData.datasets.forEach((d) => {
            let yValue = 0;
            let xValue = 0;
            let invalidPoint = false;
            if (this.isScatterPlot) {
                if (d.data.length > 0) {
                    const getClosestPointParam = {
                        dataPoints: d.data,
                        mousePosition: {
                            x: this.positionXMove,
                            y: this.positionYMove
                        },
                        chartWidth: chartWidth,
                        chartHeight: chartHeight,
                        range: this.getDisplayedRange(),
                        margin: this.margin,
                        allMax: this.state.allMax,
                        allMin: this.state.allMin,
                    };
                    // Find the data point that is the closest to the mouse position
                    const closest = (0, xy_output_component_utils_1.getClosestPointForScatterPlot)(getClosestPointParam);
                    if (closest !== undefined) {
                        yValue = closest.y;
                        xValue = closest.x;
                    }
                    else {
                        invalidPoint = true; // Too far from mouse
                    }
                }
                else {
                    invalidPoint = true; // Series without any data
                }
            }
            else {
                // In case there are less data points than pixels in the chart,
                // calculate nearest value.
                yValue = d.data[index];
            }
            const rounded = isNaN(yValue) ? 0 : (Math.round(Number(yValue) * 100) / 100);
            let formatted = new Intl.NumberFormat().format(rounded);
            if (this.isScatterPlot && this.props.unitController.numberTranslator) {
                const time = this.props.unitController.numberTranslator(BigInt(xValue));
                formatted = '(' + time + ') ' + formatted;
                timeLabel = 'Series (time stamp) value';
            }
            // If there are less than 10 lines in the chart, show all values, even if they are equal to 0.
            // If there are more than 10 lines in the chart, summarise the ones that are equal to 0.
            if (!invalidPoint) {
                if (this.state.xyData.datasets.length <= 10 || rounded > 0) {
                    const point = {
                        label: d.label,
                        color: d.borderColor,
                        background: d.backgroundColor,
                        value: formatted
                    };
                    points.push(point);
                }
                else if (!this.isScatterPlot) {
                    zeros += 1;
                }
            }
        });
        // Sort in decreasing order
        points.sort((a, b) => Number(b.value) - Number(a.value));
        // Adjust tooltip position if mouse is too close to the bottom of the window
        let topPos = undefined;
        let bottomPos = undefined;
        if (y > window.innerHeight - 350) {
            bottomPos = window.innerHeight - y;
        }
        else {
            topPos = window.pageYOffset + y - 40;
        }
        // Adjust tooltip position if mouse is too close to the left edge of the chart
        let leftPos = undefined;
        let rightPos = undefined;
        const xLocation = chartWidth - xPos;
        if (xLocation > chartWidth * 0.8) {
            leftPos = x - this.props.style.componentLeft;
        }
        else {
            rightPos = xLocation;
        }
        const tooltipData = {
            title: timeLabel,
            dataPoints: points,
            top: topPos,
            bottom: bottomPos,
            right: rightPos,
            left: leftPos,
            opacity: 1,
            zeros
        };
        if (points.length > 0) {
            (_a = this.props.tooltipXYComponent) === null || _a === void 0 ? void 0 : _a.setElement(tooltipData);
        }
        else {
            this.hideTooltip();
        }
    }
    hideTooltip() {
        var _a;
        (_a = this.props.tooltipXYComponent) === null || _a === void 0 ? void 0 : _a.setElement({
            opacity: 0
        });
    }
}
exports.AbstractXYOutputComponent = AbstractXYOutputComponent;
//# sourceMappingURL=abstract-xy-output-component.js.map