"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TraceExplorerWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceExplorerWidget = void 0;
const inversify_1 = require("inversify");
const theia_trace_explorer_views_widget_1 = require("./trace-explorer-sub-widgets/theia-trace-explorer-views-widget");
const browser_1 = require("@theia/core/lib/browser");
const theia_trace_explorer_properties_widget_1 = require("./trace-explorer-sub-widgets/theia-trace-explorer-properties-widget");
const theia_trace_explorer_opened_traces_widget_1 = require("./trace-explorer-sub-widgets/theia-trace-explorer-opened-traces-widget");
const trace_explorer_placeholder_widget_1 = require("./trace-explorer-sub-widgets/trace-explorer-placeholder-widget");
const trace_explorer_server_status_widget_1 = require("./trace-explorer-sub-widgets/trace-explorer-server-status-widget");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const trace_server_status_1 = require("../trace-server-status");
let TraceExplorerWidget = TraceExplorerWidget_1 = class TraceExplorerWidget extends browser_1.BaseWidget {
    constructor() {
        super(...arguments);
        this._numberOfOpenedTraces = 0;
        this.onUpdateSignal = (payload) => this.doHandleOpenedTracesChanged(payload);
    }
    openExperiment(traceUUID) {
        return this.openedTracesWidget.openExperiment(traceUUID);
    }
    closeExperiment(traceUUID) {
        return this.openedTracesWidget.closeExperiment(traceUUID);
    }
    deleteExperiment(traceUUID) {
        return this.openedTracesWidget.deleteExperiment(traceUUID);
    }
    static createWidget(parent) {
        return TraceExplorerWidget_1.createContainer(parent).get(TraceExplorerWidget_1);
    }
    static createContainer(parent) {
        const child = new inversify_1.Container({ defaultScope: 'Singleton' });
        child.parent = parent;
        child.bind(theia_trace_explorer_views_widget_1.TraceExplorerViewsWidget).toSelf();
        child.bind(theia_trace_explorer_opened_traces_widget_1.TraceExplorerOpenedTracesWidget).toSelf();
        child.bind(trace_explorer_placeholder_widget_1.TraceExplorerPlaceholderWidget).toSelf();
        child.bind(trace_explorer_server_status_widget_1.TraceExplorerServerStatusWidget).toSelf();
        child.bind(theia_trace_explorer_properties_widget_1.TraceExplorerItemPropertiesWidget).toSelf();
        child.bind(TraceExplorerWidget_1).toSelf().inSingletonScope();
        return child;
    }
    init() {
        this.id = TraceExplorerWidget_1.ID;
        this.title.label = TraceExplorerWidget_1.LABEL;
        this.title.caption = TraceExplorerWidget_1.LABEL;
        this.title.iconClass = 'trace-explorer-tab-icon';
        this.title.closable = true;
        this.traceViewsContainer = this.viewContainerFactory({
            id: this.id
        });
        this.traceViewsContainer.addWidget(this.openedTracesWidget);
        this.traceViewsContainer.addWidget(this.viewsWidget);
        this.traceViewsContainer.addWidget(this.itemPropertiesWidget);
        this.toDispose.push(this.traceViewsContainer);
        const layout = this.layout = new browser_1.PanelLayout();
        layout.addWidget(this.serverStatusWidget);
        layout.addWidget(this.placeholderWidget);
        layout.addWidget(this.traceViewsContainer);
        this.node.tabIndex = 0;
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.OPENED_TRACES_UPDATED, this.onUpdateSignal);
        this.update();
    }
    dispose() {
        super.dispose();
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.OPENED_TRACES_UPDATED, this.onUpdateSignal);
    }
    doHandleOpenedTracesChanged(payload) {
        this._numberOfOpenedTraces = payload.getNumberOfOpenedTraces();
        this.update();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        if (this._numberOfOpenedTraces > 0) {
            this.traceViewsContainer.show();
            this.placeholderWidget.hide();
        }
        else {
            this.traceViewsContainer.hide();
            this.placeholderWidget.show();
        }
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.node.focus();
    }
    onAfterShow() {
        this.connectionStatusService.addConnectionStatusListener();
    }
    onAfterHide() {
        this.connectionStatusService.removeConnectionStatusListener();
    }
};
TraceExplorerWidget.LABEL = 'Trace Viewer';
TraceExplorerWidget.ID = 'trace-explorer';
__decorate([
    (0, inversify_1.inject)(theia_trace_explorer_views_widget_1.TraceExplorerViewsWidget),
    __metadata("design:type", theia_trace_explorer_views_widget_1.TraceExplorerViewsWidget)
], TraceExplorerWidget.prototype, "viewsWidget", void 0);
__decorate([
    (0, inversify_1.inject)(theia_trace_explorer_opened_traces_widget_1.TraceExplorerOpenedTracesWidget),
    __metadata("design:type", theia_trace_explorer_opened_traces_widget_1.TraceExplorerOpenedTracesWidget)
], TraceExplorerWidget.prototype, "openedTracesWidget", void 0);
__decorate([
    (0, inversify_1.inject)(theia_trace_explorer_properties_widget_1.TraceExplorerItemPropertiesWidget),
    __metadata("design:type", theia_trace_explorer_properties_widget_1.TraceExplorerItemPropertiesWidget)
], TraceExplorerWidget.prototype, "itemPropertiesWidget", void 0);
__decorate([
    (0, inversify_1.inject)(trace_explorer_placeholder_widget_1.TraceExplorerPlaceholderWidget),
    __metadata("design:type", trace_explorer_placeholder_widget_1.TraceExplorerPlaceholderWidget)
], TraceExplorerWidget.prototype, "placeholderWidget", void 0);
__decorate([
    (0, inversify_1.inject)(trace_explorer_server_status_widget_1.TraceExplorerServerStatusWidget),
    __metadata("design:type", trace_explorer_server_status_widget_1.TraceExplorerServerStatusWidget)
], TraceExplorerWidget.prototype, "serverStatusWidget", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.ViewContainer.Factory),
    __metadata("design:type", Function)
], TraceExplorerWidget.prototype, "viewContainerFactory", void 0);
__decorate([
    (0, inversify_1.inject)(trace_server_status_1.TraceServerConnectionStatusService),
    __metadata("design:type", trace_server_status_1.TraceServerConnectionStatusService)
], TraceExplorerWidget.prototype, "connectionStatusService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TraceExplorerWidget.prototype, "init", null);
TraceExplorerWidget = TraceExplorerWidget_1 = __decorate([
    (0, inversify_1.injectable)()
], TraceExplorerWidget);
exports.TraceExplorerWidget = TraceExplorerWidget;
//# sourceMappingURL=trace-explorer-widget.js.map