"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/********************************************************************************
 * Copyright (C) 2022 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
const create_launcher_contribution_1 = require("./create-launcher-contribution");
const inversify_1 = require("@theia/core/shared/inversify");
const launcher_service_1 = require("./launcher-service");
const browser_1 = require("@theia/core/lib/browser");
exports.default = new inversify_1.ContainerModule(bind => {
    bind(browser_1.FrontendApplicationContribution).to(create_launcher_contribution_1.CreateLauncherCommandContribution);
    bind(launcher_service_1.LauncherService).toSelf().inSingletonScope();
});
//# sourceMappingURL=create-launcher-frontend-module.js.map