"use strict";
/********************************************************************************
 * Copyright (C) 2022 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleGeneratorCommandContribution = exports.GenerateExampleCommandHandler = exports.GenerateExampleCommand = void 0;
const core_1 = require("@theia/core");
const browser_1 = require("@theia/core/lib/browser");
const uri_1 = require("@theia/core/lib/common/uri");
const browser_2 = require("@theia/editor/lib/browser");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const inversify_1 = require("inversify");
const protocol_1 = require("../common/protocol");
exports.GenerateExampleCommand = {
    id: 'eclipse-cdt-cloud.example-generator.generate-example',
    label: 'Generate CDT Cloud Blueprint Example'
};
let GenerateExampleCommandHandler = class GenerateExampleCommandHandler {
    async execute(...args) {
        const exampleId = await this.getExampleId(args);
        if (!exampleId) {
            return;
        }
        const targetFolder = await this.getWorkspaceRoot();
        if (!targetFolder) {
            this.messageService.error('Cannot resolve workspace root, please open a workspace');
            return;
        }
        const progress = await this.messageService.showProgress({ text: 'Starting to report progress' });
        try {
            const fileToBeOpened = await this.exampleGeneratorService.generateExample(exampleId, targetFolder.toString());
            if (fileToBeOpened) {
                this.editorManager.open(new uri_1.default(fileToBeOpened));
            }
        }
        catch (error) {
            console.error('Uncaught Exception: ', error.toString());
        }
        finally {
            progress.cancel();
        }
    }
    async getExampleId(args) {
        if (args.length < 1 || typeof args[0] !== 'string') {
            return this.askUserToChooseExample();
        }
        return args[0];
    }
    async askUserToChooseExample() {
        const items = [
            { label: 'CMake example', value: protocol_1.Examples.CMAKE_EXAMPLE },
            { label: 'Example traces', value: protocol_1.Examples.EXAMPLE_TRACES },
            { label: 'Clangd contexts', value: protocol_1.Examples.CLANGD_CONTEXTS }
        ];
        const selection = await this.quickPickService.show(items, {
            placeholder: 'Select type of example to generate'
        });
        return selection === null || selection === void 0 ? void 0 : selection.value;
    }
    async getWorkspaceRoot() {
        const workspaceRoot = await this.selectWorkspaceRoot();
        if (!workspaceRoot) {
            return;
        }
        return workspaceRoot;
    }
    async selectWorkspaceRoot() {
        const workspaceRoots = this.workspaceService.tryGetRoots();
        if (workspaceRoots.length === 0) {
            return;
        }
        if (workspaceRoots.length === 1) {
            return workspaceRoots[0].resource;
        }
        const items = [];
        for (const workspaceRoot of workspaceRoots) {
            items.push({
                label: this.labelProvider.getName(workspaceRoot.resource),
                description: this.labelProvider.getLongName(workspaceRoot.resource),
                value: workspaceRoot.resource
            });
        }
        const root = await this.quickPickService.show(items, {
            placeholder: core_1.nls.localize('theia/debug/addConfigurationPlaceholder', 'Select workspace root to add example to')
        });
        return root === null || root === void 0 ? void 0 : root.value;
    }
};
__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], GenerateExampleCommandHandler.prototype, "workspaceService", void 0);
__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], GenerateExampleCommandHandler.prototype, "fileService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    __metadata("design:type", browser_1.LabelProvider)
], GenerateExampleCommandHandler.prototype, "labelProvider", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.QuickPickService),
    __metadata("design:type", Object)
], GenerateExampleCommandHandler.prototype, "quickPickService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.QuickInputService),
    __metadata("design:type", Object)
], GenerateExampleCommandHandler.prototype, "quickInputService", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    __metadata("design:type", core_1.MessageService)
], GenerateExampleCommandHandler.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ExampleGeneratorService),
    __metadata("design:type", Object)
], GenerateExampleCommandHandler.prototype, "exampleGeneratorService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    __metadata("design:type", browser_2.EditorManager)
], GenerateExampleCommandHandler.prototype, "editorManager", void 0);
GenerateExampleCommandHandler = __decorate([
    (0, inversify_1.injectable)()
], GenerateExampleCommandHandler);
exports.GenerateExampleCommandHandler = GenerateExampleCommandHandler;
let ExampleGeneratorCommandContribution = class ExampleGeneratorCommandContribution {
    registerCommands(commands) {
        commands.registerCommand(exports.GenerateExampleCommand, this.generateExampleCommandHandler);
    }
};
__decorate([
    (0, inversify_1.inject)(GenerateExampleCommandHandler),
    __metadata("design:type", GenerateExampleCommandHandler)
], ExampleGeneratorCommandContribution.prototype, "generateExampleCommandHandler", void 0);
ExampleGeneratorCommandContribution = __decorate([
    (0, inversify_1.injectable)()
], ExampleGeneratorCommandContribution);
exports.ExampleGeneratorCommandContribution = ExampleGeneratorCommandContribution;
//# sourceMappingURL=example-generator-contribution.js.map