"use strict";
// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BuiltinThemeProvider = exports.ThemeService = void 0;
const event_1 = require("../common/event");
const disposable_1 = require("../common/disposable");
const frontend_application_config_provider_1 = require("./frontend-application-config-provider");
const application_props_1 = require("@theia/application-package/lib/application-props");
const inversify_1 = require("inversify");
const promise_util_1 = require("../common/promise-util");
let ThemeService = class ThemeService {
    constructor() {
        this.themes = {};
        this.themeChange = new event_1.Emitter();
        this.deferredInitializer = new promise_util_1.Deferred();
        this.onDidColorThemeChange = this.themeChange.event;
    }
    get initialized() {
        return this.deferredInitializer.promise;
    }
    init() {
        this.register(...BuiltinThemeProvider.themes);
        this.loadUserTheme();
    }
    register(...themes) {
        for (const theme of themes) {
            this.themes[theme.id] = theme;
        }
        this.validateActiveTheme();
        return disposable_1.Disposable.create(() => {
            for (const theme of themes) {
                delete this.themes[theme.id];
            }
            this.validateActiveTheme();
        });
    }
    validateActiveTheme() {
        if (!this.activeTheme) {
            return;
        }
        const theme = this.themes[this.activeTheme.id];
        if (!theme) {
            this.loadUserTheme();
        }
        else if (theme !== this.activeTheme) {
            this.activeTheme = undefined;
            this.setCurrentTheme(theme.id);
        }
    }
    getThemes() {
        const result = [];
        for (const o in this.themes) {
            if (this.themes.hasOwnProperty(o)) {
                result.push(this.themes[o]);
            }
        }
        return result;
    }
    getTheme(themeId) {
        return this.themes[themeId] || this.defaultTheme;
    }
    startupTheme() {
        var _a;
        const theme = this.getCurrentTheme();
        (_a = theme.activate) === null || _a === void 0 ? void 0 : _a.call(theme);
    }
    loadUserTheme() {
        const theme = this.getCurrentTheme();
        this.setCurrentTheme(theme.id);
        this.deferredInitializer.resolve();
    }
    setCurrentTheme(themeId) {
        var _a, _b;
        const newTheme = this.getTheme(themeId);
        const oldTheme = this.activeTheme;
        if (oldTheme) {
            if (oldTheme.id === newTheme.id) {
                return;
            }
            (_a = oldTheme.deactivate) === null || _a === void 0 ? void 0 : _a.call(oldTheme);
        }
        (_b = newTheme.activate) === null || _b === void 0 ? void 0 : _b.call(newTheme);
        this.activeTheme = newTheme;
        window.localStorage.setItem('theme', themeId);
        this.themeChange.fire({
            newTheme, oldTheme
        });
    }
    getCurrentTheme() {
        const themeId = window.localStorage.getItem('theme') || this.defaultTheme.id;
        return this.getTheme(themeId);
    }
    /**
     * The default theme. If that is not applicable, returns with the fallback theme.
     */
    get defaultTheme() {
        return this.themes[frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().defaultTheme] || this.themes[application_props_1.ApplicationProps.DEFAULT.frontend.config.defaultTheme];
    }
    /**
     * Resets the state to the user's default, or to the fallback theme. Also discards any persisted state in the local storage.
     */
    reset() {
        this.setCurrentTheme(this.defaultTheme.id);
    }
};
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ThemeService.prototype, "init", null);
ThemeService = __decorate([
    (0, inversify_1.injectable)()
], ThemeService);
exports.ThemeService = ThemeService;
class BuiltinThemeProvider {
}
exports.BuiltinThemeProvider = BuiltinThemeProvider;
BuiltinThemeProvider.darkTheme = {
    id: 'dark',
    type: 'dark',
    label: 'Dark (Theia)',
    editorTheme: 'dark-theia' // loaded in /packages/monaco/src/browser/textmate/monaco-theme-registry.ts
};
BuiltinThemeProvider.lightTheme = {
    id: 'light',
    type: 'light',
    label: 'Light (Theia)',
    editorTheme: 'light-theia' // loaded in /packages/monaco/src/browser/textmate/monaco-theme-registry.ts
};
BuiltinThemeProvider.hcTheme = {
    id: 'hc-theia',
    type: 'hc',
    label: 'High Contrast (Theia)',
    editorTheme: 'hc-theia' // loaded in /packages/monaco/src/browser/textmate/monaco-theme-registry.ts
};
BuiltinThemeProvider.themes = [
    BuiltinThemeProvider.darkTheme,
    BuiltinThemeProvider.lightTheme,
    BuiltinThemeProvider.hcTheme
];
//# sourceMappingURL=theming.js.map