/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ls.core.internal.DocumentAdapter;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;

public abstract class BaseDocumentLifeCycleHandler {
    public static final String DOCUMENT_LIFE_CYCLE_JOBS = "DocumentLifeCycleJobs";
    public static final String PUBLISH_DIAGNOSTICS_JOBS = "DocumentLifeCyclePublishDiagnosticsJobs";
    private CoreASTProvider sharedASTProvider;
    private WorkspaceJob validationTimer;
    private WorkspaceJob publishDiagnosticsJob;
    private Set<ICompilationUnit> toReconcile = new HashSet<ICompilationUnit>();

    public BaseDocumentLifeCycleHandler(boolean delayValidation) {
        this.sharedASTProvider = CoreASTProvider.getInstance();
        if (delayValidation) {
            this.validationTimer = new WorkspaceJob("Validate documents"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    return BaseDocumentLifeCycleHandler.this.performValidation(monitor);
                }

                public boolean belongsTo(Object family) {
                    return BaseDocumentLifeCycleHandler.DOCUMENT_LIFE_CYCLE_JOBS.equals(family);
                }
            };
            this.publishDiagnosticsJob = new WorkspaceJob("Publish Diagnostics"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    return BaseDocumentLifeCycleHandler.this.publishDiagnostics(monitor);
                }

                public boolean belongsTo(Object family) {
                    return BaseDocumentLifeCycleHandler.PUBLISH_DIAGNOSTICS_JOBS.equals(family);
                }
            };
        }
    }

    public abstract BaseDiagnosticsHandler createDiagnosticsHandler(ICompilationUnit var1);

    public abstract boolean isSyntaxMode(ICompilationUnit var1);

    public abstract ICompilationUnit resolveCompilationUnit(String var1);

    protected void triggerValidation(ICompilationUnit cu) throws JavaModelException {
        this.triggerValidation(cu, 400L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerValidation(ICompilationUnit cu, long delay) throws JavaModelException {
        Set<ICompilationUnit> set = this.toReconcile;
        synchronized (set) {
            this.toReconcile.add(cu);
            if (!cu.equals(this.sharedASTProvider.getActiveJavaElement())) {
                this.sharedASTProvider.disposeAST();
            }
            this.sharedASTProvider.setActiveJavaElement((ITypeRoot)cu);
        }
        if (this.validationTimer != null) {
            this.validationTimer.cancel();
            ISchedulingRule rule = this.getRule(this.toReconcile);
            if (this.publishDiagnosticsJob != null) {
                this.publishDiagnosticsJob.cancel();
                this.publishDiagnosticsJob.setRule(rule);
            }
            this.validationTimer.setRule(rule);
            this.validationTimer.schedule(delay);
        } else {
            this.performValidation((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private ISchedulingRule getRule(Set<ICompilationUnit> units) {
        ISchedulingRule result = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        for (ICompilationUnit unit : units) {
            if (unit.getResource() == null) continue;
            ISchedulingRule rule = ruleFactory.createRule(unit.getResource());
            result = MultiRule.combine((ISchedulingRule)rule, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus performValidation(IProgressMonitor monitor) throws JavaModelException {
        ArrayList<ICompilationUnit> cusToReconcile;
        long start = System.currentTimeMillis();
        Set<ICompilationUnit> set = this.toReconcile;
        synchronized (set) {
            if (this.toReconcile.isEmpty()) {
                return Status.OK_STATUS;
            }
            cusToReconcile = new ArrayList<ICompilationUnit>(this.toReconcile.size());
            cusToReconcile.addAll(this.toReconcile);
            this.toReconcile.clear();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(cusToReconcile.size() + 1));
        for (ICompilationUnit cu : cusToReconcile) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            cu.makeConsistent((IProgressMonitor)progress);
        }
        JavaLanguageServerPlugin.logInfo("Reconciled " + this.toReconcile.size() + ". Took " + (System.currentTimeMillis() - start) + " ms");
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.publishDiagnosticsJob != null) {
            this.publishDiagnosticsJob.cancel();
            try {
                this.publishDiagnosticsJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
        } else {
            return this.publishDiagnostics((IProgressMonitor)new NullProgressMonitor());
        }
        this.publishDiagnosticsJob.schedule(400L);
        return Status.OK_STATUS;
    }

    private IStatus publishDiagnostics(IProgressMonitor monitor) throws JavaModelException {
        long start = System.currentTimeMillis();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.sharedASTProvider.disposeAST();
        List<ICompilationUnit> toValidate = Arrays.asList(JavaCore.getWorkingCopies(null));
        if (toValidate.isEmpty()) {
            return Status.OK_STATUS;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(toValidate.size() + 1));
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        for (ICompilationUnit rootToValidate : toValidate) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            CompilationUnit astRoot = this.sharedASTProvider.getAST((ITypeRoot)rootToValidate, CoreASTProvider.WAIT_YES, monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (astRoot == null) continue;
            ICompilationUnit unit = (ICompilationUnit)astRoot.getTypeRoot();
            this.publishDiagnostics(unit, (IProgressMonitor)progress.newChild(1));
        }
        JavaLanguageServerPlugin.logInfo("Validated " + toValidate.size() + ". Took " + (System.currentTimeMillis() - start) + " ms");
        return Status.OK_STATUS;
    }

    private void publishDiagnostics(ICompilationUnit unit, final IProgressMonitor monitor) throws JavaModelException {
        final BaseDiagnosticsHandler handler = this.createDiagnosticsHandler(unit);
        WorkingCopyOwner wcOwner = new WorkingCopyOwner(){

            public IBuffer createBuffer(ICompilationUnit workingCopy) {
                ICompilationUnit original;
                IResource resource;
                if (!monitor.isCanceled() && (resource = (original = workingCopy.getPrimary()).getResource()) instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.Null;
            }

            public IProblemRequestor getProblemRequestor(ICompilationUnit workingCopy) {
                return handler;
            }
        };
        int flags = 7;
        unit.reconcile(0, flags, wcOwner, monitor);
    }

    public void didClose(final DidCloseTextDocumentParams params) {
        ISchedulingRule rule = JDTUtils.getRule(params.getTextDocument().getUri());
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BaseDocumentLifeCycleHandler.this.handleClosed(params);
                }
            }, rule, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Handle document close ", e);
        }
    }

    public void didOpen(final DidOpenTextDocumentParams params) {
        ISchedulingRule rule = JDTUtils.getRule(params.getTextDocument().getUri());
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BaseDocumentLifeCycleHandler.this.handleOpen(params);
                }
            }, rule, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Handle document open ", e);
        }
    }

    public void didChange(final DidChangeTextDocumentParams params) {
        ISchedulingRule rule = JDTUtils.getRule(params.getTextDocument().getUri());
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BaseDocumentLifeCycleHandler.this.handleChanged(params);
                }
            }, rule, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Handle document change ", e);
        }
    }

    public void didSave(final DidSaveTextDocumentParams params) {
        ISchedulingRule rule = JDTUtils.getRule(params.getTextDocument().getUri());
        try {
            JobHelpers.waitForJobs(DOCUMENT_LIFE_CYCLE_JOBS, (IProgressMonitor)new NullProgressMonitor());
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BaseDocumentLifeCycleHandler.this.handleSaved(params);
                }
            }, rule, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Handle document save ", e);
        }
    }

    public ICompilationUnit handleOpen(DidOpenTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = this.resolveCompilationUnit(uri);
        if (unit == null || unit.getResource() == null || unit.getResource().isDerived()) {
            return unit;
        }
        try {
            if (!unit.getResource().isAccessible()) {
                try {
                    IJavaElement parent;
                    unit.getResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    if (unit.getResource().exists() && (parent = unit.getParent()) instanceof PackageFragment) {
                        PackageFragment pkg = (PackageFragment)parent;
                        OpenableElementInfo elementInfo = (OpenableElementInfo)pkg.getElementInfo();
                        elementInfo.addChild((IJavaElement)unit);
                    }
                }
                catch (CoreException parent) {
                    // empty catch block
                }
            }
            unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IBuffer buffer = unit.getBuffer();
            String newContent = params.getTextDocument().getText();
            if (buffer != null && !buffer.getContents().equals(newContent)) {
                buffer.setContents(newContent);
            }
            this.triggerValidation(unit);
            this.checkPackageDeclaration(uri, unit);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Error while opening document. URI: " + uri, e);
        }
        return unit;
    }

    public ICompilationUnit handleChanged(DidChangeTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null || !unit.isWorkingCopy() || params.getContentChanges().isEmpty() || unit.getResource().isDerived()) {
            return unit;
        }
        try {
            if (unit.equals(this.sharedASTProvider.getActiveJavaElement())) {
                this.sharedASTProvider.disposeAST();
            }
            List contentChanges = params.getContentChanges();
            for (TextDocumentContentChangeEvent changeEvent : contentChanges) {
                int length;
                Range range = changeEvent.getRange();
                if (range != null) {
                    length = changeEvent.getRangeLength();
                } else {
                    length = unit.getSource().length();
                    range = JDTUtils.toRange((IOpenable)unit, 0, length);
                }
                int startOffset = JsonRpcHelpers.toOffset(unit.getBuffer(), range.getStart().getLine(), range.getStart().getCharacter());
                Object edit = null;
                String text = changeEvent.getText();
                edit = length == 0 ? new InsertEdit(startOffset, text) : (text.isEmpty() ? new DeleteEdit(startOffset, length) : new ReplaceEdit(startOffset, length, text));
                IDocument document = JsonRpcHelpers.toDocument(unit.getBuffer());
                edit.apply(document, 0);
            }
            this.triggerValidation(unit);
        }
        catch (JavaModelException | BadLocationException | MalformedTreeException e) {
            JavaLanguageServerPlugin.logException("Error while handling document change. URI: " + uri, e);
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompilationUnit handleClosed(DidCloseTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null) {
            return unit;
        }
        try {
            File f;
            Set<ICompilationUnit> set = this.toReconcile;
            synchronized (set) {
                this.toReconcile.remove(unit);
            }
            if (this.isSyntaxMode(unit) || unit.getResource().isDerived()) {
                this.createDiagnosticsHandler(unit).clearDiagnostics();
            } else if (this.hasUnsavedChanges(unit)) {
                unit.discardWorkingCopy();
                unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                this.publishDiagnostics(unit, (IProgressMonitor)new NullProgressMonitor());
            }
            if (unit.equals(this.sharedASTProvider.getActiveJavaElement())) {
                this.sharedASTProvider.disposeAST();
            }
            unit.discardWorkingCopy();
            if (JDTUtils.isDefaultProject(unit) && !(f = new File(unit.getUnderlyingResource().getLocationURI())).exists()) {
                unit.delete(true, null);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Error while handling document close. URI: " + uri, e);
        }
        return unit;
    }

    private boolean hasUnsavedChanges(ICompilationUnit unit) throws CoreException {
        if (!unit.hasUnsavedChanges()) {
            return false;
        }
        unit.getResource().refreshLocal(0, null);
        return unit.getResource().exists();
    }

    public ICompilationUnit handleSaved(DidSaveTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null) {
            JavaLanguageServerPlugin.logError(String.valueOf(uri) + " does not resolve to a ICompilationUnit");
            return unit;
        }
        if ((unit = this.checkPackageDeclaration(uri, unit)).isWorkingCopy()) {
            try {
                if (unit.getUnderlyingResource() != null && unit.getUnderlyingResource().exists()) {
                    try {
                        unit.getUnderlyingResource().refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException("Error while refreshing resource. URI: " + uri, e);
                    }
                }
                unit.discardWorkingCopy();
                unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException("Error while handling document save. URI: " + uri, e);
            }
        }
        return unit;
    }

    private ICompilationUnit checkPackageDeclaration(String uri, ICompilationUnit unit) {
        if (unit.getResource() != null && unit.getJavaProject() != null && unit.getJavaProject().getProject().getName().equals("jdt.ls-java-project")) {
            try {
                IProblem[] problems;
                CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
                IProblem[] iProblemArray = problems = astRoot.getProblems();
                int n = problems.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblem problem = iProblemArray[n2];
                    if (problem.getID() == 536871240) {
                        IPath path;
                        IResource file = unit.getResource();
                        boolean toRemove = file.isLinked();
                        if (toRemove && (path = file.getParent().getProjectRelativePath()).segmentCount() > 0 && "src".equals(path.segments()[0])) {
                            String pathStr;
                            String packageNameResource = path.removeFirstSegments(1).toString().replace("/", ".");
                            path = file.getLocation();
                            if (path != null && path.segmentCount() > 0 && (pathStr = (path = path.removeLastSegments(1)).toString().replace("/", ".")).endsWith(packageNameResource)) {
                                toRemove = false;
                            }
                        }
                        if (toRemove) {
                            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                            if (unit.equals(this.sharedASTProvider.getActiveJavaElement())) {
                                this.sharedASTProvider.disposeAST();
                            }
                            unit.discardWorkingCopy();
                            unit = JDTUtils.resolveCompilationUnit(uri);
                            unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                            this.triggerValidation(unit);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return unit;
    }
}

