/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.runner.testng;

import com.microsoft.java.test.runner.common.ITestLauncher;
import com.microsoft.java.test.runner.common.TestMessageItem;
import com.microsoft.java.test.runner.common.TestOutputStream;
import com.microsoft.java.test.runner.testng.TestNGRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestNGLauncher
implements ITestLauncher {
    @Override
    public void execute(String[] args) {
        try {
            if (args == null || args.length == 0) {
                throw new RuntimeException("No test found to run.");
            }
            TestNGRunner runner = new TestNGRunner();
            runner.run(this.parse(args));
        }
        catch (ClassNotFoundException ex) {
            TestOutputStream.instance().println(new TestMessageItem("Failed to run TestNG tests", ex));
        }
    }

    private Map<String, List<String>> parse(String[] args) throws ClassNotFoundException {
        HashMap<String, List<String>> classToMethodsMap = new HashMap<String, List<String>>();
        for (String arg : args) {
            if (arg.indexOf("#") >= 0) {
                classToMethodsMap.computeIfAbsent(TestNGLauncher.getClassNameFromMethod(arg), e -> new ArrayList()).add(TestNGLauncher.getMethodName(arg));
                continue;
            }
            classToMethodsMap.put(TestNGLauncher.getClassName(arg), new ArrayList());
        }
        return classToMethodsMap;
    }

    private static String getClassName(String clazz) throws ClassNotFoundException {
        return Class.forName(clazz, false, TestNGLauncher.class.getClassLoader()).getName();
    }

    private static String getClassNameFromMethod(String clazz) throws ClassNotFoundException {
        return Class.forName(clazz.substring(0, clazz.lastIndexOf("#")), false, TestNGLauncher.class.getClassLoader()).getName();
    }

    private static String getMethodName(String clazz) {
        return clazz.substring(clazz.lastIndexOf("#") + 1);
    }
}

