/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKeyGenerator;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.SecretKey;

final class DESedeKey
implements SecretKey {
    private static final long serialVersionUID = 2463986565756745178L;
    private byte[] key;

    DESedeKey(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    DESedeKey(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray == null || byArray.length - n < 24) {
            throw new InvalidKeyException("Wrong key size");
        }
        this.key = new byte[24];
        System.arraycopy(byArray, n, this.key, 0, 24);
        DESKeyGenerator.setParityBit(this.key, 0);
        DESKeyGenerator.setParityBit(this.key, 8);
        DESKeyGenerator.setParityBit(this.key, 16);
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return "DESede";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.key.length; ++i) {
            n += this.key[i] * i;
        }
        return n ^ "desede".hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string = ((SecretKey)object).getAlgorithm();
        if (!string.equalsIgnoreCase("DESede") && !string.equalsIgnoreCase("TripleDES")) {
            return false;
        }
        byte[] byArray = ((SecretKey)object).getEncoded();
        boolean bl = MessageDigest.isEqual(this.key, byArray);
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.key == null || this.key.length != 24) {
            throw new InvalidObjectException("Wrong key size");
        }
        this.key = (byte[])this.key.clone();
        DESKeyGenerator.setParityBit(this.key, 0);
        DESKeyGenerator.setParityBit(this.key, 8);
        DESKeyGenerator.setParityBit(this.key, 16);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            DESedeKey dESedeKey = this;
            synchronized (dESedeKey) {
                if (this.key != null) {
                    Arrays.fill(this.key, (byte)0);
                    this.key = null;
                }
            }
        }
        finally {
            super.finalize();
        }
    }
}

