% IDE support in the JDK

## Introduction

When you are familiar with building and testing the JDK, you may want to
configure an IDE to work with the source code. The instructions differ a bit
depending on whether you are interested in working with the native (C/C++) or
the Java code.

### IDE support for native code

There are a few ways to generate IDE configuration for the native sources,
depending on which IDE to use.

#### Visual Studio Code

The make system can generate a [Visual Studio Code](https://code.visualstudio.com)
workspace that has C/C++ source indexing configured correctly, as well as
launcher targets for tests and the Java launcher. After configuring, a workspace
for the configuration can be generated using:

```shell
make vscode-project
```

This creates a file called `jdk.code-workspace` in the build output folder. The
full location will be printed after the workspace has been generated. To use it,
choose `File -> Open Workspace...` in Visual Studio Code.

##### Alternative indexers

The main `vscode-project` target configures the default C++ support in Visual
Studio Code. There are also other source indexers that can be installed, that
may provide additional features. It's currently possible to generate
configuration for two such indexers, [clangd](https://clang.llvm.org/extra/clangd/)
and [rtags](https://github.com/Andersbakken/rtags). These can be configured by
appending the name of the indexer to the make target, such as:

```shell
make vscode-project-clangd
```

Additional instructions for configuring the given indexer will be displayed
after the workspace has been generated.

#### Visual Studio

The make system can generate a Visual Studio project for the Hotspot
native source. After configuring, the project is generated using:

```shell
make hotspot-ide-project
```

This creates a file named `jvm.vcxproj` in `ide\hotspot-visualstudio`
subfolder of the build output folder. The file can be opened in Visual Studio
via `File -> Open -> Project/Solution`.

#### Compilation Database

The make system can generate generic native code indexing support in the form of
a [Compilation Database](https://clang.llvm.org/docs/JSONCompilationDatabase.html)
that can be used by many different IDEs and source code indexers.

```shell
make compile-commands
```

It's also possible to generate the Compilation Database for the HotSpot source
code only, which is a bit faster as it includes less information.

```shell
make compile-commands-hotspot
```

### IDE support for Java code

#### IntelliJ IDEA

The JDK project has a script that can be used for indexing the project
with IntelliJ. After configuring and building the JDK, an IntelliJ workspace
can be generated by running the following command in the top-level folder
of the cloned repository:

```shell
bash bin/idea.sh
```

To use it, choose `File -> Open...` in IntelliJ and select the folder where
you ran the above script.

Next, configure the project SDK in IntelliJ. Open
`File -> Project Structure -> Project` and select `build/<config>/images/jdk`
as the SDK to use.

In order to run the tests from the IDE, you can use the JTReg plugin.
Instructions for building and using the plugin can be found
[here](https://github.com/openjdk/jtreg/tree/master/plugins/idea).
