/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import java.security.Provider;
import java.security.Security;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.resource.SSLSettings;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.IPropertiesPanel;
import org.eclipse.team.svn.ui.composite.SSLClientCertificatesMSCapi;
import org.eclipse.team.svn.ui.composite.SecurityWarningComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.SSLCertificateResourceVerifier;

public class SSLComposite
extends Composite
implements IPropertiesPanel {
    protected boolean callback;
    protected Button enableAuthenticationCheckBox;
    protected Text certificateFileText;
    protected Button browseButton;
    protected Text certificatePassphraseText;
    protected Button savePassphraseCheckBox;
    protected Button mscapiButton;
    protected Button aliasButton;
    protected Text aliasText;
    protected boolean mscapiSupport;
    protected IValidationManager validationManager;
    protected SSLSettings credentialsInput;

    public SSLComposite(Composite parent, int style, IValidationManager validationManager) {
        this(parent, style, validationManager, false);
    }

    public SSLComposite(Composite parent, int style, IValidationManager validationManager, boolean callback) {
        super(parent, style);
        this.validationManager = validationManager;
        this.callback = callback;
        this.credentialsInput = new SSLSettings();
    }

    public SSLSettings getSSLSettingsDirect() {
        SSLSettings settings = new SSLSettings();
        this.getSSLSettingsDirectImpl(settings);
        return settings;
    }

    public void setSSLSettingsDirect(SSLSettings settings) {
        this.savePassphraseCheckBox.setSelection(settings.isPassPhraseSaved());
        this.enableAuthenticationCheckBox.setSelection(settings.isAuthenticationEnabled());
        String text = settings.getPassPhrase();
        this.certificatePassphraseText.setText(text == null ? "" : text);
        text = settings.getCertificatePath();
        this.certificateFileText.setText(text == null ? "" : text);
        if (this.callback) {
            if (text != null && text.length() > 0) {
                this.certificatePassphraseText.setFocus();
                this.certificatePassphraseText.selectAll();
            } else {
                this.certificateFileText.setFocus();
            }
        }
        this.refreshControlsEnablement();
    }

    public void initialize() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 7;
        layout.verticalSpacing = 3;
        data = new GridData(1808);
        this.setLayout((Layout)layout);
        this.setLayoutData(data);
        this.enableAuthenticationCheckBox = new Button((Composite)this, 32);
        data = new GridData(32);
        data.horizontalSpan = 2;
        this.enableAuthenticationCheckBox.setLayoutData((Object)data);
        this.enableAuthenticationCheckBox.setText(SVNUIMessages.SSLComposite_EnableAuthentication);
        this.enableAuthenticationCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SSLComposite.this.refreshControlsEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.mscapiSupport = false;
        Provider pjacapi = Security.getProvider("CAPI");
        Provider pmscapi = Security.getProvider("SunMSCAPI");
        if (pmscapi != null) {
            try {
                ClassLoader.getSystemClassLoader().loadClass("sun.security.mscapi.NONEwithRSASignature");
            }
            catch (Exception e1) {
                pmscapi = null;
            }
        }
        String svnClientText = CoreExtensionsManager.instance().getSVNConnectorFactory().getId();
        if (FileUtility.isWindows() && (pjacapi != null || pmscapi != null) && svnClientText.contains("svnkit")) {
            this.mscapiSupport = true;
        }
        if (this.mscapiSupport) {
            this.mscapiButton = new Button((Composite)this, 32);
            data = new GridData(32);
            data.horizontalSpan = 2;
            this.mscapiButton.setLayoutData((Object)data);
            this.mscapiButton.setText("Use MSCAPI");
            SelectionAdapter mscapiSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (SSLComposite.this.mscapiButton.getSelection()) {
                        SSLComposite.this.certificateFileText.setText("MSCAPI");
                        SSLComposite.this.certificateFileText.setEnabled(false);
                        SSLComposite.this.certificatePassphraseText.setEnabled(false);
                        SSLComposite.this.browseButton.setEnabled(false);
                        SSLComposite.this.aliasButton.setEnabled(true);
                    } else {
                        SSLComposite.this.certificateFileText.setEnabled(true);
                        SSLComposite.this.certificatePassphraseText.setEnabled(true);
                        SSLComposite.this.browseButton.setEnabled(true);
                        SSLComposite.this.aliasButton.setEnabled(false);
                        SSLComposite.this.aliasText.setText("");
                        SSLComposite.this.certificateFileText.setText("");
                    }
                }
            };
            this.mscapiButton.addSelectionListener((SelectionListener)mscapiSelectionListener);
        }
        Group group = new Group((Composite)this, 0);
        group.setText(SVNUIMessages.SSLComposite_ClientCertificate);
        layout = new GridLayout();
        layout.verticalSpacing = 12;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        Composite fileAndPassphrase = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        fileAndPassphrase.setLayout((Layout)layout);
        data = new GridData(768);
        fileAndPassphrase.setLayoutData((Object)data);
        Label description = new Label(fileAndPassphrase, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(SVNUIMessages.SSLComposite_File);
        Composite inner = new Composite(fileAndPassphrase, 4);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        inner.setLayoutData((Object)data);
        this.certificateFileText = new Text(inner, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        this.certificateFileText.setLayoutData((Object)data);
        this.validationManager.attachTo((Control)this.certificateFileText, new AbstractVerifierProxy(new SSLCertificateResourceVerifier(SVNUIMessages.SSLComposite_File_Verifier, true)){

            protected boolean isVerificationEnabled(Control input) {
                return SSLComposite.this.enableAuthenticationCheckBox.getSelection();
            }
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(SVNUIMessages.Button_Browse);
        data = new GridData(128);
        data.widthHint = DefaultDialog.computeButtonWidth(this.browseButton);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog fileDialog = new FileDialog(SSLComposite.this.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    SSLComposite.this.certificateFileText.setText(res);
                    SSLComposite.this.validationManager.validateContent();
                }
            }
        });
        description = new Label(fileAndPassphrase, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(SVNUIMessages.SSLComposite_Passphrase);
        this.certificatePassphraseText = new Text(fileAndPassphrase, 0x400800);
        data = new GridData(768);
        data.widthHint = 200;
        this.certificatePassphraseText.setLayoutData((Object)data);
        if (this.mscapiSupport) {
            description = new Label(fileAndPassphrase, 0);
            data = new GridData(32);
            description.setLayoutData((Object)data);
            description.setText("Certificate Alias:");
            inner = new Composite(fileAndPassphrase, 4);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            inner.setLayout((Layout)layout);
            data = new GridData(768);
            inner.setLayoutData((Object)data);
            this.aliasText = new Text(inner, 2048);
            data = new GridData(768);
            data.widthHint = 200;
            this.aliasText.setLayoutData((Object)data);
            this.aliasText.setEnabled(false);
            this.aliasButton = new Button(inner, 8);
            this.aliasButton.setText("Select alias");
            data = new GridData(128);
            data.widthHint = DefaultDialog.computeButtonWidth(this.aliasButton);
            this.aliasButton.setLayoutData((Object)data);
            SelectionAdapter msCapiCertificateSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SSLClientCertificatesMSCapi dialog = new SSLClientCertificatesMSCapi(Display.getCurrent().getActiveShell(), "Certifacte selection");
                    if (dialog.open() == 0) {
                        SSLComposite.this.aliasText.setText(dialog.getAlias());
                        SSLComposite.this.certificateFileText.setText("MSCAPI;" + dialog.getAlias());
                    }
                }
            };
            this.aliasButton.addSelectionListener((SelectionListener)msCapiCertificateSelectionListener);
            this.aliasButton.setEnabled(false);
        }
        inner = new Composite((Composite)group, 4);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        inner.setLayoutData((Object)data);
        this.savePassphraseCheckBox = new Button(inner, 32);
        this.savePassphraseCheckBox.setText(SVNUIMessages.SSLComposite_SavePassphrase);
        new SecurityWarningComposite(inner);
    }

    public void setCredentialsInput(SSLSettings input) {
        this.credentialsInput = input;
    }

    public void saveChanges() {
        this.getSSLSettingsDirectImpl(this.credentialsInput);
    }

    public void resetChanges() {
        this.setSSLSettingsDirect(this.credentialsInput);
    }

    public void cancelChanges() {
    }

    protected void getSSLSettingsDirectImpl(SSLSettings settings) {
        settings.setAuthenticationEnabled(this.enableAuthenticationCheckBox.getSelection());
        settings.setCertificatePath(this.certificateFileText.getText());
        settings.setPassPhrase(this.certificatePassphraseText.getText());
        settings.setPassPhraseSaved(this.savePassphraseCheckBox.getSelection());
    }

    protected void refreshControlsEnablement() {
        boolean enabled = this.enableAuthenticationCheckBox.getSelection();
        if (enabled && this.mscapiSupport && this.certificateFileText != null && this.certificateFileText.getText() != null && this.certificateFileText.getText().startsWith("MSCAPI")) {
            this.certificateFileText.setEnabled(false);
            this.certificatePassphraseText.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.savePassphraseCheckBox.setEnabled(false);
            this.aliasButton.setEnabled(true);
            this.mscapiButton.setEnabled(true);
            this.mscapiButton.setSelection(true);
            String[] certAlias = this.certificateFileText.getText().split(";");
            if (certAlias.length > 1) {
                this.aliasText.setText(certAlias[1]);
            }
        } else {
            this.certificateFileText.setEnabled(enabled);
            this.browseButton.setEnabled(enabled);
            this.certificatePassphraseText.setEnabled(enabled);
            this.savePassphraseCheckBox.setEnabled(enabled);
            if (this.mscapiSupport) {
                this.mscapiButton.setEnabled(enabled);
            }
        }
        this.validationManager.validateContent();
    }
}

