/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;

public class InitExtractLogOperation
extends AbstractActionOperation {
    public static final String COMPLETE_LOG_NAME = "/changes.log";
    protected HashMap<String, List<String>> extractParticipants;
    protected String logPath;

    public InitExtractLogOperation(String logPath) {
        super("Operation_InitExtractLog", SVNMessages.class);
        this.logPath = logPath;
        this.extractParticipants = new HashMap();
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        String date = formatter.format(new Date());
        this.logImpl("");
        this.logImpl(date);
        this.logImpl("===============================================================================");
    }

    public void log(String participant, String status) {
        String toPut;
        String string = status.equals("New") ? "Added" : (toPut = status.equals("Replaced") ? "Modified" : status);
        if (this.extractParticipants.get(toPut) == null) {
            this.extractParticipants.put(toPut, new ArrayList());
        }
        this.extractParticipants.get(toPut).add(participant);
    }

    public void flushLog() {
        HashMap sortedParticipants = new HashMap();
        for (String status : this.extractParticipants.keySet()) {
            Object[] participants = this.extractParticipants.get(status).toArray(new String[0]);
            Arrays.sort(participants);
            ArrayList<Object> participantsToLog = new ArrayList<Object>();
            int i = 0;
            while (i < participants.length) {
                if (status.equals("Deleted")) {
                    boolean parentIsAlreadyLogged = false;
                    for (String string : participantsToLog) {
                        if (!((String)participants[i]).startsWith(String.valueOf(string) + "\\")) continue;
                        parentIsAlreadyLogged = true;
                        break;
                    }
                    if (!parentIsAlreadyLogged) {
                        participantsToLog.add(participants[i]);
                    }
                } else if (i + 1 >= participants.length || !((String)participants[i + 1]).startsWith(String.valueOf(participants[i]) + "\\")) {
                    participantsToLog.add(participants[i]);
                }
                ++i;
            }
            sortedParticipants.put(status, participantsToLog);
        }
        List<String> statusesList = Arrays.asList(sortedParticipants.keySet().toArray(new String[this.extractParticipants.keySet().size()]));
        Collections.sort(statusesList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.equals("Modified")) {
                    return -1;
                }
                if (o2.equals("Modified")) {
                    return 1;
                }
                if (o1.equals("Added")) {
                    return -1;
                }
                if (o2.equals("Added")) {
                    return 1;
                }
                if (o1.equals("New")) {
                    return -1;
                }
                if (o2.equals("New")) {
                    return 1;
                }
                return 0;
            }
        });
        for (String status : statusesList) {
            for (String participant : (List)sortedParticipants.get(status)) {
                this.logImpl(String.valueOf(SVNMessages.getString("Console_Status_" + status)) + " " + participant);
            }
            this.logImpl("");
        }
        this.extractParticipants.clear();
    }

    private void logImpl(String line) {
        block12: {
            OutputStreamWriter writer = null;
            try {
                try {
                    writer = new FileWriter(String.valueOf(this.logPath) + COMPLETE_LOG_NAME, true);
                    writer.write(line);
                    writer.write(System.getProperty("line.separator"));
                }
                catch (IOException iOException) {
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

