/*********************************************************************
 * Copyright (c) 2004, 2007 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

/**
 * @author Donald G. Dunne
 */
public interface ISelectedAtsArtifacts {

   Set<Artifact> getSelectedWorkflowArtifacts();

   List<Artifact> getSelectedAtsArtifacts();

   List<TaskArtifact> getSelectedTaskArtifacts();

   default Collection<TeamWorkFlowArtifact> getSelectedTeamWorkflowArtifacts() {
      List<TeamWorkFlowArtifact> teamWfs = new ArrayList<>();
      for (Artifact art : getSelectedWorkflowArtifacts()) {
         if (art instanceof TeamWorkFlowArtifact) {
            teamWfs.add((TeamWorkFlowArtifact) art);
         }
      }
      return teamWfs;
   }

}
