/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.logging;

import java.io.Serializable;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.IHealthStatus;

public class BaseStatus
implements IHealthStatus,
Serializable {
    private static final long serialVersionUID = -3767182052813764517L;
    private final Level level;
    private final Throwable th;
    private final String message;
    private final Object[] args;
    private final String sourceName;

    public BaseStatus(String sourceName, Level level, Throwable th, String message, Object ... args) {
        this.sourceName = sourceName;
        this.level = level;
        this.th = th;
        this.message = message;
        this.args = args;
    }

    public BaseStatus(String sourceName, Level level, String message, Object ... args) {
        this(sourceName, level, null, message, args);
    }

    public BaseStatus(String sourceName, Level level, Throwable th) {
        this(sourceName, level, th, th.getMessage(), null);
    }

    @Override
    public Throwable getException() {
        return this.th;
    }

    @Override
    public String getMessage() {
        String toReturn = null;
        toReturn = this.message != null && this.args != null ? String.format(this.message, this.args) : (this.message != null ? this.message : "Unavailable");
        return toReturn;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public boolean isOk() {
        return Level.INFO.intValue() >= this.getLevel().intValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.message != null) {
            sb.append(this.message);
            sb.append("\n");
        }
        sb.append(Lib.exceptionToString((Throwable)this.th));
        return sb.toString();
    }
}

