/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util.hooks;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsNotificationTransitionHook
implements IAtsTransitionHook {
    public void transitioned(IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<AtsUser> toAssignees, AtsUser asUser, IAtsChangeSet changes, AtsApi atsApi) {
        try {
            changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)AtsCoreUsers.SYSTEM_USER, (IAtsWorkItem)workItem, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Subscribed, AtsNotifyType.Completed, AtsNotifyType.Cancelled}));
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AtsNotificationTransitionHook.class, (Level)Level.SEVERE, (String)"Error adding ATS Notification Event", (Throwable)ex);
        }
    }

    public String getDescription() {
        return "Adds notification events for transitions";
    }
}

